; SCRIPT:     TICKER.SC
; Version:   6.0a
; Date:       09 April, 1995  
;
;
; TICKER contains the procedures that create a "tickertape" display of
; the stocks in the PRICE table.

PROC AddChar(s)            ; Add the next characters and display ticker
  PRIVATE l,i
  l = Len(s)               ; Need to know how many character are added to string
  FOR i FROM 1 TO l        ; so that we loop right number of times...
    Toprint = Substr(Toprint,2, 50) + Substr(s,i,1)   ; add char to ticker line
    @12,15 ?? Toprint      ; Ticker string goes on line 12
    SLEEP Delay            ; Short pause, otherwise ticker moves too fast
  ENDFOR
ENDPROC

PROC TickerTape()
  PRIVATE Toprint,x,Delay,BetweenRefresh
  Toprint = Spaces(80)
  Delay = 100
  BetweenRefresh = 5
  VIEW "price"             ; We get ticker info from the PRICE table
  WHILE (TRUE)             ; Loop until user presses character
    SCAN                   ; Use SCAN to move through stocks in table
      IF (Charwaiting())      ; Did user press a key?
        THEN  x = Getchar()   ; Yes, so let's see what they typed
          while (Charwaiting())
              Y = Getchar()
          endwhile
          SWITCH
            CASE x = 45:          ; a minus was typed
              Delay = Delay + 50  ; meaning they want the ticker slower
            CASE x = 43:          ; a plus was typed
              Delay = Max(Delay-50,0)  ; so make the ticker faster
            OTHERWISE:        ; user wants to leave
              CLEARALL RETURN ;   Clear up the workspace and go back to Main menu
          ENDSWITCH
      ENDIF                   ; No, so continue SCAN
      IF (Mod(Recno(),BetweenRefresh) = 1)
        THEN REFRESH          ; Refresh every BetweenRefresh records
      ENDIF
      AddChar([Ticker] + " " + strval([Price]) +  "   ") ; Add stock name and price to ticker
    ENDSCAN
  ENDWHILE
ENDPROC

; DoTicker is the controlling procedure and performs a few housekeeping
; chores before calling the routine to display stock information.

PROC CLOSED DoTicker()
  CLEAR                     ; PAL canvas needs to be cleared for ticker
  CURSOR OFF                ; Cursor not needed in this subsystem, so turn it off
  PAINTCANVAS ATTRIBUTE 0 12,14,14,70        ; for Shadow Box
  PAINTCANVAS FILL (" ") 12,13,13,67         ; clear window
  PAINTCANVAS BORDER FILL(" ") ATTRIBUTE 78 11,12,13,68   ; for frame
  TickerTape()              ; and start the tape...
  CLEAR                     ; Get ticker off display before going back to Main menu
ENDPROC
