; SCRIPT:     PORTFOL.SC
; Version:   6.0a
; Date:       09 April, 1995  
;
;
; This script defines the procedures that display a summary of holdings
; in a specific portfolio (as requested by the user). It functions
; in a similar manner to HOLDINGS.

PROC PortMenu()
CLEAR
PAINTCANVAS ATTRIBUTE 31 0,0,24,79
STYLE ATTRIBUTE 30
@5,0
TEXT
ͻ
  STOCKS APPLICATION  PORTFOLIO MENU  
Ķ
  Auto Industry     Use Auto Industry Portfolio.                             
͹
  Blue Chip         Use Blue Chip Portfolio.                                 
͹
  High Tech         Use High Tech Industry Portfolio.                        
͹
  MainMenu          Exit Porfolio Menu and return to Main Menu.              
ͼ
ENDTEXT
PAINTCANVAS ATTRIBUTE 78 6,7,6,24
PAINTCANVAS ATTRIBUTE 46 6,52,6,65
STYLE
ENDPROC

PROC CLOSED SpecificPort()
  PRIVATE x
  Cursor OFF
  IF (NOT AskPortName())               ; Get a portfolio name from user
    THEN RETURN                        ; User didn't supply name, so return
  ENDIF
  WHILE (NOT Charwaiting())            ; For as long as user doesn't press key
    CLEARALL                           ; | - clear the workspace
    SpecQuery1()                       ; | - put the portfolio query on workspace
    WHILE (TRUE)                       ; |
      LOCK "Price" WL                  ; | - can we get the table?
      IF (retval) THEN QUITLOOP ENDIF  ; |  yes, so go on
      SLEEP 500                        ; |  no, so pause before retrying
    ENDWHILE                           ; |
    DO_IT!                             ; | - process the query
    UNLOCK "Price" WL                  ; | - give up lock on table
    CLEARALL                           ; |
    VIEW "Answer"                      ; | - take the resultant ANSWER table and...
    MOVETO [Total Share Price]         ; |
    MOVETO [Ticker]                    ; |
    ECHO NORMAL                        ; | - turn on ECHO to see results
    PROMPT "Portfolio for " + portname + " as of " + Time(),
           "Total Portfolio value is $" +
           FORMAT("W12,AL,EC",Csum("Answer", "Total Share Price")) +
           "   --      Press Any Key to Quit"
    ECHO OFF                           ; | - turn off ECHO so user doesn't see next query
 ENDWHILE                              ; Return to top of the loop

; If we drop out of above loop, user must have pressed a key

 x = Getchar()                         ; Gobble up the keystroke
 CLEARALL                              ; And erase the workspace
 CLEAR                                 ;    ...and canvas
ENDPROC

; SpecQuery1 puts the query that does all the work onto the workspace.
; Note:
;    - the tilde variable ~portname supplies the portfolio name
;    - calc _p * _sh calculates total value for a stock

PROC SpecQuery1()

QUERY

 Price |   TICKER    |  PRICE   |  LAST  |
       | Check _tick | Check _p | Check  |

 Holding | PORTFOLIO | SYMBOL |          SHARES                               |
         | ~portname | _tick  | Check _sh, calc _p * _sh as Total Share Price |

ENDQUERY
ENDPROC

; AskPortName does the job of requesting and accepting from the user the
; name of the portfolio to display a summary of.

PROC AskPortName()
  PRIVATE n,Nams,Prompts
  ; First we must get the names of the Portfolios
  MENU {Ask} SELECT "Holding"        ; HOLDING table has names of portfolios
  MOVETO [Portfolio]                 ; Portfolio names are in Portfolio Field
  CHECK                              ; So CHECK that field
  DO_IT!                             ; and perform a query to get names into table
  n = Nrecords("Answer")             ; User has n portfolios (names now in Answer)
  ARRAY Nams[n+1]                    ; Create an array to put the names into
  ARRAY Prompts[n+1]                 ; And another array to store prompts for names
  SCAN                               ; SCAN through each record of Answer to fill arrays
    Nams[ Recno() ]    = [Portfolio]
    Prompts[ Recno() ] = "Use the " + [Portfolio] + " portfolio"
  ENDSCAN
  Nams[n+1] = "MainMenu"
  Prompts[n+1] = "Exit out of Portfolio Menu and return to Main Menu"
  CLEARALL

  CANVAS OFF
   PortMenu()                         ; Print Portfolio Menu Box
  CANVAS ON
  SHOWARRAY Nams Prompts TO Portname  ; Display portfolio names in a Paradox-style menu
  RETURN(Portname <> "Esc" and Portname <> "MainMenu")

ENDPROC
