; SCRIPT:     HOLDINGS.SC
; Version:   6.0a
; Date:       09 April, 1995  
;
;
; The Holdings selection uses queries to find out the current aggregate
; value of your portfolios.  Note how the queries are used to full
; advantage to reduce the amount of programming necessary to summarize
; the information. PortAggr is the controlling procedure.

PROC CLOSED PortAggr()
  CLEAR                       ; PAL canvas should be clear when we start

  WHILE NOT Charwaiting()     ; Keep updating until user presses a key
    Portpric()                ; The first query gets current prices for our portfolio
    WHILE (TRUE)
      LOCK "Price" WL         ; Can we get Price table?
      IF (retval) THEN QUITLOOP ENDIF ; yes, so go on
      SLEEP 500               ; pause before trying again
    ENDWHILE
    DO_IT!                    ; perform the query
    UNLOCK "Price" WL
    PortSum()  DO_IT!         ; The second query summarizes the information obtained from the first query
    CLEARALL                  ; Done with queries, get them off the workspace
    VIEW "Answer"             ; But put the summary information (query 2) back on
    ECHO NORMAL               ; Turning ECHO NORMAL lets us see the workspace in PROMPT command
    PROMPT "Portfolio Pricing System - Using Real Time Feed",
           "Latest update time is " + TIME() + "  --  Any key to stop"
    ECHO OFF                  ; Turning ECHO OFF insures that next query won't be seen!
  ENDWHILE

; If we get here, user must have pressed a key (and wants to leave module)

  x=Getchar()           ; Gobble up the character
  CLEARALL              ; Clear up the workspace
ENDPROC

; PortPric puts a query regarding our current portfolio and the current
; main board information onto the workspace.

PROC PortPric()
QUERY

 Price | TICKER | PRICE |  LAST  |
       | _tick  | _p    | Check  |

 Holding | PORTFOLIO |   SYMBOL    |       SHARES       |
         | Check     | Check _tick | _sh, calc _p * _sh |

ENDQUERY
ENDPROC

; PortSum puts a query onto the workspace that takes the information
; from the PortPric query (now in the ANSWER table) and summarizes it
; for display. Note the following:
;    - calc max: last update occurred when the last stock traded
;    - calc count: number of stocks in the portfolio
;    - calc sum: value of the portfolio as of last update

PROC PortSum()

QUERY

 Answer | LAST                      | PORTFOLIO |   SYMBOL   | PRICE * SHARES                |
        | calc max as "Last Update" | Check     | calc count | calc sum as Total Share Price |

ENDQUERY

ENDPROC
