;SCRIPT:       BOARD.SC
;Version:     6.0a
;Date:         09 April, 1995  
;
;
; The procedures in this script handle the display of the "main board,"
; the table of stocks shown with real-time updates. Since the table may
; be larger than one display screen in length, it is shown in "pages,"
; with each page being displayed for a short period of time before moving
; on to the next page.
;
; SeeBoard is the main procedure here, and controls the initial display
; of the "main board." It uses the ShowNSleep procedure to display
; additional pages of the board, if any.

PROC CLOSED SeeBoard()
  PRIVATE nstocks,nscreens,i
  CLEARALL                 ; make sure that the workspace is clear
  VIEW "price"             ; Main Board consists of the Price table shown in real time
  MOVETO [Chg]
  MOVETO [Ticker]          ; position so that Ticker is first field showing
  ECHO NORMAL
  PROMPT "Real Time Stock Feed", "Press Any Key to Quit"
  nstocks = Nrecords("Price")              ; How many stocks to display?
  IF (MOD(nstocks, 22) <> 0)               ; We can fit 22 stocks on a screen
     THEN nscreens = Int(nstocks/22) + 1   ;   Need extra screen for spillover
     ELSE nscreens = nstocks/22            ;   No spillover stocks
  ENDIF

  WHILE (NOT Charwaiting())           ; If user types anything, leave
    IF (nscreens > 1)                 ; Only need to use ShowNSleep if more than 1 screen
      THEN
        ShowNSleep("Down", nscreens)
        ShowNSleep("Up", nscreens)
      ELSE SleepRefresh()             ; Update the information on the single screen
    ENDIF
  ENDWHILE

; To get here, user must have typed a character:

  ECHO OFF                            ; No more updating needed

  x = Getchar()                       ; Gobble up the character typed
  CLEARALL                            ; Clear the workspace
ENDPROC

; ShowNSleep steps through the "main board" screens one at a time,
; using SleepRefresh to pause and refresh the information displayed.

PROC ShowNSleep(Direction, TotScreen)
  FOR i FROM 1 TO TotScreen-1         ; For each screen we have to display
    IF (Charwaiting())                ; | - Make sure user didn't ask to leave
      THEN RETURN                     ; |
    ENDIF                             ; |
    SleepRefresh()                    ; | - Display and update the information
    IF (Direction = "Up")             ; |
       THEN PGUP                      ; | - Move to previous page if we're heading back
       ELSE PGDN                      ; | - Move to next page if we're heading forward through pages
    ENDIF                             ; v
  ENDFOR
ENDPROC

; SleepRefresh performs a 3 second SLEEP with an explicit table refresh
; in the middle of the period

PROC SleepRefresh()
  SLEEP 1500               ; SLEEP for 1.5 seconds
  REFRESH                  ; Force an update of the information
  SLEEP 1500               ; SLEEP for 1.5 more seconds
ENDPROC
