program contributions;
{Uses a transaction file to update a master.}
{Assumes master file is not empty.}
type
  masterrec = record
    name: string;
    occupation: string;
    tot: longint
  end; {masterrec}
  transrec = record
    name: string;
    amt: longint
  end; {transrec}
var mastfile: file of masterrec;
    transfile: file of transrec;
    master: masterrec;
    trans: transrec;

begin
  assign (mastfile, 'master.dat');
  reset (mastfile);
  assign (transfile, 'trans.dat');
  reset (transfile);
  read (mastfile, master);
  while not eof(transfile) do
    begin
      read (transfile, trans);
      while(master.name < trans.name)  and (not eof(mastfile)) do
        read (mastfile, master);
      if master.name = trans.name then
        begin
          master.tot := master.tot + trans.amt;
          seek (mastfile, filepos(mastfile) - 1);
          write (mastfile, master)
        end {then}
      else
        writeln (trans.name, 'NOT FOUND')
    end; {while}
  close (mastfile);
  close (transfile)
end.
