program salary_study;
{allows the user to receive a report on all employees or}
{just those with salary above a certain input amount.}
uses printer;
const maxsize = 100;
type
  employeerec = record
    name: string[20];
    salary: real;
    case educode: char of
      'C': (college: string[20];
            GPA: real;
            major: string[20]);
      'H': (HighSchool: string[20]);
      'D': (LastGrade: integer)
  end; {employeerec}
  employee_array = array [1..maxsize] of employeerec;
var
  employees: employee_array;
  size, answer: integer;

procedure GETDATA (var employees: employee_array;
                   var size: integer);
  {reads file into an array of variant records.}
  var infile: text;
  begin
    assign (infile, 'employees.dat');
    reset (infile);
    size := 0;
    while not seekeof (infile) do
      begin
        size := size + 1;
        with employees[size] do
          begin
            readln (infile, name);
            readln (infile, salary);
            readln (infile, educode);
            case educode of
              'C': begin
                     readln (infile, college);
                     readln (infile, GPA);
                     readln (infile, major)
                   end;
              'H': readln (infile, HighSchool);
              'D': readln (infile, LastGrade)
            end {case}
        end {with}
      end; {while}
    close (infile)
  end; {GETDATA}


procedure PRINT_ONE_REC (employee: employeerec);
  {prints the record of the employee}
  begin
    with employee do
      begin
        writeln (name, '  $', salary:6:0);
        case educode of
          'C': writeln ('  ', college, '  ', GPA:3:2, ' GPA ', major);
          'H': writeln ('  ', HighSchool);
          'D': writeln ('Dropout  Completed through Grade ', LastGrade)
        end
      end
  end; {PRINT_ONE_REC}

procedure PRINT_ALL (employees: employee_array;
                     size: integer);
  {prints the record of each employee in the array.}
  var i: integer;
  begin
    for i := 1 to size do
      PRINT_ONE_REC (employees [i])
  end; {PRINT_ALL}

procedure ABOVE_SAL (employees: employee_array;
                     size: integer);
  var WantedSalary: real;
      i: integer;
  begin
    write ('Employees earning over $');
    readln (WantedSalary);
    for i := 1 to size do
        with employees[i] do
          if salary > WantedSalary then
            begin
              writeln (name, '  $', salary:6:0);
              case educode of
                'C': writeln ('  ', college, '  ', GPA:3:2, ' GPA   ', major);
                'H': writeln ('  ', HighSchool);
                'D': writeln ('Dropout  Completed through Grade ', LastGrade)
              end
            end
  end; {ABOVE_SAL}

begin {main}
  GETDATA (employees, size);
  writeln ('Type  1) if you want all employee records');
  writeln ('Type  2) if you want those above certain salary');
  readln (answer);
  if answer = 1 then PRINT_ALL (employees, size)
                else ABOVE_SAL (employees, size)
end.
