program hangman;
{plays one game of fortune hangman}
var WordSoFar, word, WrongList: string;
    earnings, SpinAmt : integer;

procedure SELECTWORD (var word: string);
  {pick a word at random from file}
  var i, num: integer;
      WordFile: text;
  begin
    assign (WordFile, 'words.dat');
    reset (WordFile);
    num:= random(25) + 1;
    for i := 1 to num do
      readln (WordFile, word);
    close (WordFile);
  end; {SELECTWORD}

procedure INITIALIZE (word: string;
                      var WordSoFar, WrongList: string;
                      var earnings: integer);
  const null = '';
        dash = '-';
  var i: integer;
  begin
    WordSoFar := null;
    for i := 1 to length(word) do
      WordSoFar := WordSoFar + dash;
    WrongList := null;
    earnings := 0
  end; {INITIALIZE}

procedure GUESS_PROMPT (WordSoFar, WrongList: string;
                        var SpinAmt: integer);
  {print status of game and prompt for guesses}
  begin
    writeln;
    SpinAmt := 100 * (random(5) + 1);
    writeln ('Word so far:  ',WordSoFar);
    writeln ('   Incorrect guesses  ',WrongList);
    writeln ('   This guess is worth $ ',SpinAmt);
    write ('   Pick a letter ')
  end; {GUESS_PROMPT}

procedure PROCESS_GUESS (SpinAmt: integer;
                         word: string;
                         var WordSoFar, WrongList: string;
                         var earnings: integer);
  {read in a player's guess and process it}
  var i, count: integer;
      guess: char;
  begin
    readln (guess);
    count := 0;
    for i := 1 to length(word) do
      if word[i] = guess then
        begin
          WordSoFar[i] := guess;
          count := count + 1
        end;
    if count > 0 then earnings := earnings + count * SpinAmt
                 else WrongList := WrongList + guess
  end; {PROCESS_GUESS}

begin {main body}
  randomize;
  SELECTWORD (word);
  INITIALIZE (word, WordSoFar, WrongList, earnings);
  repeat
    GUESS_PROMPT (WordSoFar, WrongList, SpinAmt);
    PROCESS_GUESS (SpinAmt, word, WordSoFar, WrongList, earnings);
  until (length(WrongList) = 8) or (word = WordSoFar);
  if word = WordSoFar
     then writeln ('Congratulations!  You won $ ',earnings)
     else writeln ('Sorry, you lost.  The word was ',word)
end.