program voting;
{processes the vote.dat file and prints each candidate's tally}
type voterange = 1..4;
     cntstype = array[voterange] of integer;
var votecnts: cntstype;

procedure INITIALIZE (var votecnts: cntstype);
  var i: voterange;
  begin
    for i := 1 to 4 do
      votecnts[i] := 0;
  end;  {INITIALIZE}

procedure PROCESS (var votecnts: cntstype);
  {reads in each individual vote from the external file}
  {and updates appropriate counter}
  var vote: voterange;
      votefile: text;
  begin
    assign (votefile, 'vote.dat');
    reset (votefile);
    while not seekeof (votefile) do
      begin
        readln (votefile, vote);
        if (vote >= 1) and (vote <=4)
          then votecnts[vote] := votecnts[vote] + 1
          else writeln(' Invalid vote ')
      end; {while}
    close (votefile)
  end; {PROCESS}

procedure PRINTRESULTS (votecnts: cntstype);
  {prints the number of votes for each candidate}
  var i: voterange;
  begin
    writeln ('CANDIDATE':9, 'NO. OF VOTES':16);
    for i := 1 to 4 do
      writeln (i:5, votecnts[i]:15)
  end; {PRINTRESULTS}

begin {main}
  INITIALIZE (votecnts);
  PROCESS (votecnts);
  PRINTRESULTS (votecnts)
end.