// Copyright (c) 1993 Rhino Publishing Ltd. All Rights Reserved

// Comments
#include "oops.ch"                     // required for oops syntax extensions

class point
   var row                             // the current row
   var col                             // the current column
   var char                            // character to display

   message init( row, col)             // initialise the object
   message up()                        // move the point up
   message down()                      // move the point down
   message left method moveleft()      // move left, note left if reserved word
	message right method moveright()		// move right, note right is reserved word
	message display()
end class

method init(row,col)
   ::row := row
   ::col := col
	::char := "."								// default to a point
return( self )                         // always do this in an initialisation routine

method up()
   ::row --
return( self )

method down()
   ::row ++
return( self )

method moveRight()
   ::col ++
return( self )
method moveleft()
   ::col--
return( self )
method display()
	@ ::row, ::col say ::char
return( self )
