// Copyright (c) 1993 Rhino Publishing Ltd. All Rights Reserved
#include "inkey.ch"
#include "oops.ch"
memvar getlist
// Database File: SAMPLE\CUSTOMER.DBF
// FieldName  Type  Width  Decimals
// CODE         C    06      000
// NAME         C    60      000
// ADD1         C    45      000
// ADD2         C    45      000
// TOWN         C    45      000
// CITY         C    45      000
// POSTCODE     C    15      000
// PHONE        C    15      000
// FAX          C    15      000

class customer inherit standdbf		// Inherit the Standard Stuff
	var code									// Customer Fields
	var Name
	var add1
	var add2
	var town
	var city
	var postcode
	var phone
	var fax
	message init()                   // Initialise / open table
	message edit()                   // edit the current ivars
	message fetch()                  // read ivars from fields
	message put()                    // save ivars to current record
	message display( keepGets )
end class

method init()
	select 0
	use customer
	if ! file("custcode"+indexext() )
		index on customer->code to custcode
	else
		set index to custcode
	endif
	::stdColour := setcolor()
	::workArea := alias()
	::fetch()							// read the record in
return( self )

method edit()
	::display( .t. )				// keep the gets
	read
	if lastkey() != K_ESC		// then update it
		::put()
	endif
return( self )

method display( keepGets )
	if keepGets == nil
		keepGets := .f.			// default to false
	endif
	setcolor( ::stdColour )
	cls
	@  2, 2 say "Code     " get  ::code
	@  4, 2 say "Name     " get  ::Name
	@  6, 2 say "Add1     " get  ::add1
	@  8, 2 say "Add1     " get  ::add1
	@ 10, 2 say "Town     " get  ::town
	@ 12, 2 say "City     " get  ::city
	@ 14, 2 say "Postcode " get  ::postcode
	@ 16, 2 say "Phone    " get  ::phone
	@ 18, 2 say "Fax      " get  ::fax
	if ! keepGets
		clear gets
	endif
return( self )

method fetch
	select (::workArea )
	::CODE      := CUSTOMER->CODE
	::NAME      := CUSTOMER->NAME
	::ADD1      := CUSTOMER->ADD1
	::ADD2      := CUSTOMER->ADD2
	::TOWN      := CUSTOMER->TOWN
	::CITY      := CUSTOMER->CITY
	::POSTCODE  := CUSTOMER->POSTCODE
	::PHONE     := CUSTOMER->PHONE
	::FAX       := CUSTOMER->FAX
return( self )

method put
	select (::workArea )
   CUSTOMER->CODE     :=   ::CODE
   CUSTOMER->NAME     :=   ::NAME
   CUSTOMER->ADD1     :=   ::ADD1
   CUSTOMER->ADD2     :=   ::ADD2
   CUSTOMER->TOWN     :=   ::TOWN
   CUSTOMER->CITY     :=   ::CITY
   CUSTOMER->POSTCODE :=   ::POSTCODE
   CUSTOMER->PHONE    :=   ::PHONE
   CUSTOMER->FAX      :=   ::FAX
return( self )




