#include 'box.ch'
#include 'inkey.ch'
#include 'oops.ch'
#include 'mouseven.ch'

Static cBackScreen

#translate self:Next() => BoxMenNext( Self )
#translate self:Previous() => Previous( Self )
#translate self:First() => First( Self )
#translate self:Last() => LastOption( Self )

Function MenuBoxNew()
   Local oBoxMenu := BoxMenu():Init()
Return oBoxMenu

Class BoxMenu
   Var Top,Left,Bottom,Right
   Var Image
   Var Prompts
   Var Prompt
   Var Current
   Var Color
   Var Active
   Message Init()
   Message Display()
   Message Vanish() ACTION {|Self|RestScreen( ::Top,::Left,::Bottom,::Right,cBackScreen ) }
   Message AddPrompt( oPrompt )
   Message AddLine()
   Message Next() Method BoxMenNext()
   Message Previous()
   Message First()
   Message Last() Method LastOption()
   Message Key( nKey,nExtras )
   Message Hit( nRow,nCol ) ACTION {|Self,nRow,nCol| nRow >= ::Top .and. nRow <= ::Bottom .and. nCol >= ::Left .and. nCol <= ::Right} 
End Class

Method Init()
   ::Prompts := {}
   ::Color := 'N/W'
   ::Current := 1
   ::Active := .F.
Return Self

Method AddPrompt( oPrompt )
   oPrompt:Menu := Self
   oPrompt:Top := oPrompt:Bottom := ::Top+1+Len( ::Prompts )
   oPrompt:Right := ::Right-1
   oPrompt:Left := ::Left+1
   AADD( ::Prompts,oPrompt )
Return NIL

Method AddLine()
   Local oLine := MenuLine()
   oLine:Top := oLine:Bottom := ::Top+1+Len( ::Prompts )
   oLine:Left := ::Left
   oLine:Right := ::Right
   AADD( ::Prompts,oLine )
Return NIL

Method Display()
   Local oPrompt,i
   cBackScreen := SaveScreen( ::Top,::Left,::Bottom,::Right )
   If ::Image = NIL
      @ ::Top,::Left,::Bottom,::Right Box B_SINGLE+' ' Color ::Color
      For i = 1 To Len( ::Prompts )
         oPrompt := ::Prompts[i]
         If oPrompt:IsPrompt()
            oPrompt:Status := EVAL( oPrompt:When )
         Endif
         oPrompt:Display()
      Next i
      ::Image := SaveScreen( ::Top,::Left,::Bottom,::Right )
   Else
      RestScreen( ::Top,::Left,::Bottom,::Right,::Image )
      For i = 1 To Len( ::Prompts )
         oPrompt := ::Prompts[i]
         If oPrompt:IsPrompt()
            If !( oPrompt:Status = EVAL( oPrompt:When ) )
               oPrompt:Status := EVAL( oPrompt:When )
               oPrompt:Display()
            Endif
         Endif
      Next i
      ::Image := SaveScreen( ::Top,::Left,::Bottom,::Right )
   Endif
Return NIL

Method BoxMenNext()
   If ::Current = Len( ::Prompts )
      ::First()
   Else
      ::Prompts[::Current]:Display()
      ::Current ++
      If !::Prompts[ ::Current ]:IsPrompt()
         ::Next()
      Else
         ::Prompts[ ::Current ]:Hilite()
      Endif
   Endif
Return NIL

Method Previous()
   If ::Current = 1
      ::Last()
   Else
      ::Prompts[::Current]:Display()
      ::Current --
      If !::Prompts[ ::Current ]:IsPrompt()
         ::Previous()
      Else
         ::Prompts[ ::Current ]:Hilite()
      Endif
   Endif
Return NIL

Method First()
   If ::Current > 0
      ::Prompts[ ::Current ]:Display()
   Endif
   ::Current := 1
   ::Prompts[ ::Current ]:HiLite()
Return NIL

Method LastOption()
   If ::Current > 0
      ::Prompts[ ::Current ]:Display()
   Endif
   ::Current := Len( ::Prompts )
   ::Prompts[ ::Current ]:Hilite()
Return NIL

Method Key( nKey,nExtras )
   Local nPrompt
   If ::Current = 0
      ::First()
   Endif
   Do Case
   Case nKey = K_F1 .and. nExtras = 0
      SetHelpTopic('MENU '+Str(::Prompt:Menu:Current,2)+Str(::Current,3))
      DISPEND()
      DefineHelp()
      DISPBEGIN()
      SetHelpTopic('NORMAL')
   Case nKey = K_HOME .and. nExtras = 0
      ::First()
   Case nKey = K_END .and. nExtras = 0
      ::Last()
   Case nKey = K_UP .and. nExtras = 0
      ::Previous()
   Case nKey = K_DOWN .and. nExtras = 0
      ::Next()
   Case nKey = K_ENTER .and. nExtras = 0
      If ::Prompts[ ::Current ]:Status
         ::Active := .F.
         ::Prompt:Menu:Active := .F.
         ::Vanish()
         ::Prompt:Display()
         PullTopObject()
         DISPEND()
         DISPBEGIN()
         SetBlock( ::Prompts[ ::Current ]:Action )
         InMenu( .F. )
      Endif
   Case  ( nPrompt := ASCAN( ::Prompts,{|x| IF( x:IsPrompt(),Upper( x:Key ) = Upper( Chr( nKey ) ) .and. EVAL( x:When ),.F.) } ) ) > 0
      ::Prompts[ ::Current ]:Display()
      ::Current := nPrompt
      ::Prompts[ nPrompt ]:Hilite()
      If ::Prompts[ nPrompt ]:Status := EVAL( ::Prompts[ nPrompt ]:When )
         ::Active := .F.
         ::Prompt:Menu:Active := .F.
         ::Vanish()
         ::Prompt:Display()
         PullTopObject()
         DISPEND()
         DISPBEGIN()
         SetBlock( ::Prompts[ ::Current ]:Action )
         InMenu( .F. )
      Endif
   Case nKey = K_LEFT .and. nExtras = 0
      SetTopObject( ::Prompt:Menu )
      SetRetry()
   Case nKey = K_RIGHT .and. nExtras = 0
      SetTopObject( ::Prompt:Menu )
      SetRetry()
   Case nKey = K_ESC .and. nExtras = 0
      SetTopObject( ::Prompt:Menu )
      SetRetry()
   EndCase
Return NIL
