/***
*	BMGetsys.prg
*
*	NOTE: compile with /m/n/w
*/

#include "Set.ch"
#include "Inkey.ch"
#include "Getexit.ch"

#define K_UNDO          K_CTRL_U


// state variables for active READ
static Format
static Updated := .f.
static KillRead
static BumpTop
static BumpBot
static LastExit
static LastPos
static ActiveGet
static ReadProcName
static ReadProcLine

// BM Statics
Static BMBorder
Static BMHeadSep
Static BMFootSep
Static BMColSep

Static oBMBrowse


// format of array used to preserve state variables
#define GSV_KILLREAD		1
#define GSV_BUMPTOP			2
#define GSV_BUMPBOT			3
#define GSV_LASTEXIT		4
#define GSV_LASTPOS			5
#define GSV_ACTIVEGET		6
#define GSV_READVAR 		7
#define GSV_READPROCNAME	8
#define GSV_READPROCLINE	9

#define GSV_COUNT			9



/***
*	ReadModal()
*	Standard modal READ on an array of GETs.
*/
func Readit( GetList )

local get
local pos
local savedGetSysVars


	if ( ValType(Format) == "B" )
		Eval(Format)
	end

	if ( Empty(getList) )
		// S87 compat.
        SetPos( MaxRow()-1, 0 )
		return (.f.)			// NOTE
	end


	// preserve state vars
	savedGetSysVars := BMClearGetSysVars()

	// set these for use in SET KEYs
	ReadProcName := ProcName(1)
	ReadProcLine := ProcLine(1)


	// set initial GET to be read
	pos := BMSettle( Getlist, 0 )

   Set Cursor On

	while ( pos <> 0 )

		// get next GET from list and post it as the active GET
		get := GetList[pos]
		BMPostActiveGet( get )


		// read the GET
		if ( ValType( get:reader ) == "B" )
			Eval( get:reader, get ) 		// use custom reader block
		else
			BMGetReader( get )				// use standard reader
		end


		// move to next GET based on exit condition
		pos := BMSettle( GetList, pos )

	end


	// restore state vars
	BMRestoreGetSysVars(savedGetSysVars)

	// S87 compat.
   SetPos( MaxRow()-1, 0 )
   Set Cursor Off

return (Updated)



/***
*	GetReader()
*	Standard modal read of a single GET.
*/
Static func BMGetReader( get )


   // activate the GET for reading
   get:exitState := GE_NOEXIT

   get:SetFocus()

	while ( get:exitState == GE_NOEXIT )

		// check for initial typeout (no editable positions)
		if ( get:typeOut )
			get:exitState := GE_ENTER
       end

		// apply keystrokes until exit
       while ( get:exitState == GE_NOEXIT )
          If PROCNAME(2) = 'BROWSEEDIT'
             Do Case
             Case UPPER(get:Name) = 'CBORDER'
                DrawBMBox(1,get)
             Case UPPER(get:Name) = 'CHEADSEP'
                DrawBMBox(2,get)
             Case UPPER(get:Name) = 'CCOLSEP' 
                DrawBMBox(3,get)
             Case UPPER(get:Name) = 'CFOOTSEP'
                DrawBMBox(4,get)
             Otherwise
                DrawBMBox(0,get)
             EndCase
          Endif

	       BMGetApplyKey( get, Inkey(0) )
		end

		// disallow exit if the VALID condition is not satisfied
		if ( !BMGetPostValidate(get) )
			get:exitState := GE_NOEXIT
		end

	end

	// de-activate the GET
	get:KillFocus()

return NIL



/***
*	GetApplyKey()
*	Apply a single Inkey() keystroke to a GET.
*
*	NOTE: GET must have focus.
*/
Static proc BMGetApplyKey(get, key)

local cKey
local bKeyBlock


	// check for SET KEY first
	if ( (bKeyBlock := SetKey(key)) <> NIL )

		BMGetDoSetKey(bKeyBlock, get)
		return									// NOTE

	end


   do case
   case( key == K_F1 )
       DefineHelp( UPPER(get:Name) )

	case ( key == K_UP )
		get:exitState := GE_UP

	case ( key == K_SH_TAB )
		get:exitState := GE_UP

	case ( key == K_DOWN )
		get:exitState := GE_DOWN

	case ( key == K_TAB )
		get:exitState := GE_DOWN

	case ( key == K_ENTER )
		get:exitState := GE_ENTER

	case ( key == K_ESC )
		if ( Set(_SET_ESCAPE) )
			get:undo()
			get:exitState := GE_ESCAPE
		end

	case ( key == K_PGUP )
		get:exitState := GE_WRITE

	case ( key == K_PGDN )
		get:exitState := GE_WRITE

	case ( key == K_CTRL_HOME )
		get:exitState := GE_TOP


#ifdef CTRL_END_SPECIAL

	// both ^W and ^End go to the last GET
	case (key == K_CTRL_END)
		get:exitState := GE_BOTTOM

#else

	// both ^W and ^End terminate the READ (the default)
	case (key == K_CTRL_W)
		get:exitState := GE_WRITE

#endif


	case (key == K_INS)
	    Set( _SET_INSERT ,!SET(_SET_INSERT) )

	case (key == K_UNDO)
		get:Undo()

	case (key == K_HOME)
		get:Home()

	case (key == K_END)
		get:End()

	case (key == K_RIGHT)
		get:Right()

	case (key == K_LEFT)
		get:Left()

	case (key == K_CTRL_RIGHT)
		get:WordRight()

	case (key == K_CTRL_LEFT)
		get:WordLeft()

	case (key == K_BS)
		get:BackSpace()

	case (key == K_DEL)
		get:Delete()

	case (key == K_CTRL_T)
		get:DelWordRight()

	case (key == K_CTRL_Y)
		get:DelEnd()

	case (key == K_CTRL_BS)
		get:DelWordLeft()

	otherwise

		if (key >= 32 .and. key <= 255)

			cKey := Chr(key)

			if (get:type == "N" .and. (cKey == "." .or. cKey == ","))
				get:ToDecPos()

			else
				if ( Set(_SET_INSERT) )
					get:Insert(cKey)
				else
					get:Overstrike(cKey)
				end

				if (get:typeOut .and. !Set(_SET_CONFIRM) )
					if ( Set(_SET_BELL) )
						?? Chr(7)
					end

					get:exitState := GE_ENTER
				end

			end

		end

	endcase

return



/***
*	GetPostValidate()
*	Test exit condition (VALID clause) for a GET.
*
*	NOTE: bad dates are rejected in such a way as to preserve edit buffer.
*/
static func BMGetPostValidate(get)

local saveUpdated
local changed, valid := .t.


	if ( get:exitState == GE_ESCAPE )
		return (.t.)					// NOTE
	end


	// if editing occurred, assign the new value to the variable
	if ( get:changed )
		get:Assign()
		Updated := .t.
	end


	// reform edit buffer, set cursor to home position, redisplay
	get:Reset()


	// check VALID condition if specified
	if ( get:postBlock <> NIL )

		saveUpdated := Updated

		// S87 compat.
        SetPos( get:row, get:col + Len(get:buffer) )

		valid := Eval(get:postBlock, get)

		// reset compat. pos
		SetPos( get:row, get:col )

		get:UpdateBuffer()

		Updated := saveUpdated

		if ( KillRead )
			get:exitState := GE_ESCAPE	// provokes ReadModal() exit
			valid := .t.
		end

	end

return (valid)




/***
*	GetDoSetKey()
*	Process SET KEY during editing.
*/
static proc BMGetDoSetKey(keyBlock, get)

local saveUpdated
local nPos


	// if editing has occurred, assign variable
	if ( get:changed )
		get:Assign()
		Updated := .t.
	end


   saveUpdated := Updated
   nPos := get:Pos
   BMGetPostValidate( get )
   get:Pos := nPos
	Eval(keyBlock, ReadProcName, ReadProcLine, ReadVar(),get)

	get:UpdateBuffer()

	Updated := saveUpdated


	if ( KillRead )
		get:exitState := GE_ESCAPE		// provokes ReadModal() exit
   end

return



/**************************
*
*	READ services
*
*/



/***
*	BMSettle()
*
*	Returns new position in array of Get objects, based on
*
*		- current position
*		- exitState of Get object at current position
*
*	NOTE return value of 0 indicates termination of READ
*	NOTE exitState of old Get is transferred to new Get
*/
static func BMSettle(GetList, pos)

local exitState


	if ( pos == 0 )
		exitState := GE_DOWN
	else
		exitState := GetList[pos]:exitState
	end


	if ( exitState == GE_ESCAPE .or. exitState == GE_WRITE )
		return ( 0 )					// NOTE
	end


	if ( exitState <> GE_WHEN )
		// reset state info
		LastPos := pos
		BumpTop := .f.
		BumpBot := .f.

	else
		// re-use last exitState, do not disturb state info
		exitState := LastExit

	end


	/***
	*	move
	*/
	do case
	case ( exitState == GE_UP )
		pos --

	case ( exitState == GE_DOWN )
		pos ++

	case ( exitState == GE_TOP )
		pos := 1
		BumpTop := .T.
		exitState := GE_DOWN

	case ( exitState == GE_BOTTOM )
		pos := Len(GetList)
		BumpBot := .T.
		exitState := GE_UP

	case ( exitState == GE_ENTER )
		pos ++

	endcase


	/***
	*	bounce
	*/
	if ( pos == 0 ) 						// bumped top

		if !BumpBot
			BumpTop := .T.
			pos := LastPos
			exitState := GE_DOWN
		end

	elseif ( pos == Len(GetList) + 1 )		// bumped bottom

		if ( exitState <> GE_ENTER .and. !BumpTop )
			BumpBot := .T.
			pos := LastPos
			exitState := GE_UP
		else
			pos := 0
		end
	end


	// record exit state
	LastExit := exitState

	if ( pos <> 0 )
		GetList[pos]:exitState := exitState
	end

return (pos)



/***
*	BMPostActiveGet()
*	Post active GET for ReadVar(), BMGetActive().
*/
static proc BMPostActiveGet(get)

	BMGetActive( get )
	ReadVar( UPPER(get:Name) )


return



/***
*	BMClearGetSysVars()
*	Save and clear READ state variables. Return array of saved values.
*
*	NOTE: 'Updated' status is cleared but not saved (S87 compat.).
*/
static func BMClearGetSysVars()

local saved[ GSV_COUNT ]


	saved[ GSV_KILLREAD ] := KillRead
	KillRead := .f.

	saved[ GSV_BUMPTOP ] := BumpTop
	BumpTop := .f.

	saved[ GSV_BUMPBOT ] := BumpBot
	BumpBot := .f.

	saved[ GSV_LASTEXIT ] := LastExit
	LastExit := 0

	saved[ GSV_LASTPOS ] := LastPos
	LastPos := 0

	saved[ GSV_ACTIVEGET ] := BMGetActive( NIL )

	saved[ GSV_READVAR ] := ReadVar( "" )

	saved[ GSV_READPROCNAME ] := ReadProcName
	ReadProcName := ""

	saved[ GSV_READPROCLINE ] := ReadProcLine
	ReadProcLine := 0

	Updated := .f.

return (saved)



/***
*   BMRestoreGetSysVars()
*	Restore READ state variables from array of saved values.
*
*	NOTE: 'Updated' status is not restored (S87 compat.).
*/
static proc BMRestoreGetSysVars(saved)

	KillRead := saved[ GSV_KILLREAD ]

	BumpTop := saved[ GSV_BUMPTOP ]

	BumpBot := saved[ GSV_BUMPBOT ]

	LastExit := saved[ GSV_LASTEXIT ]

	LastPos := saved[ GSV_LASTPOS ]

	BMGetActive( saved[ GSV_ACTIVEGET ] )

	ReadVar( saved[ GSV_READVAR ] )

	ReadProcName := saved[ GSV_READPROCNAME ]

	ReadProcLine := saved[ GSV_READPROCLINE ]

return

/***
*	BMGetActive()
*/
Static func BMGetActive(g)
local oldActive := ActiveGet
	if ( PCount() > 0 )
		ActiveGet := g
	end
return ( oldActive )

Function __SetBMValues( v1,v2,v3,v4 )
   altd()
   BMBorder := v1
   BMHeadSep := v2 // STRTRAN( Trim( v2 ),'^',' ' )
   BMColSep := v3  // STRTRAN( Trim( v3 ),'^',' ' )
   BMFootSep := v4 // STRTRAN( Trim( v4 ),'^',' ' )
Return NIL


Static Function DrawBMBox( nMode,get )
   Local i
   Local cHeadSep
   Local cColSep
   Local cFootSep
   Local oColumn
   DISPBEGIN()
   Do Case
   Case nMode = 1
      __SetBMValues( get:Buffer,BMHeadSep,BMColSep,BMFootSep )
   Case nMode = 2
      __SetBMValues( BMBorder,get:Buffer,BMColSep,BMFootSep )
   Case nMode = 3
      __SetBMValues( BMBorder,BMHeadSep,get:Buffer,BMFootSep )
   Case nMode = 4
      __SetBMValues( BMBorder,BMHeadSep,BMColSep,get:Buffer )
   EndCase

   cHeadSep := STRTRAN( Trim( BMHeadSep ),'^',' ' )
   cColSep := STRTRAN( Trim( BMColSep ),'^',' ' )
   cFootSep := STRTRAN( Trim( BMFootSep ),'^',' ' )

   @ 4,49,14,76 BOX Space(9) COLOR 'B/B'
   If nMode > 0
      // Draw All
      @ 4,56 Say 'Sample Defaults' COLOR 'GR+/B'
      @ 13,49 Say 'Working From Current Default' COLOR 'GR+/B'
      @ 14,58 Say 'Seperators' COLOR 'GR+/B'

      If oBMBrowse = NIL
         oBMBrowse := BMBROWSEDB( 6,50,11,75 )
         oBMBrowse:ColorSpec := 'B/W,B/W,B/W'
         oBMBrowse:SkipBlock := {|x|x}
         oColumn := BMCOLUMNNEW('Head1',{||'1st'} )
         oColumn:Footing := 'Foot1'
         oColumn:cColor := 'W+/W,W+/W'
         oBMBrowse:AddColumn( oColumn )
         oColumn := BMCOLUMNNEW('Head2',{||'2nd'} )
         oColumn:Footing := 'Foot2'
         oColumn:cColor := 'W+/W,W+/W'
         oBMBrowse:AddColumn( oColumn )
         oColumn := BMCOLUMNNEW('Head3',{||'3rd'} )
         oColumn:Footing := 'Foot3'
         oColumn:cColor := 'W+/W,W+/W'
         oBMBrowse:AddColumn( oColumn )

         oBMBrowse:SetColours()
      Endif

      oBMBrowse:Border := BMBorder

      For i = 1 To 3
         oColumn := oBMBrowse:GetColumn(i)
         oColumn:HeadSep := cHeadSep
         oColumn:FootSep := cFootSep
         oColumn:ColSep := cColSep
         oBMBrowse:SetColumn( i,oColumn )
      Next i

      oBMBrowse:RestBack()
      oBMBrowse:Refreshall()

      Do While !oBMBrowse:Stabilize();Enddo

      If nMode = 1
         // Draw Border
         Do Case
         Case Get:Pos = 1
            @ 5,49 Say Left( BMBorder,1 ) COLOR 'W+/BG'
         Case Get:Pos = 2
            @ 5,50,5,75 BOX Repl( Substr( BMBorder,2,1 ),9 ) COLOR 'W+/BG'
         Case Get:Pos = 3
            @ 5,76 Say Substr( BMBorder,3,1 ) COLOR 'W+/BG'
         Case Get:Pos = 4
            @ 6,76,11,76 BOX Repl( Substr( BMBorder,4,1 ),9 ) COLOR 'W+/BG'
            @ 7,76 Say Alltrim( Substr( BMBorder,10,1 )) COLOR 'B/W'
            @ 10,76 Say Alltrim( Substr( BMBorder,12,1 )) COLOR 'B/W'
         Case Get:Pos = 5
            @ 12,76 Say Substr( BMBorder,5,1 ) COLOR 'W+/BG'
         Case Get:Pos = 6
            @ 12,50,12,75 BOX Repl( Substr( BMBorder,6,1 ),9 ) COLOR 'W+/BG'
         Case Get:Pos = 7
            @ 12,49 Say Substr( BMBorder,7,1 ) COLOR 'W+/BG'
         Case Get:Pos = 8
            @ 6,49,11,49 BOX Repl( Substr( BMBorder,8,1 ),9 ) COLOR 'W+/BG'
            @ 7,49 Say Alltrim( Substr( BMBorder,9,1 )) COLOR 'B/W'
            @ 10,49 Say Alltrim( Substr( BMBorder,11,1 )) COLOR 'B/W'
         Case Get:Pos = 9 .and. Len(Alltrim(Left( BMBorder,8))) > 0
            If Len(Alltrim(Substr( BMBorder,9,1 ))) > 0
               @ 7,49 Say Substr( BMBorder,9,1 ) COLOR 'W+/BG'
            Else
               @ 7,49 Say Substr( BMBorder,8,1 ) COLOR 'W+/BG'
            Endif
         Case Get:Pos = 10 .and. Len(Alltrim(Left( BMBorder,8))) > 0
            If Len(Alltrim(Substr( BMBorder,10,1 ))) > 0
               @ 7,76 Say Substr( BMBorder,10,1 ) COLOR 'W+/BG'
            Else
               @ 7,76 Say Substr( BMBorder,4,1 ) COLOR 'W+/BG'
            Endif
         Case Get:Pos = 11 .and. Len(Alltrim(Left( BMBorder,8))) > 0
            If Len(Alltrim(Substr( BMBorder,11,1 ))) > 0
               @ 10,49 Say Substr( BMBorder,11,1 ) COLOR 'W+/BG'
            Else
               @ 10,49 Say Substr( BMBorder,8,1 ) COLOR 'W+/BG'
            Endif
         Case Get:Pos = 12 .and. Len(Alltrim(Left( BMBorder,8))) > 0
            If Len(Alltrim(Substr( BMBorder,12,1 ))) > 0
               @ 10,76 Say Substr( BMBorder,12,1 ) COLOR 'W+/BG'
            Else
               @ 10,76 Say Substr( BMBorder,4,1 ) COLOR 'W+/BG'
            Endif
         EndCase
      Endif
   Endif
   @ get:Row,get:Col-1+get:Pos Say ''
   DISPEND()
Return NIL



