MEMVAR GETLIST
#include 'inkey.ch'
#include 'fileio.ch'
#include 'box.ch'
#include 'bmkeymap.ch'
#include 'newmenu.ch'
#include 'systems.ch'

#translate stand( <c> ) => upper( padr( <c>, 10, '  ') )
#command default <x> to <v> => if <x> == nil; <x> := <v>; endif

#command SET KEY <n> To <proc> ;
         => SetKey( <n>, {|p, l, v, g| <proc>(p, l, v, g)} )

#IFDEF RUNTIME
   #translate SetHelpTopic(<x>) =>
#ENDIF

#define LENGTH 10
#define QTY 20
#define NONE "0123456789 "

#define K_SPACE   32
#define K_ALT_BS 270

Static cBuffer
Static pos
Static nCount
Static nHandle := -1
Static cLine
Static bb
Static cFile
Static aHelp
Static lModified := .F.
Static lSaved
Static cPath
Static cHPath
Static cBEnvironment := 'BMFILES'
Static aBrowses := {}

Static cTopic


#IFDEF RUNTIME
   EXTERNAL BMBROWSE
   EXTERNAL BMCOLUMN
#ENDIF


//#DEFINE DEMO

Function BrowseManager( cBrowse,t,l,b,r )
   Local nKey
   Local lDebug := SET(_SET_DEBUG)
   Local lCancel  := SETCANCEL()
   Local oldColor
   Local oObj

   cBrowse := Alltrim( Left(cBrowse+Space(8),8) )

   SetHelpTopic('NORMAL')

   // Get Stuff From Environment
   If cPath = NIL
      BrowsePath()
#IFNDEF RUNTIME
      BrowseHPath()
#ENDIF
   Endif

   lSaved := .F.
   lModified := .F.

#IFNDEF RUNTIME
   SETCANCEL(.F.)
   altd(0)
#ENDIF
   lSaved := .F.

   AADD( aBrowses,bb )

   If !(bb := BrowseLoad( cBrowse,t,l,b,r )) = NIL
      oldColor := SetColor('BG/B,W+/W,,,B/W')
      Do While .T.
#IFNDEF RUNTIME
         Do While (nKey := HlpInkey()) = 0
#ELSE
         Do While (nKey := Inkey()) = 0
#ENDIF
            bb:Stabilize()
#IFNDEF RUNTIME
            If IS_ALT() .and. ( bb:Stable .or. bb:ColCount = 0 )
               StatusBar()
               Exit
            Endif
#ENDIF
         Enddo

         Do Case
         Case nKey = bb:SetKey( BMK_UP )
            bb:Up()
         Case nKey = bb:SetKey( BMK_DOWN )
            bb:Down()
         Case nKey = bb:SetKey( BMK_LEFT )
            bb:Left()
         Case nKey = bb:SetKey( BMK_RIGHT )
            bb:Right()
         Case nKey = bb:SetKey( BMK_HOME )
            bb:Home()
         Case nKey = bb:SetKey( BMK_END )
            bb:End()
         Case nKey = bb:SetKey( BMK_PGUP )
            bb:PageUp()
         Case nKey = bb:SetKey( BMK_PGDN )
            bb:PageDown()
         Case nKey = bb:SetKey( BMK_PANLEFT )
            bb:PanLeft()
         Case nKey = bb:SetKey( BMK_PANRIGHT )
            bb:PanRight()
         Case nKey = bb:SetKey( BMK_GOTOP )
            bb:GoTop()
         Case nKey = bb:SetKey( BMK_GOBOTTOM )
            bb:GoBottom()
         Case nKey = bb:SetKey( BMK_PANHOME )
            bb:PanHome()
         Case nKey = bb:SetKey( BMK_PANEND )
            bb:PanEnd()
         Case nKey = bb:SetKey( BMK_ESCAPE )
#IFNDEF RUNTIME
            If lModified
               If CheckSave()
                  Exit
               Endif
            Else
               Exit
            Endif
#ELSE
            Exit
#ENDIF
         Case nKey = bb:SetKey( BMK_SELECT )
#IFNDEF RUNTIME
            If lModified
               If CheckSave()
                  Exit
               Endif
            Else
               Exit
            Endif
#ELSE
            Exit
#ENDIF

#IFNDEF RUNTIME
         Case nKey = K_F4
            BrowseMove()
         Case nKey = K_F5
            BrowseSize()
         Case nKey = K_F10
            bb:Alternate()
         Case nKey = K_F6 .and. bb:ColCount > 0
            ColMove()
         Case nKey = K_F7 .and. bb:ColCount > 0
            ColSize()
         Case nKey = K_F2
            BrowseEdit()
         Case nKey = K_F3 .and. bb:ColCount > 0
            EditColumn()
         Case (nKey = K_INS .or. nKey = ASC('0')) .and. IS_SHIFT() .and. bb:ColCount > 0
            bb:Copy()
         Case (nKey = K_DEL .or. nKey = ASC('.')) .and. IS_SHIFT() .and. bb:ColCount > 0
            bb:Cut()
         Case nKey = K_F8 .and. bb:ColCount > 0
            // Unhilighted Color
            oObj := bb:GetColumn( bb:ColPos )
            oObj:cColor := PickColor(AsArray( oObj:cColor )[1])+','+AsArray( oObj:cColor )[2]
            lModified := .T.
            bb:Configure()
            bb:SetColours()
         Case nKey = K_F9 .and. bb:ColCount > 0
            // Hilighted Color
            oObj := bb:GetColumn( bb:ColPos )
            oObj:cColor := AsArray( oObj:cColor )[1]+','+PickColor(AsArray( oObj:cColor )[2])
            lModified := .T.
            bb:Configure()
            bb:SetColours()
#ENDIF
         Otherwise
            If VALTYPE( SetKey( nKey ) ) = 'B'
               EVAL( SetKey( nKey ),'BROWSEMAN',0,UPPER(bb:Name) )
            Endif
         EndCase
      Enddo
   Endif
   Altd(lDebug)
   SETCANCEL(lCancel)
   lModified := .F.
   aHelp := NIL
   SetColor(oldColor)

   bb := ATAIL( aBrowses )
   ASIZE( aBrowses,Len(aBrowses)-1)
Return NIL


#IFNDEF RUNTIME

Static Function StatusBar()
   LOCAL cScr := SaveScreen( 0,0,1,79 )
   Local bBlock

   // Status Stuff

   bBlock := MenuHandler()
   RestScreen( 0,0,1,79,cScr )
   If VALTYPE( bBlock ) = 'B'
      EVAL( bBlock )
   Endif
Return NIL

MENU BMMenu
   PROMPT "~Disk" AT 1 SUBMENU DiskMenu
   PROMPT "~Browse" AT 7 SUBMENU BrowseMenu
   PROMPT "~Column" AT 15 SUBMENU ColumnMenu
   PROMPT "~Edit" AT 23 SUBMENU EditMenu
   PROMPT "~Generate"  AT 29 SUBMENU GenerateMenu
   PROMPT "~Options" AT 40 SUBMENU OptionMenu
//   PROMPT "~Help" AT 75 SUBMENU HelpMenu
END MENU

SUBMENU DiskMenu
   SUBMENU COORDS 1,0,5,16
   SUBPROMPT " ~Reload Browse" ACTION {||bb:RestBack(),bb:=BrowseLoad(bb:Name)}
   BLANK LINE
   SUBPROMPT " ~Save Browse" ACTION BrowseSave()
END SUBMENU

SUBMENU BrowseMenu
   SUBMENU COORDS 1,6,10,47
   SUBPROMPT " ~Edit Browse Definition           <F2>" ACTION BrowseEdit()
   BLANK LINE
   SUBPROMPT " ~Move Browse                      <F4>" ACTION BrowseMove()
   SUBPROMPT " ~Size Browse                      <F5>" ACTION BrowseSize()
   BLANK LINE
   SUBPROMPT " Switch Between Browse ~Positions  <F10>" ACTION bb:Alternate()
   BLANK LINE
   SUBPROMPT " Edit ~Key Map" ACTION BrowseKeyMap()
END SUBMENU

SUBMENU ColumnMenu
   SUBMENU COORDS 1,14,14,47
   SUBPROMPT " ~Add New Column Defintion" ACTION {|x|x:=BMColumnNew('<New>','{||"<New>"}'),EditColumn(x)}
   BLANK LINE
   SUBPROMPT " ~Edit Column Definition    <F3>" ACTION EditColumn() WHEN bb:ColCount > 0
   BLANK LINE
   SUBPROMPT " ~Move Column               <F6>" ACTION ColMove() WHEN bb:ColCount > 0
   SUBPROMPT " ~Size Column               <F7>" ACTION ColSize() WHEN bb:ColCount > 0
   BLANK LINE
   SUBPROMPT " ~Unhilited Colour          <F8>" WHEN bb:ColCount > 0 ;
            ACTION {|oObj|oObj := bb:GetColumn( bb:ColPos ),;
                          oObj:cColor := PickColor(AsArray( oObj:cColor )[1])+','+AsArray( oObj:cColor )[2],;
                          lModified := .T.,;
                          bb:SetColours(),;
                          bb:Configure()}

   SUBPROMPT " ~Hilited Colour            <F9>" WHEN bb:ColCount > 0 ;
            ACTION {|oObj|oObj := bb:GetColumn( bb:ColPos ),;
                          oObj:cColor := AsArray( oObj:cColor )[1]+','+PickColor(AsArray( oObj:cColor )[2]),;
                          lModified := .T.,;
                          bb:SetColours(),;
                          bb:Configure()}
   BLANK LINE
   SUBPROMPT " ~Freeze To This Column" ACTION {||bb:Freeze := bb:ColPos,lModified := .T.} WHEN bb:ColCount > 0
   SUBPROMPT " Cancel F~reeze Position" ACTION {||bb:Freeze := 0,lModified := .T.}
END SUBMENU

SUBMENU EditMenu
   SUBMENU COORDS 1,22,7,52
   SUBPROMPT " ~Cut Column     <Shft>+<Del>" ACTION bb:Cut() WHEN bb:ColCount > 0
   SUBPROMPT " C~opy Column    <Shft>+<Ins>" ACTION bb:Copy() WHEN bb:ColCount > 0
   BLANK LINE
   SUBPROMPT " ~Paste Column Before" ACTION bb:Paste(.T.) WHEN !ClipBoard() == NIL .and. bb:ColCount > 0
   SUBPROMPT " Paste Column ~After" ACTION bb:Paste() WHEN !ClipBoard() == NIL
END SUBMENU

SUBMENU GenerateMenu
   SUBMENU COORDS 1,28,5,53
   SUBPROMPT " Generate ~TBROWSE Code" ACTION GenTBrowse()
   BLANK LINE
   SUBPROMPT " Generate ~BMBROWSE Code" ACTION GenBrowseMan()
END SUBMENU

SUBMENU OptionMenu
   SUBMENU COORDS 1,39,3,56
   SUBPROMPT " ~Swap SETBLINK()" ACTION {||SetBlink( !SetBlink() ),bb:Blink:=!bb:Blink }
END SUBMENU

#ENDIF

Static Function BrowseLoad( cBrowse,t,l,b,r )
   Local oBrowse,cScr := SaveScreen(MAXROW()-2,0,MAXROW(),79)
   Local nKey
   oBrowse := bbLoad( cBrowse )
#IFNDEF RUNTIME
   If oBrowse = NIL
      @ MAXROW()-2,0 Say '  Browse Not Found...Do You Wish To Create Your Own Browse Or Start With A Or   ' COLOR 'W+/B'
      @ MAXROW()-1,0 Say '                             A DBEDIT() Style Browse ?                          ' COLOR 'W+/B'
      @ MAXROW(),0 Say '   Press <1> For Your Own Browse   -   Press <2> For A DBEDIT() Style Browse    ' COLOR 'BG/B'
      Do While .T.
         nKey := CHR(HlpInkey(0))
         Do Case
         Case nKey = '1'
            // Empty Browse
            If t = NIL
               oBrowse := BMBrowseDB(0,0,MAXROW(),MAXCOL())
            Else
               oBrowse := BMBrowseDB(t,l,b,r)
            Endif
            oBrowse:Name := cBrowse
            Exit
         Case nKey = '2'
            oBrowse := DbeditTOBM(t,l,b,r)
            oBrowse:Name := cBrowse
            Exit
         EndCase
      Enddo
      lModified := .T.
      lSaved := .F.
      RestScreen( MAXROW()-2,0,MAXROW(),79,cScr)
   Else
      lModified := .F.
      lSaved := .T.
   Endif
   oBrowse:Configure()
   oBrowse:SaveBack()
#ELSE
   If !oBrowse = NIL
      oBrowse:Configure()
      oBrowse:SaveBack()
   Endif
#ENDIF
Return oBrowse


#IFNDEF RUNTIME

Static Function BrowseSave()
   Local cScr := SaveScreen(0,0,0,79)
   Local i
   @ 0,0 Say 'Saving Browse '+Alltrim(bb:Name ) +IF(Len(cPath)>0,' into '+cPath,'')+' ...'+Space(70) COLOR 'W+/B'
   bbSave()
   lModified := .F.
   @ 0,0 Say 'Browse '+Alltrim(bb:Name)+' Has Been Saved'+Space(70) COLOR 'W+/B'
   For i = 1 to 5000 ; i := i ; Next i
   RestScreen( 0,0,0,79,cScr )
   lSaved := .T.
Return NIL

Static Function BrowseSize()
   Local nKey
   Local nRec := Recno()
   Local cColor := AsArray( bb:ColorSpec )[1]
   Local cBorder := bb:Border
   @ 0,0 Say 'Size Browse...Press <Space> To View Field Positions' COLOR 'W+/B'
   SetHelpTopic('BROWSESIZE')
   Do While ( nKey := HlpInkey(0) ) <> K_ENTER
      DISPBEGIN()
      Clear TypeAhead
      Do Case
      Case nKey = K_LEFT
         bb:SizeLeft()
      Case nKey = K_RIGHT
         bb:SizeRight()
      Case nKey = K_UP
         bb:SizeUp()
      Case nKey = K_DOWN
         bb:SizeDown()
      EndCase
      If nKey = K_SPACE
         Go nRec
         bb:Refreshall()
         Do While !bb:Stabilize() ; Enddo
      Else
         @ IF( EMPTY(Left( cBorder,3 )),bb:nTop,bb:nTop-1),;
           IF( EMPTY(Left( cBorder,1 )+Substr( cBorder,7,2 )),bb:nLeft,bb:nLeft-1),;
           IF( EMPTY(SubStr( cBorder,5,3 )),bb:nBottom,bb:nBottom+1),;
           IF( EMPTY(SubStr( cBorder,3,3)),bb:nRight,bb:nRight+1) ;
           Box Left(cBorder,8)+' ' COLOR cColor
      Endif
      @ 0,0 Say 'Size Browse...Press <Space> To View Field Positions' COLOR 'W+/B'
      DISPEND()
   Enddo
   Go nRec
   bb:RestBack()
   bb:ReFreshAll()
   lModified := .T.
   SetHelpTopic('NORMAL')
Return NIL

Static Function ColSize()
   Local nKey
   Local oColumn := bb:GetColumn( bb:ColPos )
   Local nRec := Recno()
   SetHelpTopic('COLSIZE')
   Do While ( nKey := HlpInkey() ) <> K_ENTER
      Clear TypeAhead
      bb:Stabilize()
      @ 0,0 Say 'Size Column...' Color 'W+/B'
      Do Case
      Case nKey = K_LEFT
         oColumn:SizeLeft()
         bb:SetColumn( bb:ColPos, oColumn )
         Go nRec
         bb:Refreshall()
      Case nKey = K_RIGHT
         oColumn:SizeRight()
         bb:SetColumn( bb:ColPos, oColumn )
         Go nRec
         bb:Refreshall()
      Case nKey = K_HOME
         oColumn:Width := NIL
         bb:SetColumn( bb:ColPos, oColumn )
         Go nRec
         bb:Refreshall()
      EndCase
   Enddo
   Go nRec
   bb:RefreshAll()
   bb:RestBack()
   lModified := .T.
   SetHelpTopic('NORMAL')
Return NIL

Static Function BrowseMove()
   Local nKey
   Local cScr
   Local cBorder := bb:Border
   SetHelpTopic('BROWSEMOVE')
   cScr := SaveScreen(IF( EMPTY(Left( cBorder,3 )),bb:nTop,bb:nTop-1),;
                      IF( EMPTY(Left( cBorder,1 )+Substr( cBorder,7,2 )),bb:nLeft,bb:nLeft-1),;
                      IF( EMPTY(SubStr( cBorder,5,3 )),bb:nBottom,bb:nBottom+1),;
                      IF( EMPTY(SubStr( cBorder,3,3)),bb:nRight,bb:nRight+1))
   @ 0,0 Say 'Move Browse...' COLOR 'W+/B'
   Do While ( nKey := HlpInkey(0) ) <> K_ENTER
      Clear TypeAhead
      DISPBEGIN()
      Do Case
      Case nKey = K_LEFT
         bb:MoveLeft()
      Case nKey = K_RIGHT
         bb:MoveRight()
      Case nKey = K_UP
         bb:MoveUp()
      Case nKey = K_DOWN
         bb:MoveDown()
      EndCase
      RestScreen(IF( EMPTY(Left( cBorder,3 )),bb:nTop,bb:nTop-1),;
                 IF( EMPTY(Left( cBorder,1 )+Substr( cBorder,7,2 )),bb:nLeft,bb:nLeft-1),;
                 IF( EMPTY(SubStr( cBorder,5,3 )),bb:nBottom,bb:nBottom+1),;
                 IF( EMPTY(SubStr( cBorder,3,3)),bb:nRight,bb:nRight+1),cScr)
      @ 0,0 Say 'Move Browse...' COLOR 'W+/B'
      DISPEND()
   Enddo
   bb:RestBack()
   bb:ReFreshAll()
   lModified := .T.
   SetHelpTopic('NORMAL')
Return NIL

Static Function ColMove()
   Local nKey
   Local oColumn := bb:GetColumn( bb:ColPos )
   Local nRec := Recno()
   SetHelpTopic('COLMOVE')
   Do While ( nKey := HlpInkey() ) <> K_ENTER
      Clear TypeAhead
      bb:Stabilize()
      @ 0,0 Say 'Move Column...' Color 'W+/B'
      Do Case
      Case nKey = K_LEFT .and. bb:ColPos > 1
         bb:MoveColLeft()
         bb:ColPos --
         Go nRec
      Case nKey = K_RIGHT .and. bb:ColPos < bb:ColCount
         bb:MoveColRight()
         bb:ColPos ++
         Go nRec
      EndCase
   Enddo
   Go nRec
   bb:RefreshAll()
   bb:RestBack()
   lModified := .T.
   SetHelpTopic('NORMAL')
Return NIL

Static Function BrowseKeyMap()
   Local cScr := SaveScreen(0,0,24,79)
   Local i,nRow,nCurrent,lCtrl,lAlt
   Local aOldKeys := {},nKey
   SetHelpTopic('KEYMAP')
   For i = 1 To 16
      AADD( aOldKeys,bb:SetKey( i ) )
   Next i

   KeyMap()
   For i = 1 to 6
      @ 4+i,2 Say KeyType( bb:SetKey( i ) ) Color 'BG+/B'
   Next i
   For i = 7 to 10
      @ 5+i,2 Say KeyType( bb:SetKey( i ) ) Color 'BG+/B'
   Next i
   For i = 11 to 14
      @ 6+i,2 Say KeyType( bb:SetKey( i ) ) Color 'BG+/B'
   Next i
   For i = 15 to 16
      @ 7+i,2 Say KeyType( bb:SetKey( i ) ) Color 'BG+/B'
   Next i
   nRow := 5
   nCurrent := 1
   Do While .T.

      lAlt := .F.
      lCtrl := .F.

      If nRow = 11 .or. nRow = 16 .or. nRow = 21
         nRow ++
      Endif
      If nRow = 24
         // Save - Reedit - Cancel
         @ 24,7 Say ' <S> - Save New Keys   <E> - Re-Edit Keys   <C> - Cancel New Keys ' Color 'W+/B'
         SetHelpTopic('KEYSAVE')
         Do While .T.
            nKey := UPPER( CHR( HlpInkey(0) ) )
            Do Case
            Case nKey = 'S'
               lModified := .T.
               Exit
            Case nKey = 'E'
               nRow := 5
               nCurrent := 1
               @ 24,7 Say Repl('',66 ) Color 'W+/B'
               Exit
            Case nKey = 'C'
               For i = 1 To 16
                  bb:SetKey( i,aOldKeys[i] )
               Next i
               Exit
            EndCase
         Enddo
         SetHelpTopic('KEYMAP')
         If nRow = 5
            Loop
         Else
            Exit
         Endif
      Else

         @ nRow,53 Clear To nRow,78
         Do While IS_CTRL() .or. IS_ALT()
            If IS_ALT()
               @ nRow,53 Say 'Release <Alt> Key... '
            Elseif IS_CTRL()
               @ nRow,53 Say 'Release <Ctrl> Key...'
            Endif
            Clear TypeAhead
         Enddo
         @ nRow,53 Say 'Waiting For Key ...' COLOR 'W+/B'
      Endif

      Do While .T.
         If Nextkey() <> 0
            If NEXTKEY() = 28
               HlpInkey()
               Loop
            Else
               bb:SetKey( nCurrent, HlpInkey(0) )
            Endif
            Exit
         Endif
         If !lAlt
            If IS_ALT()
               lAlt := .T.
            Endif
         Else
            If !IS_ALT()
               Exit
            Endif
         Endif
         If !lCtrl
            If IS_CTRL()
               lCtrl := .T.
            Endif
         Else
            If !IS_CTRL()
               bb:SetKey( nCurrent, 0 )
               Exit
            Endif
         Endif
      Enddo
      @ nRow,53 Say KeyType( bb:SetKey( nCurrent ) ,.T. ) Color 'G+/B'
      nrow ++
      nCurrent ++
   Enddo
   SetHelpTopic('NORMAL')
   RestScreen(0,0,24,79,cScr)
Return NIL

#ENDIF

FUNCTION AsArray( cList, cDelimiter )
   LOCAL nPos
   LOCAL aList := {}                            // Define an empty array

   IF cDelimiter = NIL
      cDelimiter := ","
   ENDIF
   //
   DO WHILE (nPos := AT(cDelimiter, cList)) != 0
      AADD(aList, SUBSTR(cList, 1, nPos - 1))   // Add a new element
      cList := SUBSTR(cList, nPos + 1)
   ENDDO
   AADD(aList, cList)                           // Add final element
   //
RETURN aList                                 // Return the array

#IFNDEF RUNTIME

Static Function KeyType( nKey,lMode )
   Static aSpecials
   Local cString := ''
   Local cSearch := 'QWERTYUIOP||||ASDFGHJKL|||||ZXCVBNM'+Repl("|",69)+'1234567890'
   Local cExtras := "'"+'!"$%^&*()_+-~#=][{};:@?/.>,<\|`'
   Local nSpecial
   If aSpecials = NIL
      aSpecials := {{K_ESC,'<Esc>'},{K_ENTER,'<Return>'},{K_UP,'<Up>'},;
                    {K_DOWN,'<Down>'},{K_LEFT,'<Left>'},{K_RIGHT,'<Right>'},;
                    {K_HOME,'<Home>'},{K_END,'<End>'},{K_PGUP,'<PgUp>'},;
                    {K_PGDN,'<PgDn>'},{K_INS,'<Insert>'},{K_DEL,'<Del>'},;
                    {K_TAB,'<Tab>'},{K_SH_TAB,'<Shift>+<Tab>'},{K_BS,'<BackSpace>'},;
                    {K_CTRL_BS,'<Ctrl>+<BackSpace>'},{K_CTRL_LEFT,'<Ctrl>+<Left>'},;
                    {K_CTRL_RIGHT,'<Ctrl>+<Right>'},{K_CTRL_HOME,'<Ctrl>+<Home>'},;
                    {K_CTRL_END,'<Ctrl>+<End>'},{K_CTRL_PGUP,'<Ctrl>+<PgUp>'},;
                    {K_CTRL_PGDN,'<Ctrl>+<PgDn>'},{K_SPACE,'<Space Bar>'},;
                    {K_ALT_BS,'<Alt>+<BackSpace>'}}
   Endif
   Do Case
   Case nKey = 0
      cString := 'Not Used'
   Case ISALPHA( CHR( nKey ) )
      cString := '<'+UPPER( CHR( nKey ) )+'>'
   Case ISDIGIT( CHR( nKey ) )
      cString := '<'+CHR( nKey )+'>'
   Case nKey = K_F1
      cString := '<F1> (Not Recommended)'
   Case nKey < 0
      Do Case
      Case nKey < -45
         cString := '<Alt>+<F'+Alltrim(STR(-nKey-35))+'>'
      Case nKey < -43
         cString := '<Ctrl>+<F'+Alltrim(STR(-nKey-33))+'>'
      Case nKey < -41
         cString := '<Shift>+<F'+Alltrim(STR(-nKey-31))+'>'
      Case nKey < -39
         cString := '<F'+Alltrim(STR(-nKey-29))+'>'
      Case nKey < -29
         cString := '<Alt>+<F'+Alltrim(STR(-nKey-29))+'>'
      Case nKey < -19
         cString := '<Ctrl>+<F'+Alltrim(STR(-nKey-19))+'>'
      Case nKey < -9
         cString := '<Shift>+<F'+Alltrim(STR(-nKey-9))+'>'
      Otherwise
         cString := '<F'+Alltrim(STR(-nKey+1))+'>'
      EndCase
   Case nKey > 271
      cString := '<Alt>+<'+Substr( cSearch,nKey-271,1 )+'>'
   Case ( nSpecial := AT( CHR(nKey),cExtras ) ) > 0
      cString := '<'+Substr( cExtras,nSpecial,1)+'>'
   Otherwise
      If (nSpecial := ASCAN( aSpecials,{|x|x[1]=nKey} ) ) > 0
         cString := aSpecials[nSpecial][2]
      Endif
   EndCase
   If nKey < 27 .and. nKey > 0
      cString += ' <Ctrl>+<'+CHR(64+nKey)+'>'
   Endif
   If Len( cString ) = 0
      cString := 'Unknown Keystroke'
   Endif
Return If( lMode=NIL,;
           Right( Space(25)+LTrim(cString),25 ),;
           Left( LTrim(cString)+Space(23),25 ) )

Static Function EditColumn( oColumn )
   Local cScr := SaveScreen(0,0,24,79)
   Local lMode := .F.
   Local cColor1,cColor2
   Local cExpr
   Local cHeader
   Local cFooting
   Local cHeadSep
   Local cFootSep
   Local cColSep
   ColEdit()
   SetHelpTopic('COLEDIT')
   If oColumn = NIL
      oColumn := bb:GetColumn( bb:colPos )
      lMode := .T.
   Else
      oColumn:cColor := AsArray( bb:ColorSpec)[2]+','+AsArray( bb:ColorSpec)[3]
   Endif

   cExpr := Left(Substr( oColumn:cBlock,4,Len(oColumn:cBlock)-4)+Space(120),120 )
   cHeader := Left( oColumn:Heading+Space(120),120 )
   cFooting := IF( oColumn:Footing=NIL,Space(120),;
                   Left( oColumn:Footing+Space(120),120 ) )
   cHeadSep := ReAdjust( oColumn:HeadSep,bb:HeadSep )
   cFootSep := ReAdjust( oColumn:FootSep,bb:FootSep )
   cColSep := ReAdjust( oColumn:ColSep,bb:ColSep )

   cColor1 := Left(AsArray( oColumn:cColor )[1]+Space(10),10)
   cColor2 := Left(AsArray( oColumn:cColor )[2]+Space(10),10)

   SET KEY -4 To GetField
   SET KEY -5 To GetBoxes
   SET KEY -6 To GetColours

   @ 1,14 Get cExpr Pict '@'+IF(lMode,'','K')+'S64' Valid ExprCheck( cExpr )
   @ 4,10 Get cHeader Pict '@'+IF(lMode,'','K')+'S68'
   @ 5,10 Get cFooting Pict '@S68'
   @ 9,22 Get cHeadSep
   @ 10,22 Get cColSep
   @ 11,22 Get cFootSep
   @ 15,28 Get cColor1 Pict '@!'
   @ 16,28 Get cColor2 Pict '@!'
   Readit( GetList ) ; GetList := {}

   If !LastKey() = 27
      oColumn:Heading := STRTRAN(Trim( cHeader ),'^',' ')
      oColumn:Footing := STRTRAN(Trim( cFooting ),'^',' ')
      oColumn:HeadSep := STRTRAN(Trim( cHeadSep ),'^',' ')
      oColumn:FootSep := STRTRAN(Trim( cFootSep ),'^',' ')
      oColumn:ColSep := STRTRAN(Trim( cColSep ),'^',' ')

      oColumn:cColor := Alltrim(cColor1)+','+Alltrim(cColor2)

      If lMode
         bb:SetColumn( bb:colPos,oColumn )
      Else
         If bb:ColCount = 0
            bb:AddColumn( oColumn )
         Else
            bb:InsColumn( bb:ColPos+1,oColumn )
            bb:ColPos ++
         Endif
      Endif
      oColumn:SetBlock('{||'+Alltrim( cExpr )+'}')
      bb:Configure()
      bb:SetColours()
      lModified := .T.
   Endif
   RestScreen(0,0,24,79,cScr)
   SET KEY -4 To
   SET KEY -5 To
   SET KEY -6 To
   SetHelpTopic('NORMAL')
Return !Lastkey()=27

Static Function BrowseEdit()
   Local cScr := SaveScreen(0,0,24,79)
   Local cBrowseName := Left(bb:Name+Space(8),8)
   Local cBorder := bb:Border
   Local cColSep
   Local cHeadSep
   Local cFootSep
   Local cColFore
   Local cColBack
   Local cHiFore
   Local cHiBack
   Local cLoFore
   Local cLoBack
   Local cColor1,cColor2,cColor3
   Local aColors
   Local nKey
   BrowEdit()
   SetHelpTopic('BROWSEEDIT')
   cHeadSep := ReAdjust( bb:HeadSep,'' )
   cFootSep := ReAdjust( bb:FootSep,'' )
   cColSep := ReAdjust( bb:ColSep,'' )

   __SetBMValues( cBorder,cHeadSep,cColSep,cFootSep )

   cColor1 := Left((aColors := AsArray(bb:colorSpec))[1]+Space(10),10)
   cColor2 := Left(aColors[2]+Space(10),10)
   cColor3 := Left(aColors[3]+Space(10),10)

   SET KEY -5 To GetBoxes
   SET KEY -6 To GetColours

   @ 1,15 Get cBrowseName Valid NameCheck( cBrowseName )
   @ 5,22 Get cHeadSep
   @ 6,22 Get cColSep
   @ 7,22 Get cFootSep
   @ 8,22 Get cBorder
   @ 12,16 Get cColor1 Pict '@!'
   @ 16,28 Get cColor2 Pict '@!'
   @ 17,28 Get cColor3 Pict '@!'
   Readit( GetList ) ; GetList := {}
   RestScreen(0,0,24,79,cScr)
   If !Lastkey() = 27
      aColors[1] := Alltrim(cColor1)
      aColors[2] := Alltrim(cColor2)
      aColors[3] := Alltrim(cColor3)

      If bb:ColCount() > 0
         @ MAXROW()-10,0,MAXROW(),79 Box B_DOUBLE COLOR 'W+/B'
         @ MAXROW()-9,1 Say ' If You Have Made Any Changes To The Default Seperator Or Colour Settings And ' COLOR 'W+/B'
         @ MAXROW()-8,1 Say ' You Wish These To Be Reflected In Already Existing Columns You Will Need To  ' COLOR 'W+/B'
         @ MAXROW()-7,1 Say ' To Either Update Each Column Manually Or You May:                            ' COLOR 'W+/B'
         @ MAXROW()-6,1 Say Space(78) COLOR 'W+/B'
         @ MAXROW()-5,1 Say ' Press <1> To Ignore Any Duplications                                         ' COLOR 'BG/B'
         @ MAXROW()-4,1 Say ' Press <2> To Update All Seperator And Colour Duplications                    ' COLOR 'BG/B'
         @ MAXROW()-3,1 Say ' Press <3> To Update All Seperator Duplications                               ' COLOR 'BG/B'
         @ MAXROW()-2,1 Say ' Press <4> To Update All Colour Duplications                                  ' COLOR 'BG/B'
         @ MAXROW()-1,1 Say ' Press <5> To Select Which To Update Duplications On A Column By Column Basis ' COLOR 'BG/B'
         SetHelpTopic( 'BROWSECHANGE' )
         Do While .T.
            nKey := CHR(HlpInkey(0))
            Do Case
            Case nKey = '2'
               UpdateCols(aColors[2],aColors[3])
               UpdateSeps(STRTRAN(Trim( cHeadSep ),'^',' '),;
                          STRTRAN(Trim( cColSep ),'^',' '),;
                          STRTRAN(Trim( cFootSep ),'^',' '))
            Case nKey = '3'
               UpdateSeps(STRTRAN(Trim( cHeadSep ),'^',' '),;
                          STRTRAN(Trim( cColSep ),'^',' '),;
                          STRTRAN(Trim( cFootSep ),'^',' '))
            Case nKey = '4'
               UpdateCols(aColors[2],aColors[3])
            Case nKey = '5'
               RestScreen(0,0,24,79,cScr)
               UpdateInd(aColors[2],aColors[3],;
                         STRTRAN(Trim( cHeadSep ),'^',' '),;
                         STRTRAN(Trim( cColSep ),'^',' '),;
                         STRTRAN(Trim( cFootSep ),'^',' '))
            EndCase
            If nKey $ '12345'
               Exit
            Endif
         Enddo
      Endif

      bb:Name := Alltrim( cBrowseName )
      UpDateSize( cBorder )
      bb:Border := cBorder
      bb:HeadSep := STRTRAN(Trim( cHeadSep ),'^',' ')
      bb:FootSep := STRTRAN(Trim( cFootSep ),'^',' ')
      bb:ColSep := STRTRAN(Trim( cColSep ),'^',' ')
      bb:ColorSpec := aColors[1]+','+aColors[2]+','+aColors[3]
      AEVAL( aColors,{|x|bb:ColorSpec += ','+x },2 )
      RestScreen(0,0,24,79,cScr)
      bb:RestBack()
      bb:Configure()
      bb:SetColours()
      lModified := .T.
   Endif
   SET KEY -5 To
   SET KEY -6 To
   SetHelpTopic('NORMAL')
Return !Lastkey()=27

Static Function ReAdjust( cSep,cBBSep )
   If cSep=NIL
      cSep := ReAdjust(cBBSep)
   Else
      If Right( cSep,1) = ' '
         cSep := Left( cSep,Len(cSep)-1)+'^'
      Endif
      cSep := Left( cSep+Space(10),10 )
   Endif
Return cSep

Static Function UpdateSize( cBorder )
   Local xBorder := bb:Border
   If EMPTY(Left(cBorder,1)+Substr(cBorder,7,2)) .and. !EMPTY(Left(xBorder,1)+Substr(xBorder,7,2))
      bb:nLeft--
   Elseif EMPTY(Left(xBorder,1)+Substr(xBorder,7,2)) .and. !EMPTY(Left(cBorder,1)+Substr(cBorder,7,2))
      bb:nLeft++
   Endif
   If EMPTY(Substr(cBorder,3,3)) .and. !EMPTY(Substr(xBorder,3,3))
      bb:nRight++
   Elseif EMPTY(Substr(xBorder,3,3)) .and. !EMPTY(SubStr(cBorder,3,3))
      bb:nRight--
   Endif
   If EMPTY(Left(cBorder,3)) .and. !EMPTY(Left(xBorder,3))
      bb:nTop--
   Elseif EMPTY(Left(xBorder,3)) .and. !EMPTY(Left(cBorder,3))
      bb:nTop++
   Endif
   If EMPTY(Substr(cBorder,5,3)) .and. !EMPTY(Substr(xBorder,5,3))
      bb:nBottom++
   Elseif EMPTY(Substr(xBorder,5,3)) .and. !EMPTY(Substr(cBorder,5,3))
      bb:nBottom--
   Endif
Return NIL

Static Function GetColours(cProc,nLine,cVar,oGet)
   Local cColor
   If cVar == 'CCOLOR1' .or. cVar == 'CCOLOR2' .or. cVar == 'CCOLOR3'
      cColor := PickColor( oGet:Buffer )
      oGet:VarPut( Left(cColor+Space(10),10) )
   Endif
Return NIL

Static Function GetBoxes(xProc,xLine,cVar,oGet)
   Static nBox := 1
   Static nLine := 1
   Static nCol := 1
   Local cScr
   Local cChar,nKey
   Local oldTopic := cTopic
   Save Screen To cScr
   If cVar = 'CHEADSEP' .or. cVar = 'CCOLSEP' .or. cVar = 'CFOOTSEP' .or.;
      cVar = 'CBORDER'
      Boxes()
      SetHelpTopic('DRAWBOX')
      Do While .T.
         cChar := SaveScreen(18+nLine,10+((nBox-1)*17)+nCol,;
                             18+nLine,10+((nBox-1)*17)+nCol)
         RestScreen(18+nLine,10+((nBox-1)*17)+nCol,;
                    18+nLine,10+((nBox-1)*17)+nCol,Left(cChar,1)+'A')
         nKey := HlpInkey(0)
         RestScreen(18+nLine,10+((nBox-1)*17)+nCol,;
                    18+nLine,10+((nBox-1)*17)+nCol,cChar)
         Do Case
         Case nKey = K_ESC
            Exit
         Case nKey = K_ENTER
            Keyboard Left( cChar,1 )
            Exit
         Case nKey = K_TAB
            nBox ++
            If nBox > 4
               nBox := 1
            Endif
         Case nKey = K_SH_TAB
            nBox --
            If nBox = 0
               nBox := 4
            Endif
         Case nKey = K_UP
            nLine --
            If nLine = 0
               nLine := 4
            Endif
         Case nKey = K_DOWN
            nLine ++
            If nLine > 4
               nLine := 1
            Endif
         Case nKey = K_LEFT
            nCol --
            If nCol = 0
               nCol := 5
            Endif
         Case nKey = K_RIGHT
            nCol ++
            If nCol = 6
               nCol := 1
            Endif
         EndCase
      Enddo
      SetHelpTopic(oldTopic)
   Endif
   Restore Screen From cScr
Return NIL

Static Function UpdateCols(cNewBLoCol,cNewBHiCol)
   Local i,oColumn
   Local cCLoCol,cCHiCol
   Local cBLoCol := AsArray( bb:ColorSpec )[2]
   Local cBHiCol := AsArray( bb:ColorSpec )[3]

   For i = 1 To bb:ColCount()
      oColumn := bb:GetColumn(i)
      cCLoCol := AsArray( oColumn:cColor )[1]
      cCHiCol := AsArray( oColumn:cColor )[2]
      If cBLoCol == cCLoCol .and. cBHiCol == cCHiCol
         oColumn:cColor := cNewBLoCol+','+cNewBHiCol
         bb:SetColumn(i,oColumn)
      Endif
   Next i
Return NIL

Static Function UpdateSeps( cNewBHeadSep,cNewBColSep,cNewBFootSep )
   Local i,oColumn
   Local cBHeadSep := bb:HeadSep
   Local cBColSep := bb:ColSep
   Local cBFootSep := bb:FootSep
   For i = 1 To bb:ColCount()
      oColumn := bb:GetColumn(i)
      If cBHeadSep == oColumn:HeadSep
         oColumn:HeadSep := cNewBHeadSep
      Endif
      If cBColSep == oColumn:ColSep
         oColumn:ColSep := cNewBColSep
      Endif
      If cBFootSep == oColumn:FootSep
         oColumn:FootSep := cNewBFootSep
      Endif
      bb:SetColumn(i,oColumn)
   Next i
Return NIL

Static Function UpdateInd(cNewBLoCol,cNewBHiCol,cNewBHeadSep,;
                          cNewBColSep,cNewBFootSep)
   Local i,oColumn
   Local cCLoCol,cCHiCol
   Local cBLoCol := AsArray( bb:ColorSpec )[2]
   Local cBHiCol := AsArray( bb:ColorSpec )[3]
   Local cBHeadSep := bb:HeadSep
   Local cBColSep := bb:ColSep
   Local cBFootSep := bb:FootSep
   Local lCols:= .F.,lSeps := .F.
   Local nKey,cExpr
   Local cScr := SaveScreen( MAXROW()-8,0,MAXROW(),79 )

   For i = 1 To bb:ColCount()
      oColumn := bb:GetColumn(i)

      cExpr := Alltrim(Substr( oColumn:cBlock,4,Len(oColumn:cBlock)-4) )
      If Len(cExpr) > 65
         cExpr := Left( cExpr,62 )+'...'
      Endif

      cCLoCol := AsArray( oColumn:cColor )[1]
      cCHiCol := AsArray( oColumn:cColor )[2]

      lCols := ( cBLoCol == cCLoCol .and. cBHiCol == cCHiCol )

      If cBHeadSep == oColumn:HeadSep .or. ;
           cBColSep == oColumn:ColSep .or. ;
           cBFootSep == oColumn:FootSep
         lSeps := .T.
      Endif

      If lCols .or. lSeps
         Do Case
         Case lCols .and. lSeps
            SetHelpTopic('COLSSEPS')
            @ MAXROW()-8,0,MAXROW(),79 Box B_DOUBLE+' ' COLOR 'W+/B'
            @ MAXROW()-7,2 Say 'Column Number: '+Alltrim(Str(i)) COLOR 'W+/B'
            @ MAXROW()-6,2 Say 'Expression: '+cExpr COLOR 'W+/B'
            @ MAXROW()-5,2 Say 'Both The Colours And One Or More Of The Seperators Are Duplicated' COLOR 'W+/B'
            @ MAXROW()-4,2 Say 'Press <1> To Ignore Any Duplications' COLOR 'BG/B'
            @ MAXROW()-3,2 Say 'Press <2> To Update Both Colours And Seperators' COLOR 'BG/B'
            @ MAXROW()-2,2 Say 'Press <3> To Update Only The Seperators' COLOR 'BG/B'
            @ MAXROW()-1,2 Say 'Press <4> To Update Only The Colours' COLOR 'BG/B'
         Case lCols
            SetHelpTopic('COLSONLY')
            @ MAXROW()-6,0,MAXROW(),79 Box B_DOUBLE+' ' COLOR 'W+/B'
            @ MAXROW()-5,2 Say 'Column Number: '+Alltrim(Str(i)) COLOR 'W+/B'
            @ MAXROW()-4,2 Say 'Expression: '+cExpr COLOR 'W+/B'
            @ MAXROW()-3,2 Say 'Only The Colours Are Duplicated' COLOR 'W+/B'
            @ MAXROW()-2,2 Say 'Press <1> To Ignore Any Duplications' COLOR 'BG/B'
            @ MAXROW()-1,2 Say 'Press <2> To Update Only The Colours' COLOR 'BG/B'
         Case lSeps
            SetHelpTopic('SEPSONLY')
            @ MAXROW()-6,0,MAXROW(),79 Box B_DOUBLE+' ' COLOR 'W+/B'
            @ MAXROW()-5,2 Say 'Column Number: '+Alltrim(Str(i)) COLOR 'W+/B'
            @ MAXROW()-4,2 Say 'Expression: '+cExpr COLOR 'W+/B'
            @ MAXROW()-3,2 Say 'Only One Or More Of The Seperators Are Duplicated' COLOR 'W+/B'
            @ MAXROW()-2,2 Say 'Press <1> To Ignore Any Duplications' COLOR 'BG/B'
            @ MAXROW()-1,2 Say 'Press <2> To Update Only The Seperators' COLOR 'BG/B'
         EndCase

         Do While .T.
            nKey := CHR( HlpInkey(0) )
            Do Case
            Case nKey = '1'
               Exit
            Case nKey = '2' .and. lCols .and. lSeps
               oColumn:cColor := cNewBLoCol+','+cNewBHiCol
               If cBHeadSep == oColumn:HeadSep
                  oColumn:HeadSep := cNewBHeadSep
               Endif
               If cBColSep == oColumn:ColSep
                  oColumn:ColSep := cNewBColSep
               Endif
               If cBFootSep == oColumn:FootSep
                  oColumn:FootSep := cNewBFootSep
               Endif
               Exit
            Case ( nKey = '2' .and. lCols ) .or. ;
                 ( nKey = '4' .and. lCols .and. lSeps )
               oColumn:cColor := cNewBLoCol+','+cNewBHiCol
               Exit
            Case (nKey = '2' .and. lSeps) .or.;
                 (nKey = '3' .and. lSeps .and. lCols)
               If cBHeadSep == oColumn:HeadSep
                  oColumn:HeadSep := cNewBHeadSep
               Endif
               If cBColSep == oColumn:ColSep
                  oColumn:ColSep := cNewBColSep
               Endif
               If cBFootSep == oColumn:FootSep
                  oColumn:FootSep := cNewBFootSep
               Endif
               Exit
            EndCase
         Enddo
         bb:SetColumn( i,oColumn )
      Endif
      RestScreen( MAXROW()-8,0,MAXROW(),79,cScr )
   Next i

Return NIL

Static Function GenTBROWSE()
   Local i,oColumn,cScr := SaveScreen(0,0,MAXROW(),79)
   Local cFuncName := Left(bb:Name+Space(10),10)
   Local cPRGName := Left(bb:Name+Space(8),8)
   Local lComment := .F.
   Local lHeadSep := .F.
   Local lColSep := .F.
   Local lFootSep := .F.
   Local lFooter := .F.
   Local lWidth := .F.
   Local lColor := .F.
   Local aCopySpec := {}
   Local cColor
   Local cArray
   Local lOk := .T.
   Local nHandle,nLen

   OutPutTo()
   SetHelpTopic('GENCODE')
   @ 9,41 Get cPRGName Pict '@!' Valid OutValid( cPRGName,'.PRG Filename.' )
   @ 11,41 Get cFuncName Pict '@!' Valid OutValid( cFuncName,'Function Name.')
   @ 13,45 Get lComment Pict 'Y'
   Readit( GetList );GetList := {}

   If !Lastkey() = 27
      If File( Alltrim(cPRGName)+'.PRG' )
         // Overwrite
         @ MAXROW()-2,0,MAXROW(),79 Box Space(9) COLOR 'W+/B'
         @ MAXROW()-1,0 Say PADC( Alltrim(cPRGName)+' Already Exists. Create Backup File And Overwrite ? ',80) COLOR 'W+/B'
         Do While .T.
            Inkey(0)
            If Chr(Lastkey()) $ 'Nn'
               lOk := .F.
               Exit
            Endif
            If Chr(Lastkey()) $ 'Yy'
               // Create The Backup File
               If File( Alltrim( cPRGName )+'.BAK' )
                  DELETE FILE &(Alltrim(cPRGName)+'.BAK')
               Endif
               RENAME &(Alltrim(cPRGName)+'.PRG') TO &(Alltrim(cPRGName)+'.BAK')
               Exit
            Endif
         Enddo
      Endif

      If lOk
         @ 0,0 Say 'Generating Function : '+cFuncName+'() Into .PRG file: '+cPRGName+Space(25) COLOR 'W+/B'
         cPRGName := Alltrim( cPRGName )+'.PRG'
         cFuncName := Alltrim( cFuncName )
         AEVAL( AsArray( bb:ColorSpec ),;
                {|x,n|cColor := x,;
                      IF(ASCAN( aCopySpec,{|y|y==cColor})=0,AADD(aCopySpec,cColor),NIL)} )

         For i = 1 To Len( aCopySpec )
            If i = 1
               cColor := aCopySpec[1]
            Else
               cColor += ','+aCopySpec[i]
            Endif
         Next i

#IFDEF DEMO
         cPRGName := 'BMDEMO$$.$$$'
         SetColor('GR+/B')
         Clear Screen
         @ 0,0 Say ' Source Code Can Only Be Viewed Not Generated In This Demonstration Version Of'
         ? '                           The Rhino Browse Manager'
         ? Repl('',80)
#ENDIF

         Set printer to &cPRGName
         set print on
         set cons off
         lComment := !lComment

         If lComment
            ? '/*'
            ? '    Function '+Alltrim(cFuncName)
            ? '    Purpose: To Return The TBROWSE object definition'
            ? '             called '+Alltrim(bb:Name)
            ?
            ? '    This function was generated from the BROWSE MANAGER'
            ? '    Clipper Add-On Library On: '+DTOC(Date())+' At: '+Left(Time(),5)
            ?
            ? '    Compile Switches: /n/w/a'
            ? '*/'
            ?
         Endif
         ? 'Function '+Alltrim(cFuncName)+'()'
         ?
         If lComment
            ? '// Local Declarations'
            ?
         Endif
         ? 'Local oBrowse'+IF( lComment,'      // TBROWSE Object','')
         ? 'Local oColumn'+IF( lComment,'      // TBCOLUMN Object','')
         ?
         ? '   oBrowse := TBrowseDB( '
         ?? Alltrim(Str( bb:nTop ))+' , '
         ?? Alltrim(Str( bb:nLeft ))+' , '
         ?? Alltrim(Str( bb:nBottom ))+' , '
         ?? Alltrim(Str( bb:nRight ))+' )'+IF( lComment,'   // Create The TBROWSE Object','')
         ?
         ? '   oBrowse:ColorSpec := "'+cColor+'"'+IF( lComment,'   // TBROWSE Colour String','')
         ?
         ? '   oBrowse:HeadSep := "'+bb:HeadSep+'"'+IF( lComment,'   // Default Header Seperator','')
         ?
         ? '   oBrowse:ColSep := "'+bb:ColSep+'"'+IF( lComment,'   // Default Column Seperator','')
         ?
         ? '   oBrowse:FootSep := "'+bb:FootSep+'"'+IF( lComment,'   // Default Footer Seperator','')
         ?
         If (!bb:Freeze = NIL) .and. bb:Freeze > 0
            ? '   oBrowse:Freeze := '+Alltrim(Str(bb:Freeze))+IF( lComment,'   // Set Freeze Position','')
         Endif
         ?

         If lComment
            ? '   // Create The TBCOLUMNs And Add Them To The TBROWSE Object'
         Endif
         For i = 1 To bb:ColCount()
            If lComment
               ? '   // Column Number '+Alltrim(Str(i))
            Endif
            oColumn := bb:GetColumn( i )
            If i = 1 .and. lComment
               ? '   // Create A New Column Object'
            Endif
            ? '   oColumn := TBColumnNew( "'
            ?? oColumn:Heading+'" , '
            ?? oColumn:cBlock+' )'

            cArray := '{ '
            cArray += Alltrim(Str( ASCAN( aCopySpec,{|x|x==AsArray(oColumn:cColor)[1]} )))+' , '
            cArray += Alltrim(Str( ASCAN( aCopySpec,{|x|x==AsArray(oColumn:cColor)[2]} )))+' }'

            If !cArray == '{ 1 , 2 }'
               ? '   oColumn:DefColor := '+cArray
               If lComment .and. !lColor
                  ?? '   // Setup The Column Colours'
                  lColor := .T.
               Endif
            Endif

            If !bb:HeadSep == oColumn:HeadSep
               ? '   oColumn:HeadSep := "'+oColumn:HeadSep+'"'
               If lComment .and. !lHeadSep
                  ?? '   // Setup Header Seperator For This Column'
                  lHeadSep := .T.
               Endif
            Endif
            If !bb:ColSep == oColumn:ColSep
               ? '   oColumn:ColSep := "'+oColumn:ColSep+'"'
               If lComment .and. !lColSep
                  ?? '   // Setup Column Seperator For This Column'
                  lColSep := .T.
               Endif
            Endif
            If !bb:FootSep == oColumn:FootSep
               ? '   oColumn:FootSep := "'+oColumn:FootSep+'"'
               If lComment .and. !lFootSep
                  ?? '   // Setup Footer Seperator For This Column'
                  lFootSep := .T.
               Endif
            Endif
            If (!oColumn:Footing = NIL) .and. Len( oColumn:Footing ) > 0
               ? '   oColumn:Footing := "'+oColumn:Footing+'"'
               If lComment .and. !lFooter
                  ?? '   // Setup Footer For This Column'
                  lFooter := .T.
               Endif
            Endif
            If !oColumn:width = NIL
               ? '   oColumn:Width := '+Alltrim(Str( oColumn:Width ))
               If lComment .and. !lWidth
                  ?? '   // Setup Width For This Column'
                  lWidth := .T.
               Endif
            Endif
            ? '   oBrowse:AddColumn( oColumn )'
            If i = 1 .and. lComment
               ?? '   // Add The Column To The Browse Object'
            Endif
            ?

         Next i
         ?
         ? 'Return ( oBrowse )'+IF( lComment,'   // Return the TBROWSE Object','')
         Set printer to
         set print off
         set cons on
      Endif
   Endif
   SetHelpTopic('NORMAL')

#IFDEF DEMO
   @ MAXROW()-2,0 Say Repl('',80)
   @ MAXROW()-1,26 Say 'Use Cursor Keys To View Text'
   @ MAXROW(),19 Say 'Press <Esc> To Return To Normal Execution'
   SetColor('W+/B')
   MEMOEDIT( MEMOREAD( cPRGName ),3,0,MAXROW()-3,MAXCOL(),.F. )
   nHandle := FOPEN( cPRGName,FO_READWRITE )
   nLen := FSEEK( nHandle,0,2 )
   FSEEK( nHandle,0,0 )
   FWRITE( nHandle,Space( nLen ) )
   FCLOSE( nHandle )
   DELETE FILE &cPRGName
#ENDIF

   RestScreen( 0,0,MAXROW(),79,cScr )

Return NIL

Static Function GenBrowseMan()
   Local i,oColumn,cScr := SaveScreen(0,0,MAXROW(),79)
   Local cFuncName := Left(bb:Name+Space(10),10)
   Local cPRGName := Left(bb:Name+Space(8),8)
   Local lComment := .F.
   Local lHeadSep := .F.
   Local lColSep := .F.
   Local lFootSep := .F.
   Local lFooter := .F.
   Local lWidth := .F.
   Local lColor := .F.
   Local lcBlock := .F.
   Local aCopySpec
   Local cArray
   Local cColor
   Local lOk := .T.

   OutPutTo()
   SetHelpTopic('GENCODE')
   @ 9,41 Get cPRGName Pict '@!' Valid OutValid( cPRGName,'.PRG Filename.' )
   @ 11,41 Get cFuncName Pict '@!' Valid OutValid( cFuncName,'Function Name.')
   @ 13,45 Get lComment Pict 'Y'
   Readit( GetList );GetList := {}

   If !Lastkey() = 27
      If File( Alltrim(cPRGName)+'.PRG' )
         // Overwrite
         @ MAXROW()-2,0,MAXROW(),79 Box Space(9) COLOR 'W+/B'
         @ MAXROW()-1,0 Say PADC( Alltrim(cPRGName)+' Already Exists. Create Backup File And Overwrite ? ',80) COLOR 'W+/B'
         Do While .T.
            Inkey(0)
            If Chr(Lastkey()) $ 'Nn'
               lOk := .F.
               Exit
            Endif
            If Chr(Lastkey()) $ 'Yy'
               // Create The Backup File
               If File( Alltrim( cPRGName )+'.BAK' )
                  DELETE FILE &(Alltrim(cPRGName)+'.BAK')
               Endif
               RENAME &(Alltrim(cPRGName)+'.PRG') TO &(Alltrim(cPRGName)+'.BAK')
               Exit
            Endif
         Enddo
      Endif

      If lOk
         @ 0,0 Say 'Generating Function : '+cFuncName+'() Into .PRG file: '+cPRGName+Space(25) COLOR 'W+/B'
         cPRGName := Alltrim( cPRGName )+'.PRG'
         cFuncName := Alltrim( cFuncName )

         aCopySpec := AsArray( bb:ColorSpec )
         cColor := aCopySpec[1]+','+aCopySpec[2]+','+aCopySpec[3]

#IFDEF DEMO
         cPRGName := 'BMDEMO$$.$$$'
         SetColor('GR+/B')
         Clear Screen
         @ 0,0 Say ' Source Code Can Only Be Viewed Not Generated In This Demonstration Version Of'
         ? '                           The Rhino Browse Manager'
         ? Repl('',80)
#ENDIF

         Set printer to &cPRGName
         set print on
         set cons off
         lComment := !lComment

         If lComment
            ? '/*'
            ? '    Function '+Alltrim(cFuncName)
            ? '    Purpose: To Return The BMBROWSE object definition'
            ? '             called '+Alltrim(bb:Name)
            ?
            ? '    This function was generated from the BROWSE MANAGER'
            ? '    CA-Clipper Utility Library On: '+DTOC(Date())+' At: '+Left(Time(),5)
            ?
            ? '    Compile Switches: /n/w/a'
            ? '*/'
            ?
         Endif
         ? "#include 'BMKEYMAP.CH'"+IF(lComment,'   // Header File For BMBROWSE Key Map Positions','')
         ?
         ? 'Function '+Alltrim(cFuncName)+'()'
         ?
         If lComment
            ? '// Local Declarations'
            ?
         Endif
         ? 'Local oBrowse'+IF( lComment,'      // BMBROWSE Object','')
         ? 'Local oColumn'+IF( lComment,'      // BMCOLUMN Object','')
         ?
         ? '   oBrowse := BMBrowseDB( '
         ?? Alltrim(Str( bb:nTop ))+' , '
         ?? Alltrim(Str( bb:nLeft ))+' , '
         ?? Alltrim(Str( bb:nBottom ))+' , '
         ?? Alltrim(Str( bb:nRight ))+' )'+IF( lComment,'   // Create The BMBROWSE Object','')
         ?
         ? '   oBrowse:ColorSpec := "'+cColor+'"'+IF( lComment,'   // BMBROWSE Colour String','')
         ?
         ? '   oBrowse:HeadSep := "'+bb:HeadSep+'"'+IF( lComment,'   // Default Header Seperator','')
         ?
         ? '   oBrowse:ColSep := "'+bb:ColSep+'"'+IF( lComment,'   // Default Column Seperator','')
         ?
         ? '   oBrowse:FootSep := "'+bb:FootSep+'"'+IF( lComment,'   // Default Footer Seperator','')
         ?
         If (!bb:Freeze = NIL) .and. bb:Freeze > 0
            ? '   oBrowse:Freeze := '+Alltrim(Str(bb:Freeze))+IF( lComment,'   // Set Freeze Position','')
            ?
         Endif
         If Len(Alltrim(bb:Border)) > 0
            ? '   oBrowse:Border := "'+bb:Border+'"'+IF( lComment,'   // Set The Border For The Browse','')
            ?
         Endif

         If bb:nTop <> bb:eTop .or. bb:nLeft <> bb:eLeft .or. ;
               bb:nBottom <> bb:eBottom .or. bb:nRight <> bb:eRight
            If lComment
               ? '   // Set Up The Alternate Browse Position'
            Endif
            ? '   oBrowse:eTop := '+Alltrim(Str(bb:eTop))
            ? '   oBrowse:eLeft := '+Alltrim(Str(bb:eLeft))
            ? '   oBrowse:eBottom := '+Alltrim(Str(bb:eBottom))
            ? '   oBrowse:eRight := '+Alltrim(Str(bb:eRight))
            ?
         Endif

         If lComment
            ? '   // Setup The BMBrowse Key Map'
         Endif
         ? '   oBrowse:SetKey( BMK_UP , '+Alltrim(Str( bb:SetKey( BMK_UP       )))+' )'
         ? '   oBrowse:SetKey( BMK_DOWN , '+Alltrim(Str( bb:SetKey( BMK_DOWN     )))+' )'
         ? '   oBrowse:SetKey( BMK_LEFT , '+Alltrim(Str( bb:SetKey( BMK_LEFT     )))+' )'
         ? '   oBrowse:SetKey( BMK_RIGHT , '+Alltrim(Str( bb:SetKey( BMK_RIGHT    )))+' )'
         ? '   oBrowse:SetKey( BMK_HOME , '+Alltrim(Str( bb:SetKey( BMK_HOME     )))+' )'
         ? '   oBrowse:SetKey( BMK_END , '+Alltrim(Str( bb:SetKey( BMK_END      )))+' )'
         ? '   oBrowse:SetKey( BMK_PGUP , '+Alltrim(Str( bb:SetKey( BMK_PGUP     )))+' )'
         ? '   oBrowse:SetKey( BMK_PGDN , '+Alltrim(Str( bb:SetKey( BMK_PGDN     )))+' )'
         ? '   oBrowse:SetKey( BMK_PANLEFT , '+Alltrim(Str( bb:SetKey( BMK_PANLEFT  )))+' )'
         ? '   oBrowse:SetKey( BMK_PANRIGHT , '+Alltrim(Str( bb:SetKey( BMK_PANRIGHT )))+' )'
         ? '   oBrowse:SetKey( BMK_GOTOP , '+Alltrim(Str( bb:SetKey( BMK_GOTOP    )))+' )'
         ? '   oBrowse:SetKey( BMK_GOBOTTOM , '+Alltrim(Str( bb:SetKey( BMK_GOBOTTOM )))+' )'
         ? '   oBrowse:SetKey( BMK_PANHOME , '+Alltrim(Str( bb:SetKey( BMK_PANHOME  )))+' )'
         ? '   oBrowse:SetKey( BMK_PANEND , '+Alltrim(Str( bb:SetKey( BMK_PANEND   )))+' )'
         ? '   oBrowse:SetKey( BMK_ESCAPE , '+Alltrim(Str( bb:SetKey( BMK_ESCAPE   )))+' )'
         ? '   oBrowse:SetKey( BMK_SELECT , '+Alltrim(Str( bb:SetKey( BMK_SELECT   )))+' )'
         ?
         If lComment
            ? '   // Create The BMCOLUMNs And Add Them To The BMBROWSE Object'
         Endif
         For i = 1 To bb:ColCount()
            If lComment
               ? '   // Column Number '+Alltrim(Str(i))
            Endif
            oColumn := bb:GetColumn( i )
            If i = 1 .and. lComment
               ? '   // Create A New Column Object'
            Endif
            ? '   oColumn := BMColumnNew( "'
            ?? oColumn:Heading+'" , '
            ?? oColumn:cBlock+' )'
            ? '   oColumn:cBlock := "'+oColumn:cBlock+'"'
            If lComment .and. !lcBlock
               ?? '   // Character Version Of Block'
               lcBlock := .T.
            Endif

            ? '   oColumn:cColor := "'+oColumn:cColor+'"'
            If lComment .and. !lColor
               ?? '   // Setup The Column Colours'
               lColor := .T.
            Endif

            If !bb:HeadSep == oColumn:HeadSep
               ? '   oColumn:HeadSep := "'+oColumn:HeadSep+'"'
               If lComment .and. !lHeadSep
                  ?? '   // Setup Header Seperator For This Column'
                  lHeadSep := .T.
               Endif
            Endif
            If !bb:ColSep == oColumn:ColSep
               ? '   oColumn:ColSep := "'+oColumn:ColSep+'"'
               If lComment .and. !lColSep
                  ?? '   // Setup Column Seperator For This Column'
                  lColSep := .T.
               Endif
            Endif
            If !bb:FootSep == oColumn:FootSep
               ? '   oColumn:FootSep := "'+oColumn:FootSep+'"'
               If lComment .and. !lFootSep
                  ?? '   // Setup Footer Seperator For This Column'
                  lFootSep := .T.
               Endif
            Endif
            If (!oColumn:Footing = NIL) .and. Len( oColumn:Footing ) > 0
               ? '   oColumn:Footing := "'+oColumn:Footing+'"'
               If lComment .and. !lFooter
                  ?? '   // Setup Footer For This Column'
                  lFooter := .T.
               Endif
            Endif
            If !oColumn:width = NIL
               ? '   oColumn:Width := '+Alltrim(Str( oColumn:Width ))
               If lComment .and. !lWidth
                  ?? '   // Setup Width For This Column'
                  lWidth := .T.
               Endif
            Endif
            ? '   oBrowse:AddColumn( oColumn )'
            If i = 1 .and. lComment
               ?? '   // Add The Column To The Browse Object'
            Endif
            ?
         Next i
         ?
         If lComment
            ? '   // Update BMBROWSE ColorSpec And All Columns DefColor'
         Endif
         ? '   oBrowse:SetColours()'
         ?
         ? 'Return ( oBrowse )'+IF( lComment,'   // Return the BMBROWSE Object','')


         Set printer to
         set print off
         set cons on
      Endif
   Endif
   SetHelpTopic('NORMAL')

#IFDEF DEMO
   @ MAXROW()-2,0 Say Repl('',80)
   @ MAXROW()-1,26 Say 'Use Cursor Keys To View Text'
   @ MAXROW(),19 Say 'Press <Esc> To Return To Normal Execution'
   SetColor('W+/B')
   MEMOEDIT( MEMOREAD( cPRGName ),3,0,MAXROW()-3,MAXCOL(),.F. )
   DELETE FILE &cPRGName
#ENDIF

   RestScreen( 0,0,MAXROW(),79,cScr )
Return NIL

Static Function OutValid( cVar,cExpr )
   Local lOk := .T.
   Local cScr := SaveScreen( MAXROW()-2,0,MAXROW(),79 )
   If Lastkey() <> K_F1
      If Len(Alltrim(cVar)) = 0
         lOk := .F.
         @ MAXROW()-2,0,MAXROW(),79 Box Space(9) COLOR 'W+/B'
         @ MAXROW()-1,0 Say PADC( 'You Must Something For The '+cExpr+' Press Any Key To Continue...',80) COLOR 'W+/B'
         If Left( cExpr ,1 ) = '.'
            Inkey(0)
          Else
            Inkey(0)
         Endif
         RestScreen( MAXROW()-2,0,MAXROW(),79,cScr )
      Endif
   Endif
Return lOk

Static Function GetField(xProc,xLine,cVar,oGet)
   Local cAlias := Alias()
   Local aFields,i
   Local cScr := SaveScreen( 0,0,MAXROW(),79 )
   Local nChoice
   Local oldColor := SetColor('BG/B,B/BG')
   If UPPER( oGet:Name ) = 'CEXPR'
      If Substr( oGet:Buffer,oGet:Pos-2,2 ) = '->'
         cAlias := ''
         For i = oGet:Pos-3 To 1 Step -1
            If Substr( oGet:Buffer,i,1 ) $ '!"$%^&*()@;:.>,<\|/?]}[{#~=+-` '+"'"
               Exit
            Endif
            cAlias := Substr( oGet:Buffer,i,1 )+cAlias
         Next i
      Endif
      cAlias := Left( cAlias,10 )
      aFields := (cAlias)->(DBSTRUCT())
      AEVAL( aFields ,{|x,y| aFields[y] := Left(x[1]+Space(10),10)+'  '+FType( x[2] )+'   '+Str( x[3],5 )+'  '+;
                        IF(x[2]='N',STR(x[4],2),'  ')} )
      If Len( aFields ) > 0
         @ MAX( MAXROW()-Len(aFields)-5,0),0,MAXROW(),36 Box B_DOUBLE+' ' COLOR 'W+/B'
         @ MAX( MAXROW()-Len(aFields)-4,1),2 Say 'Select Field From Alias Name' COLOR 'W+/B'
         @ MAX( MAXROW()-Len(aFields)-3,2),2 Say cAlias COLOR 'G/B'
         @ MAX( MAXROW()-Len(aFields)-2,3),0 Say ''+Repl('',35)+'' COLOR 'W+/B'
         @ MAX( MAXROW()-Len(aFields)-1,4),2 Say 'Field       Type       Length Dec' COLOR 'W+/B'
         SET KEY -4 To
         SET KEY -5 To
         SET KEY -6 To
         SET KEY K_LEFT TO Nothing
         SET KEY K_RIGHT TO Nothing
         nChoice := ACHOICE( MAX( MAXROW()-Len(aFields),5),2,MAXROW()-1,34,aFields )
         If nChoice > 0
            Keyboard Alltrim(Left(aFields[nChoice],10))
         Endif
         SET KEY -4 To GetField
         SET KEY -5 To GetBoxes
         SET KEY -6 To GetColours
         SET KEY K_LEFT To
         SET KEY K_RIGHT To
      Else
         // No Alias Name
         @ MAXROW()-2,0,MAXROW(),79 Box B_DOUBLE+' ' COLOR 'W+/B'
         @ MAXROW()-1,4 Say 'Alias Name Not Found Or Data Base Not Open...Press Any Key To Continue...' COLOR 'W+/B'
         Inkey(0)
      Endif
      RestScreen( 0,0,MAXROW(),79,cScr )
   Endif
   SetColor( oldColor )
Return NIL

Static Function FType( cChar )
   Static aTypes := {{'C','Character'},{'N','Numeric'},{'L','Logical'},;
                     {'M','Memo'},{'D','Date'}}
Return Left(aTypes[ASCAN( aTypes,{|x| x[1] = cChar} )][2]+Space(5),9)

Static Function Nothing()
Return NIL


Static Function HlpInkey( x )
   Local nKey
   Do While .T.
      If x = NIL
         nKey := Inkey()
      Else
         nKey := Inkey(x)
      Endif
      If nKey = K_F1
         DefineHelp()
      Else
         Exit
      Endif
   Enddo
Return nKey

Function SetHelpTopic( xTopic )
   cTopic := xTopic
Return NIL

Function DefineHelp( GetName )
   Local cScr := SaveScreen( 0,0,24,79 )
   Local doTopic := cTopic,cAlias,oldColor,i

   If !GetName == NIL
      doTopic += GetName
   Endif

   doTopic := Left(doTopic+Space(20),20)

   If !File( cHPath+'BMHELP.DBF' )
      @ 0,0 Say Space(80) Color 'GR+/R'
      @ 1,0 Say Space(80) Color 'GR+/R'
      @ 0,0 Say 'Help File Not Found. Use The SET BROWSE HELP TO <x> Command To Set The Help Path' COLOR 'GR+/R'
      @ 1,0 Say 'Press Any Key To Continue...' COLOR 'GR+/R'
      Inkey(0)
   Else
      cAlias := Alias()
      Select 0
      USE (cHPath+'BMHELP.DBF') EXCL
      If Used()
         If !File( cHPath+'BMHELP.NTX' )
            Index On BMHELP->TOPIC TO (cHPath+'BMHELP')
         Endif
         Set Index To (cHPath+'BMHELP')

         BMHELP->(DBSeek(doTopic))
         If BMHELP->(Eof())
//            APPEND BLANK
//            Replace BMHELP->TOPIC With doTopic
              @ 0,0 Say Space(80) Color 'GR+/R'
              @ 1,0 Say Space(80) Color 'GR+/R'
              @ 0,0 Say 'Help File Not Found. Use The SET BROWSE HELP TO <x> Command To Set The Help Path' COLOR 'GR+/R'
              @ 1,0 Say 'Press Any Key To Continue...' COLOR 'GR+/R'
         Else
            oldColor := SetColor( 'W+/B' )
            Clear Screen
            @ 0,0 Say ''
            ?? HARDCR( BMHELP->TEXT )
            @ MAXROW(),29 Say 'Press Any Key To Continue...'
            SetColor( oldColor )
         Endif
         Inkey(0)
         USE
//         Set Cursor On
//         Replace BMHELP->TEXT With MEMOEDIT( BMHELP->TEXT,0,0,24,79,.T. )
      Else
         @ 0,0 Say Space(80) Color 'GR+/R'
         @ 0,0 Say 'Help Files Could Not Be Opened. Press Any Key To Continue...'
         Inkey(0)
      Endif
      Select (cAlias)
   Endif
   RestScreen( 0,0,24,79,cScr )
Return NIL

Static Function CheckSave()
   Local nChoice,cScr := SaveScreen( 7,24,15,59 )
   SetHelpTopic('CHECKSAVE')
   SET MENU COLOR TO W+/G,GR+/G,W+/B,GR+/B
   @ 7,24,15,59 BOX B_DOUBLE+' ' COLOR 'B/W'
   @ 8,36 Say 'Warning !!!' COLOR 'R/W'
   @ 10,27 Say PADC( bb:Name+' has been modified.',29) COLOR 'B/W'
   @ 12,26 Say 'Do you wish to save the browse ?' COLOR 'B/W'
   @ 14,31 PROMPT ' ~Yes '
   @ 14,39 PROMPT ' ~No '
   @ 14,46 PROMPT ' ~Cancel '
   Menu To nChoice
   If nChoice = 1
      bbSave()
   Endif
   RestScreen( 7,24,15,59,cScr )
   SetHelpTopic('NORMAL')
Return !(nChoice = 3 .or. nChoice = 0)

Static Function NameCheck( cName )
   Local lOk := Len(Alltrim(cName)) > 0
   Local cScr
   If !lOk
      // Message
      cScr := SaveScreen( MAXROW()-2,0,MAXROW(),79 )
      @ MAXROW()-2,0,MAXROW(),79 BOX Space(9) COLOR 'W+/B'
      @ MAXROW()-1,0 Say '      You Must Enter A Name For The Browse. Press Any Key To Continue...' COLOR 'W+/B'
      Inkey(0)
      RestScreen( MAXROW()-2,0,MAXROW(),79,cScr )
   Endif
Return lOk

Static Function ColCheck( cCol,nMode,oGet )
   Local oldColor := SetColor()
   If nMode = 1
      cCol := STRTRAN( cCol,'*','+' )
      SetColor( cCol )
      cCol := Left( SetColor(),AT( '/',SetColor() )-1 )
   Else
      cCol := STRTRAN( cCol,'+','*' )
      SetColor( Left( SetColor(),AT( '/',SetColor() ) )+cCol )
      cCol := Left( SetColor(),AT( ',',SetColor() )-1 )
      cCol := Right( cCol,Len(cCol)-AT('/',cCol) )
   Endif
   cCol := Left( cCol+Space(4),4 )
Return .T.

Static Function ExprCheck( cExpr )
   Local bBlock
   Local errBlock := ERRORBLOCK( {|x|BlockError(x)} )
   Local lOk := .T.
   Local cScr

   If !Lastkey() = K_F5

      BEGIN SEQUENCE
         bBlock := '{||'+Alltrim(cExpr)+'}'
         BEGIN SEQUENCE
            EVAL( &bBlock )
         END SEQUENCE
         EVAL( &bBlock )
      RECOVER
         lOk := .F.
         // Error Message
         cScr := SaveScreen( MAXROW()-3,0,MAXROW(),79 )
         @ MAXROW()-3,0,MAXROW(),79 BOX Space(9) COLOR 'W+/B'
         @ MAXROW()-2,0 Say '    The Expression That You Have Entered Is Invalid. Please Enter A Valid' COLOR 'W+/B'
         @ MAXROW()-1,0 Say '                   Expression. Press Any Key To Continue...' COLOR 'W+/B'

         Inkey(0)
         RestScreen( MAXROW()-3,0,MAXROW(),79,cScr )
      END SEQUENCE
   Endif

   ERRORBLOCK( errBlock )
Return lOk

Static Function BlockError(x)
   BREAK
Return .F.

Function BrowseHPath( xPath )
   cHPath := Upper(GETENV('BMHELP'))
   cHPath += IF( Right(cHPath,1)='\','','\' )
   cHPath := IF( Len(cHPath) = 1,'',cHPath )
Return NIL

#ENDIF

// Path Stuff

Function BrowsePath( xPath )
   If xPath = NIL
      cPath := Upper( GETENV( cBEnvironment ))
   Else
      cPath := Upper( xPath )
   Endif
   cPath += IF( Right(cPath,1)='\','','\' )
   cPath := IF( Len(cPath) = 1,'',cPath )
Return NIL

Function BrowseEnv( xVar )
   If xVar = NIL
      cBEnvironment := 'BMFILES'
   Else
      cBEnvironment := UPPER( xVar )
   Endif
Return NIL

#IFNDEF RUNTIME
*****************************************************************************
* SCREEN STUFF
*****************************************************************************
Static Function KeyMap()
   @ 0,0,MAXROW(),MAXCOL() BOX Space(9) COLOR 'W/N'
   @ 00,00,24,79 BOX "Ŀ " COLOR 'W+/B'
   @ 04,02 SAY "Current Key Setting"+space(42)+"New Key Setting" COLOR 'W+/B'
   @ 05,27 SAY "Up On Row" COLOR 'W+/B'
   @ 06,27 SAY "Down One Row" COLOR 'W+/B'
   @ 07,27 SAY "Left One Column" COLOR 'W+/B'
   @ 08,27 SAY "Right One Column" COLOR 'W+/B'
   @ 09,27 SAY "First Visible Column" COLOR 'W+/B'
   @ 10,27 SAY "Last Visible Column" COLOR 'W+/B'
   @ 12,27 SAY "Up One Page" COLOR 'W+/B'
   @ 13,27 SAY "Down One Page" COLOR 'W+/B'
   @ 14,27 SAY "Pan Left" COLOR 'W+/B'
   @ 15,27 SAY "Pan Right" COLOR 'W+/B'
   @ 17,27 SAY "First Record" COLOR 'W+/B'
   @ 18,27 SAY "Last Record" COLOR 'W+/B'
   @ 19,27 SAY "First Column" COLOR 'W+/B'
   @ 20,27 SAY "Last Column" COLOR 'W+/B'
   @ 22,27 SAY "Abort Key" COLOR 'W+/B'
   @ 23,27 SAY "Selection Key" COLOR 'W+/B'
   @ 00,32 SAY " Browse Key Map " COLOR 'W+/BG'
   @ 01,03,03,78 BOX "         " COLOR 'GR+/B'
   @ 01,03 SAY "Press The Key You Wish To Use Or Press And Release The <Alt> Key To Accept" COLOR 'GR+/B'
   @ 02,03 SAY "The Current Setting. If You Do Not Wish To Any Specific Movement Key Press" COLOR 'GR+/B'
   @ 03,03 SAY "And Release The <Ctrl> Key." COLOR 'GR+/B'
Return NIL

Static Function Browedit()
   SET COLOR TO +W/B
   @ 00,00,18,79 BOX "Ŀ "
   @ 01,02 SAY "Browse Name:"
   @ 03,02 SAY "Seperators"
   @ 05,04 SAY "Header Seperator:"
   @ 06,04 SAY "Column Seperator:"
   @ 07,04 SAY "Footer Seperator:"
   @ 08,08 SAY "Border Frame:"
   @ 10,02 SAY "Background, Border And Seperator Colours"
   @ 12,08 SAY "Colour:"
   @ 14,02 SAY "Default Colours For New Columns"
   @ 16,15 SAY "Unhilighted:"
   @ 17,15 SAY "Hilighted  :"
   SET COLOR TO +GR/B
   @ 15,02 SAY "(Press      To Select The Colours)"
   @ 04,02 SAY "(Press      To Select From Box Characters"
   SET COLOR TO +W/W
   @ 00,31 SAY " Browse Definition "
   SET COLOR TO +G/B
   @ 04,09 SAY "<F6>"
   @ 15,09 SAY "<F7>"
   SET COLOR TO +GR/B
   @ 11,02 SAY "(Press      To Select The Colours)"
   SET COLOR TO +G/B
   @ 11,09 SAY "<F7>"
Return NIL

Static Function ColEdit()
   SET COLOR TO +W/B
   @ 00,00,17,79 BOX "Ŀ "
   @ 01,02 SAY "Expression:"
   @ 04,02 SAY "Header:"
   @ 05,02 SAY "Footer:"
   @ 07,02 SAY "Seperators"
   @ 09,04 SAY "Header Seperator:"
   @ 10,04 SAY "Column Seperator:"
   @ 11,04 SAY "Footer Seperator:"
   @ 13,02 SAY "Default Colours"
   @ 15,15 SAY "UnHilighted:"
   @ 16,15 SAY "Hilighted  :"
   SET COLOR TO +GR/B
   @ 14,02 SAY "(Press      To Select The Colours)"
   @ 08,02 SAY "(Press      To Select From Box Characters"
   @ 02,02 SAY "(Press      for a list of fields)"
   SET COLOR TO +W/W
   @ 00,31 SAY " Column Definition "
   SET COLOR TO +G/B
   @ 02,09 SAY "<F5>"
   @ 08,09 SAY "<F6>"
   @ 14,09 SAY "<F7>"
Return NIL

Static Function Boxes()
   @ 19,0,24,79 Box Space(9) COLOR 'N/N'
   @ 19,11 SAY "ͻ            Ŀ            ķ            ͸" COLOR 'W/N'
   @ 20,11 SAY "͹            Ĵ            Ķ            ͵" COLOR 'W/N'
   @ 21,11 SAY "                                            " COLOR 'W/N'
   @ 22,11 SAY "ͼ                        Ľ            ;" COLOR 'W/N'
   @ 23,00,24,79 BOX Space(9) COLOR 'B/BG'
   @ 23,05 SAY "Move The Cursor To The Character You Wish To Use And Press <Enter> To" COLOR 'B/BG'
   @ 24,04 SAY "Select And Place Into The Entry Field Press <Tab> To Move Between Boxes" COLOR 'B/BG'
Return NIL

Static Function OutputTo()
   @ 08,24,14,54 BOX "ͻȺ " COLOR 'W+/B' COLOR 'W+/B'
   @ 09,26 SAY ".PRG Filename:         .PRG" COLOR 'W+/B'
   @ 11,26 SAY "Function Name:           ()" COLOR 'W+/B'
   @ 13,26 SAY "Suppress Comments:" COLOR 'W+/B'
Return NIL

*****************************************************************************
* BSTORE Stuff
*****************************************************************************

Static function bbSave()
   Local aSet := bb:SaveSet()
   nHandle := fCreate( cpath+Alltrim(bb:Name)+'.bm' )
   hiStore( bb )
   fClose( nHandle )
   nHandle := -1
   bb:RestSet( aSet )
return NIL

static function hiStore( thing )
   local worked, i
   do case
   case valtype( thing ) == "O"
      myOut( "O"+left( thing:classname()+space(10), 10) )
      doarray( thing )

   case valtype( thing ) == "A"
      doarray( thing )

   otherwise
      myOut( doitem( thing ) )
   end case
return( worked )

static function doArray( arr )
   local i
   myOut( "A"+ l2bin(len( arr )) )
   for i = 1 to len(arr)
      myOut( doitem( arr[i] ) )
   next i
return( nil )

static function doitem( item )
   local retVal, typ := valtype( item )

   do case
   case typ == "C"
      retVal := "C"+l2bin(len( item) )+item

   case typ == "D"
      retVal := "D"+l2bin( item - ctod("01/01/70") )

   case typ == "L"
      retVal := "L"+if(item, "T", "F")

   case typ == "N"
      retVal := "N"+l2bin(item)

   case typ == "U"
      retVal := "U"

   case typ == "B"
      retVal := "B"

   otherwise
      hiStore( item )

   end case

return( retVal )

static function myOut( in )
   fwrite( nHandle, in )
return( nil )

#ENDIF

Static function bbLoad( name )
   local retVal
   local attrib
#IFNDEF RUNTIME
   Local cScr := SaveScreen(0,0,0,79)
#ENDIF
   If File( cPath+Alltrim(Name)+'.bm' )
#IFNDEF RUNTIME
      @ 0,0 Say 'Loading Browse '+name+IF(Len(cPath)>0,' from '+cPath,'')+' ...'+Space(70) COLOR 'W+/B'
#ENDIF
      nHandle := fOpen( cPath+Alltrim(Name)+'.bm' )
      nCount := fSeek(nHandle, 0, 2)                // how long is the object
      cBuffer := space(nCount)
      fSeek(nHandle, 0, 0)
      fRead( nHandle, @cBuffer, nCount )
      fClose( nHandle )
      pos := 1
      retval := LowGet()
      nHandle := -1
   Endif
#IFNDEF RUNTIME
   Restscreen(0,0,0,79,cScr)
#ENDIF
return( retval )



Static function lowGet()                                // get the next thing
   local cName, length, aVal, i
   local attrib, retVal, cObj

   // get attrib
   attrib := substr( cBuffer, pos++, 1 )

   do case
   case attrib == "O"
      //Get the class name
      cName := alltrim( substr( cBuffer, pos, 10 ) ) + "()"
       pos += 10
      If cName = 'TBROWSE()'
         cName := 'TBROWSENEW(1,1,1,1)'
      Endif
      cObj := &cName
      aVal := lowget()
      for i = len( cObj ) to 1 step -1
         cObj[i] := aVal[i]
      next i
      retVal := cObj

   case attrib == "A"
      // get length
      length := bin2l( substr( cBuffer, pos, 4 ) )
		pos += 4
      retVal := array( length )
      for i = 1 to length
         retVal[i] := lowget()
      next i

   case attrib == "C"
      // get Length
      length := bin2l( substr( cBuffer, pos, 4 ) )
		pos += 4
		retVal := substr( cBuffer, pos, length )
		pos += length

   case attrib == "D"
      length := bin2l( substr( cBuffer, pos, 4 ) )
		pos += 4
		retVal := ctod("01/01/70")+length

   case attrib == "L"
      retVal := if( substr( cBuffer, pos++, 1 ) == "T", .t., .f. )

   case attrib == "N"
      retVal := bin2l( substr( cBuffer, pos, 4 ) )
		pos += 4


   case attrib == "B"
      retVal := nil

   case attrib == "U"
      retVal := nil

   end

return( retVal )

Function GetTopic()
Return cTopic

