#include 'oops.ch'
#include "box.ch"
#include 'inkey.ch'
#command default <x> to <v> => if <x> == nil; <x> := <v>; endif

memvar getlist

Static ClipBoard

#IFNDEF CODE
   #xtranslate ::Name => Self\[1\]
   #xtranslate ::eTop => Self\[2\]
   #xtranslate ::eLeft => Self\[3\]
   #xtranslate ::eBottom => Self\[4\]
   #xtranslate ::eRight => Self\[5\]
   #xtranslate ::Border => Self\[6\]
   #xtranslate ::Holder => Self\[7\]
   #xtranslate O:Holder => O\[7\]
   #xtranslate ::KeyMap => Self\[8\]
   #xtranslate ::RedrawFrame => Self\[9\]
   #xtranslate ::ReDoActions => Self\[10\]
   #xtranslate ::BackScreen => Self\[11\]
   #xtranslate ::Actions => Self\[12\]
   #xtranslate ::cGoBottom => Self\[13\]
   #xtranslate ::cGoTop => Self\[14\]
   #xtranslate ::cSkip => Self\[15\]

   #xtranslate oColumn:DefColor => oColumn\[4\]
   #xtranslate oColumn:cColor => oColumn\[12\]
#ENDIF

Function BMBrowseDB( t,l,b,r )
   Local oBrowse := BMBrowse():InitDB(t, l, b, r)
Return oBrowse

Function BMBrowseNew( t,l,b,r )
   Local oBrowse := BMBrowse():InitNew(t, l, b, r)
Return oBrowse


Class BMBrowse
   Var Name
   Var eTop, eLeft, eBottom, eRight
   Var Border
   Var holder
   Var KeyMap
   Var RedrawFrame
   Var ReDoActions
   Var BackScreen
   Var Actions
   Var cGoBottom
   Var cGoTop
   Var cSkip
   Var blink
   Message AUTOLITE   ACTION { |O| O:holder:AUTOLITE() }
   Message CARGO      ACTION { |O| O:holder:CARGO() }
   Message COLCOUNT   ACTION { |O| O:holder:COLCOUNT() }
   Message COLORRECT  ACTION { |O,_1,_2| O:holder:COLORRECT(_1,_2) }
   Message COLORSPEC  ACTION { |O| O:holder:COLORSPEC() }
   Message COLPOS     ACTION { |O| O:holder:COLPOS() }
   Message COLSEP     ACTION { |O| O:holder:COLSEP() }
   Message COLWIDTH   ACTION { |O,_1| O:holder:COLWIDTH(_1) }
   Message DEHILITE   ACTION { |O| O:holder:DEHILITE() }
   Message DELCOLUMN  ACTION { |O,_1| O:holder:DELCOLUMN(_1) }
   Message DOWN       ACTION { |O| O:holder:DOWN() }
   Message END        ACTION { |O| O:holder:END() }
   Message FOOTSEP    ACTION { |O| O:holder:FOOTSEP() }
   Message FREEZE     ACTION { |O| O:holder:FREEZE() }
   Message GETCOLUMN  ACTION { |O,_1| O:holder:GETCOLUMN(_1) }
   Message GOBOTTOM   ACTION { |O| O:holder:GOBOTTOM() }
   Message GOBOTTOMBL ACTION { |O| O:holder:GOBOTTOMBL() }
   Message GOTOP      ACTION { |O| O:holder:GOTOP() }
   Message GOTOPBLOCK ACTION { |O| O:holder:GOTOPBLOCK() }
   Message HEADSEP    ACTION { |O| O:holder:HEADSEP() }
   Message HILITE     ACTION { |O| O:holder:HILITE() }
   Message HITBOTTOM  ACTION { |O| O:holder:HITBOTTOM() }
   Message HITTOP     ACTION { |O| O:holder:HITTOP() }
   Message HOME       ACTION { |O| O:holder:HOME() }
   Message INSCOLUMN  ACTION { |O,_1,_2| O:holder:INSCOLUMN(_1,_2) }
   Message INVALIDATE ACTION { |O| O:holder:INVALIDATE() }
   Message LEFT       ACTION { |O| O:holder:LEFT() }
   Message LEFTVISIBL ACTION { |O| O:holder:LEFTVISIBL() }
   Message NBOTTOM    ACTION { |O| O:holder:NBOTTOM() }
   Message NLEFT      ACTION { |O| O:holder:NLEFT() }
   Message NRIGHT     ACTION { |O| O:holder:NRIGHT() }
   Message NTOP       ACTION { |O| O:holder:NTOP() }
   Message PAGEDOWN   ACTION { |O| O:holder:PAGEDOWN() }
   Message PAGEUP     ACTION { |O| O:holder:PAGEUP() }
   Message PANEND     ACTION { |O| O:holder:PANEND() }
   Message PANHOME    ACTION { |O| O:holder:PANHOME() }
   Message PANLEFT    ACTION { |O| O:holder:PANLEFT() }
   Message PANRIGHT   ACTION { |O| O:holder:PANRIGHT() }
   Message REFRESHALL ACTION { |O| O:holder:REFRESHALL() }
   Message REFRESHCUR ACTION { |O| O:holder:REFRESHCUR() }
   Message RIGHT      ACTION { |O| O:holder:RIGHT() }
   Message RIGHTVISIB ACTION { |O| O:holder:RIGHTVISIB() }
   Message ROWCOUNT   ACTION { |O| O:holder:ROWCOUNT() }
   Message ROWPOS     ACTION { |O| O:holder:ROWPOS() }
   Message SETCOLUMN  ACTION { |O,_1,_2| O:holder:SETCOLUMN(_1,_2) }
   Message SKIPBLOCK  ACTION { |O| O:holder:SKIPBLOCK() }
   Message STABLE     ACTION { |O| O:holder:STABLE() }
   Message UP         ACTION { |O| O:holder:UP() }
   Message _AUTOLITE  ACTION { |O,_1| O:holder:_AUTOLITE(_1) }
   Message _CARGO     ACTION { |O,_1| O:holder:_CARGO(_1) }
   Message _COLORSPEC ACTION { |O,_1| O:holder:_COLORSPEC(_1) }
   Message _COLPOS    ACTION { |O,_1| O:holder:_COLPOS(_1) }
   Message _COLSEP    ACTION { |O,_1| O:holder:_COLSEP(_1) }
   Message _FOOTSEP   ACTION { |O,_1| O:holder:_FOOTSEP(_1) }
   Message _FREEZE    ACTION { |O,_1| O:holder:_FREEZE(_1) }
   Message _GOBOTTOMB ACTION { |O,_1| O:holder:_GOBOTTOMB(_1) }
   Message _GOTOPBLOC ACTION { |O,_1| O:holder:_GOTOPBLOC(_1) }
   Message _HEADSEP   ACTION { |O,_1| O:holder:_HEADSEP(_1) }
   Message _HITBOTTOM ACTION { |O,_1| O:holder:_HITBOTTOM(_1) }
   Message _HITTOP    ACTION { |O,_1| O:holder:_HITTOP(_1) }
   Message _NBOTTOM   ACTION { |O,_1| O:holder:_NBOTTOM(_1) }
   Message _NLEFT     ACTION { |O,_1| O:holder:_NLEFT(_1) }
   Message _NRIGHT    ACTION { |O,_1| O:holder:_NRIGHT(_1) }
   Message _NTOP      ACTION { |O,_1| O:holder:_NTOP(_1) }
   Message _ROWPOS    ACTION { |O,_1| O:holder:_ROWPOS(_1) }
   Message _SKIPBLOCK ACTION { |O,_1| O:holder:_SKIPBLOCK(_1) }
   Message _STABLE    ACTION { |O,_1| O:holder:_STABLE(_1) }
   
   Message InitDb(t, l, b, r)
   Message InitNew(t, l, b, r)
   Message Stabilize()
   Message AddColumn( oColumn )
   Message goBottomSet( cBlock,bBlock )
   Message goTopSet( cBlock,bBlock )
   Message skipSet( cBlock,bBlock )
   Message sizeLeft()
   Message sizeRight()
   Message sizeUp()
   Message sizeDown()
   Message alternate()
   Message moveUp()
   Message moveDown()
   Message moveRight()
   Message moveLeft()

   Message MoveColLeft( nCol )
   Message MoveColRight( nCol )
   Message Configure()
   Message SetColours()     Method SetupColours()

   Message SetKey() Method KeySet( nElement,nValue )

#IFDEF RUNTIME
   Message AddAction( x )
   Message InsAction( x,npos )
   Message GetAction( nPos )
   Message SetAction( nPos,x )
   Message DelAction( nPos )
#ENDIF

   Message SaveBack() ACTION {|Self|::BackScreen := SaveScreen(0,0,MAXROW(),MAXCOL())} 
   Message RestBack() ACTION {|Self|RestScreen(0,0,MAXROW(),MAXCOL(),::BackScreen),;
                                   ::ReDrawFrame := ::ReDoActions := .T.}
#IFNDEF RUNTIME
   Message Cut()            // not in runtime
   Message Copy()           // not in runtime
   Message Paste( insert )  // not in runtime
   Message SaveSet()        // not in runtime
   Message RestSet( a9 )    // not in runtime
#ENDIF

End Class


method InitDB( t, l, b, r )
   Local aColor
   ::holder := tbrowseDB(::eTop:=t,::eLeft:=l,::eBottom:=b,::eRight:=r)
   ::cGoTop:= "dbGoTop()"
   ::cGoBottom:= "dbGoBottom()"
   ::cSkip:= "{|n| myskipper(n)}"

   ::KeyMap := { K_UP,K_DOWN,K_LEFT,K_RIGHT,;
                 K_HOME,K_END,K_PGUP,K_PGDN,;
                 K_CTRL_LEFT,K_CTRL_RIGHT,;
                 K_CTRL_PGUP,K_CTRL_PGDN,;
                 K_CTRL_HOME,K_CTRL_END,;
                 K_ESC,K_RETURN}

   aColor := AsArray( SetColor() )
   ::ColorSpec := aColor[1]+','+aColor[1]+','+aColor[2]
   ::Border := Space(12)
   ::ReDrawFrame := .T.
   ::ReDoActions := .T.
   ::Actions := {}
   ::Blink := SETBLINK()

return( self )

method InitNew( t, l, b, r )
   ::holder := tbrowseNew(::eTop:=t,::eLeft:=l,::eBottom:=b,::eRight:=r)
   ::Blink := SETBLINK()
return( self )

Method Stabilize()
   Local retVal := .T.
   Local cColor := AsArray( ::ColorSpec )[1]
   Local nTopOff,nBottOff
   Local cBorder := ::Border
   If ::ColCount() > 0
      DISPBEGIN()
      If ::ReDrawFrame .and. Len(Trim(Left(cBorder,8))) > 0
         @ IF( EMPTY(Left( cBorder,3 )),::nTop,::nTop-1),;
           IF( EMPTY(Left( cBorder,1 )+Substr( cBorder,7,2 )),::nLeft,::nLeft-1),;
           IF( EMPTY(SubStr( cBorder,5,3 )),::nBottom,::nBottom+1),;
           IF( EMPTY(SubStr( cBorder,3,3)),::nRight,::nRight+1) ;
           Box Left(cBorder,8) COLOR cColor
         ::ReDrawFrame := .F.

      Endif
      If ( retVal := ::Holder:Stabilize() ) .and. ::ReDoActions
         nTopOff := ROW() - ::RowPos
         nBottOff := ROW() + (::RowCount - ::RowPos)+1
         If !( EMPTY( Left( cBorder,1)) .and. EMPTY( Substr( cBorder,7,2 )))
            @ nTopOff,::nLeft-1 Say Trim(Substr( cBorder,9,1 )) COLOR cColor
            @ nBottOff,::nLeft-1 Say Trim(Substr( cBorder,11,1 )) COLOR cColor
         Endif
         If !EMPTY( Substr( cBorder,3,3 ))
            @ nTopOff,::nRight+1 Say Trim(Substr( cBorder,10,1 )) COLOR cColor
            @ nBottOff,::nRight+1 Say Trim(Substr( cBorder,12,1 )) COLOR cColor
         Endif
#IFDEF RUNTIME
         AEVAL( ::Actions,{|x|EVAL(x,Self)} )
#ENDIF
         ::ReDoActions := .F.
      Endif
      DISPEND()
   Else
      If ::ReDrawFrame
         @ IF( EMPTY(Left( cBorder,3 )),::nTop,::nTop-1),;
           IF( EMPTY(Left( cBorder,1 )+Substr( cBorder,7,2 )),::nLeft,::nLeft-1),;
           IF( EMPTY(SubStr( cBorder,5,3 )),::nBottom,::nBottom+1),;
           IF( EMPTY(SubStr( cBorder,3,3)),::nRight,::nRight+1) ;
           Box Left(cBorder,8) COLOR cColor
         ::ReDrawFrame := .F.
      Endif
   Endif
Return retVal

Method AddColumn( oColumn )
	local keep := .f.
   If !oColumn == NIL
      ::Holder:AddColumn( oColumn )
      keep := .t.
   Endif
Return keep

method goBottomSet( cBlock,bBlock )
   If bBlock = NIL
      ::goBottomBlock := ctob( cBlock )
   Else
      ::goBottomBlock := bBlock
   Endif
   ::cGoBottom := cBlock
return( NIL )

method goTopSet( cBlock,bBlock )
   If bBlock = NIL
      ::goTopBlock := ctob( cBlock )
   Else
      ::goTopBlock := bBlock
   Endif
	::cGoTop := cBlock
return( NIL )

method skipSet( cBlock,bBlock )
   If bBlock = NIL
      ::skipBlock := ctob( cBlock )
   Else
      ::skipBlock := ctob( cBlock )
   Endif
	::cSkip := cBlock
return( NIL )

method sizeLeft()
   if ::nRight > ::nleft
      ::nRight --
      ::RestBack()
   endif
return( self )

method sizeRight()
   if ::nRight+IF( EMPTY( Substr( ::Border,3,3)),0,1) < maxCol()
      ::nRight ++
      ::RestBack()
   endif
return( self )

method sizeUp()
   if ::nBottom > ::nTop
      ::nBottom --
      ::RestBack()
   endif
return( self )

method sizeDown()
   if ::nBottom+IF( EMPTY( Substr( ::Border,5,3)),0,1) < maxRow()
      ::nBottom ++
      ::RestBack()
   endif
return( self )

method alternate()
   local top, left, bottom, right

   top   := ::nTop
   left  := ::nLeft
   bottom:= ::nBottom
   right := ::nRight

   ::nTop   := ::eTop
   ::nLeft  := ::eLeft
   ::nBottom:= ::eBottom
   ::nRight := ::eRight

   ::eTop   :=  top
   ::eLeft  :=  left
   ::eBottom:=  bottom
   ::eRight :=  right

   ::configure()
   ::reFreshAll()
   ::RestBack()

return( self )

method MoveUp()
	if ::nTop-IF( EMPTY(Left( ::Border,3)),0,1) > 0
      ::nTop --
      ::nBottom --
      ::RestBack()
   endif
return( self )

method moveDown()
	if ::nBottom+IF( EMPTY( Substr( ::Border,5,3)),0,1) < maxRow()
      ::nBottom ++
      ::nTop ++
      ::RestBack()
   endif
return( self )

method moveRight()
	if ::nRight+IF( EMPTY( Substr( ::Border,3,3)),0,1) < maxCol()
      ::nRight ++
      ::nLeft ++
      ::RestBack()
   endif
return( self )

method moveLeft()
	if ::nLeft-IF(EMPTY( Left(::Border,1)+Substr(::Border,7,2)),0,1) > 0
      :: nLeft --
      ::nRight --
      ::RestBack()
   endif
return( self )

method Configure()
   local i,nFreeze,lFreeze:= .F.
   SETBLINK( ::Blink )
   If VALTYPE( ::Holder[9] ) = 'N'
      nFreeze := ::Holder[9]
      lFreeze := .T.
   Endif

   If ::GoBottomBlock = NIL
      ::goBottomBlock := ctob( ::cGoBottom )
   Endif
   If ::GoTopBlock = NIL
      ::goTopBlock := ctob( ::cGoTop )
   Endif
   If ::SkipBlock = NIL
      ::skipBlock := ctob( ::cSkip )
   Endif
   for i := 1 to ::colCount
      ::getcolumn( i ):Configure()
   next i
   ::refreshAll()
   ::RestBack()
   ::Holder:Configure()
   If lFreeze
      ::Freeze := nFreeze
   Endif
return( self )


#IFNDEF RUNTIME

Method Cut()            // not in runtime
   if ::ColCount > 0
      ::copy()
      ::delColumn(::colPos)
      ::RestBack()
   endif
return( ClipBoard )

Method Copy()           // not in runtime
   if ::ColCount > 0
      ClipBoard := ::GetColumn( ::ColPos )
   else
      ClipBoard := nil
   endif
return( ClipBoard )

Method Paste( insert ) // not in runtime
   local nCurrent := ::colPos
   default insert to .f.
   if ClipBoard != nil
      ::RestBack()
      if insert
         // the goes before
         ::insColumn( nCurrent , oClone(ClipBoard) )
      else
         // it goes after
         if nCurrent  == ::colCount .or. ::colCount = 0
            ::addColumn( oclone(ClipBoard) )
            ::Right()
         else
            ::insColumn( nCurrent+1, oClone(ClipBoard) )
            ::Right()
         endif
      endif
   endif
return( ClipBoard )

Method SaveSet()
   Local aSet := {::Holder[9],::BackScreen} 
   ::Holder[9] := ::Freeze
   ::BackScreen := NIL
Return aSet

Method RestSet( aSet )
   ::Holder[9] := aSet[1]
   ::BackScreen := aSet[2]
Return NIL


#ENDIF

Method KeySet( nElement,nValue )
   Local nCurrent
   If nElement > 16 .or. nElement < 1
      // Error
   Else
      nCurrent := ::KeyMap[ nElement ]
      If !nValue == NIL
         If !VALTYPE( nValue )='N'
            // Error
         Else
            ::KeyMap[ nElement ] := nValue
         Endif
      Endif
   Endif
Return nCurrent

Method SetUpColours()
   Local i:=1,cColor1,cColor2,oColumn,aColors,nColor
   aColors := AsArray(::ColorSpec)
   ::ColorSpec := aColors[1]+','+aColors[2]+','+aColors[3]
   aColors := AsArray(::ColorSpec)
   For i = 1 To ::ColCount
      oColumn := ::GetColumn( i )
      cColor1 := AsArray( oColumn:cColor )[1]
      cColor2 := AsArray( oColumn:cColor )[2]
      If (nColor := ASCAN( aColors,cColor1,2 )) = 0
         ::ColorSpec += ','+cColor1
         AADD( aColors,cColor1 )
         oColumn:DefColor[1] := Len(aColors)
      Else
         oColumn:DefColor[1] := nColor
      Endif

      If (nColor := ASCAN( aColors,cColor2,2 )) = 0
         ::ColorSpec += ','+cColor2
         AADD( aColors,cColor2 )
         oColumn:DefColor[2] := Len(aColors)
      Else
         oColumn:DefColor[2] := nColor
      Endif

      ::SetColumn( i,oColumn )
   Next i
   ::RefreshAll()
Return NIL

Method MoveColLeft( nCol )
   Local oColumn := ::GetColumn( IF(nCol=NIL,::ColPos,nCol) )
   nCol := IF( nCol=NIL,::ColPos,nCol )
   If nCol > 1
      ::DelColumn( nCol )
      ::InsColumn( nCol-1, oColumn )
      ::Refreshall()
   Endif
Return NIL

Method MoveColRight( nCol )
   Local oColumn := ::GetColumn( IF(nCol=NIL,::ColPos,nCol) )
   nCol := IF( nCol=NIL,::ColPos,nCol )
   If nCol < ::ColCount
      ::DelColumn( nCol )
      ::InsColumn( nCol+1, oColumn )
      ::Refreshall()
   Endif
Return NIL

#IFDEF RUNTIME
Method AddAction( x )
   If VALTYPE( x ) = 'B'
      AADD( ::Actions,x )
   Endif
Return NIL

Method InsAction( x,npos )
   If VALTYPE( x ) = 'B'
      If nPos > 0 .and. nPos <= Len( ::Actions )
         AINS( ::Actions,nPos )
         ::Actions[nPos] := x
      Else
         AADD( ::Actions,x )
      Endif
   Endif
Return NIL

Method GetAction( nPos )
   Local bAction
   If nPos > 0 .and. nPos <= Len( ::Actions )
      bAction := ::Actions[nPos]
   Endif
Return bAction

Method SetAction( nPos,x )
   Local bAction
   If VALTYPE( x ) = 'B'
      If nPos > 0 .and. nPos <= Len( ::Actions )
         bAction := ::Actions[nPos]
         ::Actions[nPos] := x
      Endif
   Endif
Return bAction

Method DelAction( nPos )
   Local bAction
   If nPos > 0 .and. nPos <= Len( ::Actions )
      bAction := ::Actions[nPos]
      ADEL(::Actions,nPos)
      ASIZE( ::Actions,Len(::Actions)-1)
   Endif
Return bAction
#ENDIF

Function ClipBoard
Return ClipBoard

