#include 'inkey.ch'
#include 'oops.ch'
#include 'mouseven.ch'

#translate self:Next() => BarMenNext( Self )
#translate self:Previous() => Previous( Self )

Static InMenu := .F.

Function MenuBarNew()
   Local oBarMenu := BarMenu():Init()
Return oBarMenu

Class BarMenu
   Var Top,Left,Bottom,Right
   Var Prompts
   Var Current
   Var Color
   Var Active
   Message Init()
   Message Display()
   Message AddPrompt( oPrompt )
   Message Key( nKey,nExtras )
   Message Next() Method BarMenNext()
   Message Previous()
   Message Hit( nRow,nCol ) ACTION {|self,nRow,nCol| nRow = ::Top .and. nCol >= ::Left .and. nCol <= ::Right } 
End Class

Method Init()
   ::Top := ::Bottom := 0
   ::Left := 0
   ::Right := 79
   ::Prompts := {}
   ::Color := 'N/W'
   ::Current := 1
   ::Active := .F.
Return Self

Method AddPrompt( oPrompt )
   oPrompt:Menu := Self
   oPrompt:Top := oPrompt:Bottom := ::Top
   oPrompt:Right := oPrompt:Left+Len( oPrompt:Prompt )-1
   AADD( ::Prompts,oPrompt )
Return NIL

Method Display()
   @ ::Top,::Left,::Bottom,::Right Box Space(9) Color ::Color
   AEVAL( ::Prompts,{|x| x:Display()} )
Return NIL

Method BarMenNext()
   ::Prompts[ ::Current ]:Display()
   ::Prompts[ ::Current ]:SubMenu:Vanish()
   ::Current ++
   If ::Current > Len( ::Prompts )
      ::Current := 1
   Endif
   ::Prompts[ ::Current ]:SubMenu:Display()
   If ::Prompts[ ::Current ]:SubMenu:Current = 0
      ::Prompts[ ::Current ]:SubMenu:First()
   Else
      ::Prompts[ ::Current ]:SubMenu:Prompts[::Prompts[ ::Current ]:SubMenu:Current]:Hilite()
   Endif
   ::Prompts[ ::Current ]:Hilite()
   SetTopObject( ::Prompts[ ::Current ]:SubMenu )
Return NIL

Method Previous()
   ::Prompts[ ::Current ]:Display()
   ::Prompts[ ::Current ]:SubMenu:Vanish()
   ::Current --
   If ::Current = 0
      ::Current := Len( ::Prompts )
   Endif
   ::Prompts[ ::Current ]:SubMenu:Display()
   If ::Prompts[ ::Current ]:SubMenu:Current = 0
      ::Prompts[ ::Current ]:SubMenu:First()
   Else
      ::Prompts[ ::Current ]:SubMenu:Prompts[::Prompts[ ::Current ]:SubMenu:Current]:Hilite()
   Endif
   ::Prompts[ ::Current ]:Hilite()
   SetTopObject( ::Prompts[ ::Current ]:SubMenu )
Return NIL

Method Key( nKey,nExtras )
   Local i,nPrompt,rBlock
   Do Case
   Case !::Active
      If nExtras = ALT .and. ( nPrompt := ASCAN( ::Prompts,{|x| IF( x:IsPrompt(),AltKey(x:Key) == nKey,.F.) } ) ) > 0
         ::Active := .T.
         ::Prompts[ nPrompt ]:HiLite()
         ::Prompts[ nPrompt ]:SubMenu:Display()
         If ::Prompts[ nPrompt ]:SubMenu:Current = 0
            ::Prompts[ nPrompt ]:SubMenu:First()
         Else
            ::Prompts[ nPrompt ]:SubMenu:Prompts[::Prompts[ nPrompt ]:SubMenu:Current]:Hilite()
         Endif
         SetTopObject( ::Prompts[ nPrompt ]:SubMenu )
         SetRetry()
         ::Current := nPrompt
         InMenu := .T.
      Endif
   Case nKey = K_ESC .and. nExtras = 0
      ::Prompts[ ::Current ]:Display()
      ::Prompts[ ::Current ]:SubMenu:Vanish()
      ::Active := .F.
      PullTopObject()
      InMenu := .F.
   Case nKey = K_LEFT .and. nExtras = 0
      ::Previous()
   Case nKey = K_RIGHT .and. nExtras = 0
      ::Next()
   EndCase
Return NIL

Function InMenu( lSet )
   If !lSet == NIL
      InMenu := lSet
   Endif
Return InMenu


