/* Screen Blanker 4.3 Installation */
'@Echo Off'
Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs
Signal On Failure Name FAILURE
Signal On Halt Name HALT
Signal On Syntax Name SYNTAX
Call SysCls
Say 'Installing Screen Blanker Version 4.3 and Clipchar 1.0...'
Say ''
Result = SysFileTree( 'BLANKER.EXE', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: BLANKER.EXE not found! Installation cancelled.'
  Signal DONE
  End
Result = SysFileTree( 'CLIPCHAR.EXE', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: BLANKER.EXE not found! Installation cancelled.'
  Signal DONE
  End
Result = SysFileTree( 'DPMS.EXE', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: DPMS.EXE not found! Installation cancelled.'
  Signal DONE
  End
Result = SysFileTree( 'CLIPCHAR.DOC', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: BLANKER.EXE not found! Installation cancelled.'
  Signal DONE
  End
Result = SysFileTree( 'BLANKER.HLP', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: BLANKER.HLP not found! Installation cancelled.'
  Signal DONE
  End
Result = SysFileTree( 'BLANKER.DLL', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: BLANKER.DLL not found! Installation cancelled.'
  Signal DONE
  End
Result = SysFileTree( 'BLANKER.INI', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: BLANKER.INI not found! Installation cancelled.'
  Signal DONE
  End
Result = SysFileTree( 'PRINTQ.DLL', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: PRINTQ.DLL not found! Installation cancelled.'
  Signal DONE
  End
Result = SysFileTree( 'BLANKER.BMP', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: BLANKER.BMP not found! Installation cancelled.'
  Signal DONE
  End
Result = SysFileTree( 'BLANKER.DOC', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: BLANKER.DOC not found! Installation cancelled.'
  Signal DONE
  End
Result = SysFileTree( 'FORTUNES.DAT', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: FORTUNES.DAT not found! Installation cancelled.'
  Signal DONE
  End
Result = SysFileTree( 'BOUNCE.BSS', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: BOUNCE.BSS not found! Installation cancelled.'
  Signal DONE
  End
Result = SysFileTree( 'LICENSE.TXT', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: LICENSE.TXT not found! Installation cancelled.'
  Signal DONE
  End
Result = SysFileTree( 'EMX.DLL', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: EMX.DLL not found! Installation cancelled.'
  Signal DONE
  End
Result = SysFileTree( 'EMXIO.DLL', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: EMXIO.DLL not found! Installation cancelled.'
  Signal DONE
  End
Result = SysFileTree( 'EMXLIBC.DLL', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: EMXLIBC.DLL not found! Installation cancelled.'
  Signal DONE
  End
Result = SysFileTree( 'EMXWRAP.DLL', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: EMXWRAP.DLL not found! Installation cancelled.'
  Signal DONE
  End
Say 'Please enter the full name of the directory to which'
Say 'you want Screen Blanker installed (default C:\OS2\APPS): '
Pull Directory
If Directory = "" Then Directory = 'C:\OS2\APPS'
Result = SysFileTree( Directory, 'Dirs', 'D' )
If Dirs.0 = 0 Then
  Do
  Result = SysMkDir( Directory )
  if Result == 0 Then
    Do
    End
  Else
    Do
    Say 'ERROR: Unable to create target directory. Installation cancelled.'
    Signal DONE
    End
  End
Say ''
Say 'Do you wish to install the program object in the startup folder? (Y/N)'
Pull YesNo
If YesNo = "Y" Then
  Do
  Folder = '<WP_START>'
  Say 'Object will be placed in the startup folder.'
  End
Else
  Do
  Folder = '<WP_DESKTOP>'
  Say 'Object will be placed on the desktop.'
  End
Say ''
Say 'Copying BLANKER.EXE to' Directory '...'
Copy BLANKER.EXE Directory                  '1>NUL'
Say 'Copying CLIPCHAR.EXE to' Directory '...'
Copy CLIPCHAR.EXE Directory                 '1>NUL'
Say 'Copying DPMS.EXE to' Directory '...'
Copy DPMS.EXE Directory                 '1>NUL'
Say 'Copying CLIPCHAR.DOC to' Directory '...'
Copy CLIPCHAR.DOC Directory                 '1>NUL'
Say 'Copying BLANKER.HLP to' Directory '...'
Copy BLANKER.HLP Directory                  '1>NUL'
Say 'Copying BLANKER.DLL to' Directory '...'
Copy BLANKER.DLL Directory                  '1>NUL'
Say 'Copying BLANKER.INI to' Directory '...'
Copy BLANKER.INI Directory                  '1>NUL'
Say 'Copying PRINTQ.DLL to' Directory '...'
Copy PRINTQ.DLL Directory                   '1>NUL'
Say 'Copying BLANKER.BMP to' Directory '...'
Copy BLANKER.BMP Directory                  '1>NUL'
Say 'Copying BLANKER.DOC to' Directory '...'
Copy BLANKER.DOC Directory                  '1>NUL'
Say 'Copying FORTUNES.DAT to' Directory '...'
Copy FORTUNES.DAT Directory                 '1>NUL'
Say 'Copying BOUNCE.BSS to' Directory '...'
Copy BOUNCE.BSS Directory                   '1>NUL'
Say 'Copying LICENSE.TXT to' Directory '...'
Copy LICENSE.TXT Directory                  '1>NUL'
Say 'Copying Deskpic screen saver modules to' Directory '...'
Copy '*.DSS' Directory                      '1>NUL'
Say 'Copying Screen Saver modules to' Directory '...'
Copy '*.SSM' Directory                      '1>NUL'
Say 'Copying dynamic link libraries to' Directory '...'
Copy 'EMX*.DLL' Directory                   '1>NUL'
Say ''
Say 'Creating program objects...'
Say ''
Type = 'WPProgram'
Title = 'Screen Blanker'
Parms = 'MINWIN=DESKTOP;PROGTYPE=PM;EXENAME='Directory'\BLANKER.EXE;PARAMETERS=-;STARTUPDIR='Directory';OBJECTID=<BLANKER>;NOPRINT=YES;'
Result = SysCreateObject( Type, Title, Folder, Parms, 'ReplaceIfExists' )
If Result = 1 Then
  Type = 'WPProgram'
  Title = 'Clipchar'
  Parms = 'MINWIN=DESKTOP;PROGTYPE=PM;EXENAME='Directory'\CLIPCHAR.EXE;STARTUPDIR='Directory';OBJECTID=<CLIPCHAR>;NOPRINT=YES;'
  Folder = '<WP_DESKTOP>'
  Result = SysCreateObject( Type, Title, Folder, Parms, 'ReplaceIfExists' )
  If Result = 1 Then
    Say 'Screen Blanker and Clipchar were installed.'
    Say 'Make sure that' Directory 'is included in'
    Say 'the LIBPATH and PATH statement in your CONFIG.SYS file.'
    E BLANKER.DOC '1>NUL'
  Exit
  Else
    Say 'ERROR: Unable to create object. Installation cancelled.'
  Exit

FAILURE:
Say 'Installation error.'
Signal DONE
HALT:
Say 'Installation error.'
Signal DONE
SYNTAX:
Say 'Installation error.'
Signal DONE
DONE:
Exit
