#include <stdio.h>
#include <string.h>

#include "..\h\apt_func.h"
#include "..\h\numstr.h"

void main(int argc,char **argv)
{
	char lname[17],nossname[17];
	
	if (argc!=3)
	{
		apt_print_err(DOS_USAGE);
		printf("Usage: SETNAME localname nossname\n");
		printf("       localname may be * to indicate that default local name is to be used.\n");
		apt_exit(DOS_USAGE);
	}
	_a_strcpy((char far *)lname,(char far *)argv[1]);
	_a_strcpy((char far *)nossname,(char far *)argv[2]);
	if(_a_strcmp((char far *)lname,(char far *)"*")==0)		/* if '*' specified */
	{
		apt_status=apt_setname((char far *)NULL,(char far *)nossname);
	}
	else
	{
		apt_status=apt_setname((char far *)lname,(char far *)nossname);
	}	
	if(apt_status==0)
	{
		apt_print_err(apt_status);
		printf("Local name is '%s'.\n",lname);
		apt_exit(0);
	}
	/* error */
	apt_print_err(apt_status);
	apt_exit(apt_status);
}

/* revision history:
12-1-90:  Changed to take '*' as localname, meaning that the default netbios
          local name already exist in the name table should be used.
          To do this, the nbgetlname() function has been changed so that if
          the given buffer contains "ANYNAME", then no checking is done to
          filter out localnames (else localname must be ending with "LX".)
*/
