/* touch.c -- Update the time stamp of files
   Copyright (c) 1994 by Eberhard Mattes

This file is part of emx.

emx is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

emx is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with emx; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */


#include <sys/types.h>
#include <sys/utime.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <io.h>
#include <fcntl.h>

#define FALSE 0
#define TRUE  1

static void usage (void)
{
  puts ("Usage: touch [-c] <files>");
  exit (1);
}


int main (int argc, char *argv[])
{
  int i, h, rc;
  int opt_c;
  char *s;

  _response (&argc, &argv);
  _wildcard (&argc, &argv);
  if (argc < 2)
    usage ();
  opt_c = 0;
  i = 1;
  if (strcmp (argv[i], "-c") == 0)
    {
      opt_c = TRUE;
      ++i;
    }
  rc = 0;
  if (i >= argc)
    usage ();
  while (i < argc)
    {
      s = argv[i];
      if (utime (s, NULL) != 0 && !opt_c)
        {
          h = open (s, O_CREAT|O_EXCL|O_WRONLY|O_BINARY, S_IREAD|S_IWRITE);
          if (h < 0)
            {
              fprintf (stderr, "touch: cannot access '%s'\n", s);
              rc = 1;
            }
          else
            (void)close (h);
        }
      ++i;
    }
  return (rc);
}
