/* vinit.c (emx+gcc) -- Copyright (c) 1987-1994 by Eberhard Mattes */

#include <stdlib.h>
#include <sys/video.h>
#include "video2.h"
#include "video3.h"
#if defined (__EMX__)
#include <sys/hw.h>
#include <os2thunk.h>
#else
extern void _scrsize (int *dst);
#endif

int _v_width = 0;
int _v_height = 0;
int _v_x = 0;
int _v_y = 0;
int _v_attr = 0x07;
char *_v_mem = NULL;

static void _v_getxy (int *x, int *y)
{
#if defined (IF_OS2)
  IF_OS2
    {
      USHORT row, col;

      VioGetCurPos (&row, &col, 0);
      *x = col; *y = row;
    }
#endif
#if defined (IF_DOS)
  IF_DOS
    {
      union REGS r;

      r.h.ah = 0x03;
      r.h.bh = 0x00;
      _int86 (0x10, &r, &r);
      *x = r.h.dl; *y = r.h.dh;
    }
#endif
}


int v_init (void)
{
  int two[2];

  _scrsize (two);
  _v_width = two[0];
  _v_height = two[1];
  _v_getxy (&_v_x, &_v_y);
  _v_mem = NULL;
#if defined (IF_OS2)
  IF_OS2
    {
      _far16ptr addr;
      USHORT len;

      len = (USHORT)(_v_width * _v_height * 2);
      if (VioGetBuf ((PULONG)&addr, &len, 0) == 0)
#if defined (__EMX__)
        _v_mem = MAKEP (SELECTOROF (addr), OFFSETOF (addr));
#else
        _v_mem = addr;
#endif
    }
#endif
#if defined (IF_DOS)
  IF_DOS
    {
      unsigned addr, end_addr;
      union REGS r;

      r.h.ah = 0x0f;
      _int86 (0x10, &r, &r);
      if (r.h.al == 7 || r.h.al < 4)
        {
          _int86 (0x11, &r, &r);
          if ((r.h.al & 0x30) == 0x30)
            addr = 0xb0000;
          else
            addr = 0xb8000;
          end_addr = (addr + _v_height * _v_width * 2 - 1) | 0xfff;
          _v_mem = _memaccess (addr, end_addr, 1);
        }
    }
#endif
  return (1);
}
