/* tzset.c (emx+gcc) -- Copyright (c) 1992-1993 by Kai Uwe Rommel */

#include <stdlib.h>
#include <string.h>
#include <time.h>

int daylight;
long timezone;
char *tzname[2];

int _tzset_flag = 0;

void tzset (void)
{
  static char buffer[32];     /* for all threads */
  char *tz, *end;

  tz = getenv ("EMXTZ");
  if (tz == NULL)
    tz = getenv ("TZ");
  if (tz == NULL || strlen (tz) >= sizeof (buffer))
    tz = "GMT0";
  strcpy (buffer, tz);
  timezone = strtol (buffer + 3, &end, 10) * 60 * 60;
#if 0
  daylight = ((end != NULL) && (*end != 0) && (strlen (end) >= 3));
#else
  daylight = 0;
#endif
  buffer[3] = 0;
  tzname[0] = buffer;
  tzname[1] = (daylight ? end : "");
  _tzset_flag = 1;
}
