/ hypot.s (emx+gcc) -- Copyright (c) 1992-1994 by Eberhard Mattes

/ As the arguments are double and the computation is done in extended
/ format, an iterative method is not required to avoid overflow.
/ However, such an algorithm should perhaps be used for _hypotl().

#include <libm.h>

        .globl  FUN(hypot)

        .text

        .align  2, 0x90

/ double hypot (double x, double y)

#define x        4(%esp)
#if defined (LONG_DOUBLE)
#define y       16(%esp)
#else
#define y       12(%esp)
#endif

DEF(hypot)
        FLD     x                       /* x */
        fld     %st                     /* x, x */
        fmulp                           /* x*x */
        FLD     y                       /* y, x*x */
        fld     %st                     /* y, y, x*x */
        fmulp                           /* y*y, x*x */
        faddp                           /* y*y + x*x */
        fsqrt                           /* hypot (x, y) */
        CONV(x)                         /* convert to double */
        _xam
        j_inf   1f
        ret

        .align  2, 0x90
1:      SETERRNO($ERANGE)
        ret
