/* graph2.h (emx+gcc) */

extern int _g_xsize;
extern int _g_ysize;
extern int _g_colors;
extern int _g_pages;

extern int _g_clipx0;
extern int _g_clipy0;
extern int _g_clipx1;
extern int _g_clipy1;

extern int _g_locklevel;

extern unsigned char *_g_mem;

int _ggetmode (void);
void _gsetmode (int mode);

int _gline_clip (int x1, int y1, int *x2p, int *y2p);


#define GLOCK \
  do \
    if (_osmode == OS2_MODE && _g_locklevel == 0) \
      { \
        BYTE not_locked; \
        VioScrLock (LOCKIO_WAIT, &not_locked, 0); \
      } \
    while (0)

#define GUNLOCK \
  do \
    if (_osmode == OS2_MODE && _g_locklevel == 0) \
      VioScrUnLock (0); \
    while (0)


#define GJ_VGL          1
#define GJ_EGA          2

/* A primitive table entry consists of 3 words:

   o  the mode number (zero means default)
   o  the address of the variable holding the function address
   o  the address of the function implementing the primitive for the
      mode.

   The table must reside in the .text section as we use N_SETT|N_EXT
   (23) to reference it.  Note that emxomf does not support N_SETD!
   Therefore, the following macros should be used after a function
   definition. */

#define GPRIM_DEF(NAME)  GPRIM2 (NAME, 0, no)
#define GPRIM_VGL(NAME)  GPRIM2 (NAME, 1, vgl)
#define GPRIM_EGA(NAME)  GPRIM2 (NAME, 2, ega)

#define GPRIM_ALL(NAME)  GPRIM_VGL (NAME); GPRIM_EGA (NAME)

#define GPRIM2(NAME,NUMBER,PREFIX) \
  __asm__ ("Lj_" #PREFIX "_" #NAME ": " \
           ".int " #NUMBER ";" \
           ".int __j_" #NAME ";" \
           ".int __" #PREFIX "_" #NAME ";" \
           ".stabs \"__j_graph\", 23, 0, 0, Lj_" #PREFIX "_" #NAME)


/* Copied from os2emx.h */

#if !defined (NULLHANDLE)

typedef unsigned char BYTE;
typedef unsigned short USHORT;
typedef USHORT HVIO;

#define LOCKIO_WAIT 1

USHORT VioScrLock (USHORT fWait, BYTE *pfNotLocked, HVIO hvio);
USHORT VioScrUnLock (HVIO hvio);

#endif
