/* stdio.c (emx+gcc) -- Copyright (c) 1990-1994 by Eberhard Mattes */

#include <sys/emx.h>
#include <stdio.h>

/* This variable must be initialized as no extended dictionary entries
   are built for COMDEF. */

FILE _streamv[_NFILES] = {{0}};


/* The buffer for stdin. */

static char ibuf[BUFSIZ];


/* Initialize the streams -- this function will be called by
   _startup() via the __crtinit1__ set vector. */

void _init_streams (void)
{
  int i;

  for (i = 0; i < _nfiles; ++i)
    {
      _streamv[i].flags = 0;
      /* O_TEXT is set by init_files() for all valid handles. */
      if (_files[i] != 0)
        {
          _streamv[i].flags |= _IOOPEN;
          _streamv[i].ptr = NULL;
          _streamv[i].buffer = NULL;
          _streamv[i].rcount = 0;
          _streamv[i].wcount = 0;
          _streamv[i].handle = i;
          _streamv[i].buf_size = 0;
          _streamv[i].tmpidx = 0;
          _streamv[i].pid = 0;
          _streamv[i].flush = _flushstream;
          switch (i)
            {
            case 0:

              /* stdin is always buffered. */

              _streamv[0].flags |= _IOREAD | _IOFBF | _IOBUFUSER;
              _streamv[0].ptr = ibuf;
              _streamv[0].buffer = ibuf;
              _streamv[0].buf_size = BUFSIZ;
              break;

            case 1:

              /* stdout is buffered unless it's connected to a
                 device. */

              _streamv[i].flags |= (_IOWRT | _IOBUFNONE |
                                    ((_files[i] & F_DEV) ? _IONBF : _IOFBF));
              break;

            case 2:

              /* stderr is always unbuffered. */

              _streamv[i].flags |= _IOWRT | _IOBUFNONE | _IONBF;
              break;

            default:

              /* All other streams are buffered unless connected to a
                 device. */

              _streamv[i].flags |= (_IORW | _IOBUFNONE |
                                    ((_files[i] & F_DEV) ? _IONBF : _IOFBF));
              break;
            }
        }
    }
}


/* Shutdown the streams -- this function will be called by _cleanup()
   via the __crtexit1__ set vector. */

void _exit_streams (void)
{
  flushall ();
  _rmtmp ();
}

__asm__ (".stabs \"___crtinit1__\", 23, 0, 0, __init_streams");
__asm__ (".stabs \"___crtexit1__\", 23, 0, 0, __exit_streams");
