/***************************************************************************

	Query Builder Application:
	This program shows how to use the Q+E Query Builder.
	
	Q+E Software, Inc
	5540 Centerview Drive
	Suite 324
	Raleigh, NC  27606
		
	Tech Support : (919) 851-1152
	Fax          : (919) 859-9337
	BBS          : (919) 851-1381
	CompuServe   : GO QESOFT
		
***************************************************************************/

#include <windows.h>		/* required for all Windows applications */
#include "qry_bldr.h"		/* specific to this program */
#include "..\include\qelib.h"	/* function prototypes */

/* Global variables */

HANDLE	hInst = 0;		/* current instance */
HWND	hWnd = 0;		/* Main window handle. */
HMENU	hMenu = NULL;		/* Handle to menu */
HANDLE  hHourGlass = NULL;	/* Handle to hourglass cursor      */
HANDLE  hSaveCursor = NULL;	/* Current cursor handle      */
int	hdbc = 0;		/* Handle to a database connection */
int	hqry = 0;		/* Handle to a Query */
int	hstmt = 0;		/* Handle to a SQL Statement */
int	num_cols;		/* Number of columns returned by a query */
HWND	hWndStatic[MAX_FIELDS];	/* Handles to Static Text (column names) */
HWND	hWndEdit[MAX_FIELDS];	/* Handles to Edit Windows (column data) */
HWND	hWndButton[3];		/* Handles to Prev, Next, End Query buttons */

LPSTR	ButtonText[] = {"Previous", "Next", "End Query"};

int PASCAL WinMain(hInstance, hPrevInstance, lpCmdLine, nCmdShow)
HANDLE hInstance;		/* current instance */
HANDLE hPrevInstance;		/* previous instance */
LPSTR lpCmdLine;		/* command line */
int nCmdShow;			/* show-window type (open/icon) */
{
	MSG msg;			/* message */

	if (!hPrevInstance)		 /* Other instances of app running? */
	if (!InitApplication(hInstance)) /* Initialize shared things */
		return (FALSE);		 /* Exits if unable to initialize */

/* Perform initializations that apply to a specific instance */

	if (!InitInstance(hInstance, nCmdShow)) return (FALSE);

/* Acquire and dispatch messages until a WM_QUIT message is received. */

	while (GetMessage(&msg,	NULL, NULL, NULL)) {
		TranslateMessage(&msg);	/* Translates virtual codes */
		DispatchMessage(&msg);	/* Dispatches message */
	}
	return (msg.wParam);   /* Returns value from PostQuitMessage */
}


BOOL InitApplication(hInstance)
HANDLE hInstance;			       /* current instance */
{
	WNDCLASS  wc;

/* Fill in window class structure with parameters that describe the */
/* main window.	*/

	wc.style = NULL;		/* Class style(s). */
	wc.lpfnWndProc = MainWndProc;	/* Function to retrieve messages */
					/* for windows of this class. */
	wc.cbClsExtra = 0;		/* No per-class extra data. */
	wc.cbWndExtra = 0;		/* No per-window extra data. */
	wc.hInstance = hInstance;	/* Application that owns the class. */
	wc.hIcon = LoadIcon(hInstance, "ExampleIcon");
	wc.hCursor = LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground = GetStockObject(WHITE_BRUSH); 
	wc.lpszMenuName =  "QryMenu";/* Name of menu resource in RC file*/
	wc.lpszClassName = "QryWClass";/* Used in call to CreateWindow*/

/* Register the window class and return success/failure code. */

	return (RegisterClass(&wc));

}

BOOL InitInstance(hInstance, nCmdShow)
	HANDLE	hInstance;		/* Current instance identifier. */
	int	nCmdShow;		/* Param for first ShowWindow() call*/
{
	FARPROC lpProcDataDir;	        /* Pointer to the DataDir funtion */
	int	result;			/* Result from dialog procedure */

/* Save the instance handle in global variable, which will be used in */
/* many subsequence calls from this application to Windows. */

	hInst = hInstance;

/* Create a main window for this application instance. */

	hWnd = CreateWindow(
		"QryWClass",	/* See RegisterClass() call. */
		"Query Builder Example",/* Text for win title bar */
		WS_OVERLAPPEDWINDOW,	/* Window style */
		CW_USEDEFAULT,		/* Default horicontal pos. */
		CW_USEDEFAULT,		/* Default vertical position */
		CW_USEDEFAULT,		/* Default Width */
		CW_USEDEFAULT,		/* Default Height */
		NULL,			/* Overlapped windows have no parent*/
		NULL,			/* Use the window class menu. */
		hInstance,		/* This instance owns this window. */
		NULL			/* Pointer not needed. */
		);

/* If window could not be created, return "failure" */

	if (!hWnd) return (FALSE);

/* Get the menu & hourglass handles */
	
	hMenu = GetMenu(hWnd);
	hHourGlass = LoadCursor(NULL, IDC_WAIT);
	
/* Make the window visible; update its client area */

	ShowWindow(hWnd, nCmdShow | SW_SHOWMAXIMIZED);  /* Show the window */
	UpdateWindow(hWnd);          /* Sends WM_PAINT message */

	return (TRUE);	

}

long FAR PASCAL MainWndProc(hWnd, message, wParam, lParam)
HWND hWnd;				  /* window handle */
unsigned message;			  /* type of message */
WORD wParam;				  /* additional information */
LONG lParam;				  /* additional information */
{
	FARPROC		lpProcAbout;	/* pointer to the "About" function */
	int		result;		/* Result from dialog procedure */
	LPSTR		ptr;		/* Generic pointer to text */
	int		fatal = 0;	/* Flag for fatal errors */
	HDC		hDC;		/* Handle to device context */
	TEXTMETRIC	tm;		/* Text metric info */
	int		cxChar, cyChar;	/* Char width & height */
	int		i;		/* Generic loop counter */
	

	switch (message) {
	case WM_CREATE:
		
/* Initialize QELIB */
		
		result = qeLibInit();
		if (result != qeSUCCESS) goto fatal_err;
		
/* Connect to database */
		
		hdbc = qeConnect ("DSN=QEDBF");
		if (hdbc == 0) goto fatal_err;
		
/* Turn on random fetching.  This allows us to use qeFetchPrev. */
		
		qeSetSelectOptions (hdbc, qeFETCH_ANY_DIR);
			
/* Initialize a Query  (Note: the Query is BLANK now.  We'll fill it in later
   using the Query Builder) */
		
		hqry = qeQryAllocate (hdbc, "");
		if (hqry == 0) goto fatal_err;

/* Get text metric information */
		
		hDC = GetDC (hWnd);
		SelectObject (hDC, GetStockObject (SYSTEM_FIXED_FONT));
		GetTextMetrics (hDC, &tm);
		cxChar = tm.tmAveCharWidth;
		cyChar = tm.tmHeight + tm.tmExternalLeading;
		ReleaseDC (hWnd, hDC);
		
/* Create Static Text Windows (to hold column names) and Edit Windows (to hold
   column data). */
		
		for (i = 0; i < MAX_FIELDS; i++) {
			hWndStatic[i] = CreateWindow (
				"static", "",
				WS_CHILD,
				cxChar, cyChar * (1 + 2 * i),
				15 * cxChar, 7 * cyChar / 4,
				hWnd, i + 1, hInst, NULL);

			hWndEdit[i] = CreateWindow (
				"edit",	"", 
				WS_CHILD | WS_BORDER | ES_AUTOHSCROLL,
				17 * cxChar, cyChar * (1 + 2 * i),
				35 * cxChar, 7 * cyChar / 4,
				hWnd, MAX_FIELDS + i + 1, hInst, NULL);
		}

/* Create Previous, Next, & End Query buttons */

		for (i = 0; i < 3; i++) {
			hWndButton[i] = CreateWindow (
				"button", ButtonText[i],
				WS_CHILD | BS_PUSHBUTTON,
				55 * cxChar, cyChar * (1 + 2 * i),
				10 * cxChar, 7 * cyChar / 4,
				hWnd, 50 + i, hInst, NULL);
		}
		break;
		
	case WM_COMMAND:	   /* message: command from application menu*/
		switch (wParam) {
			
		case IDM_BUILD:

/* Call the Q+E Query Builder */
			
			result = qeQryBuilder (hqry, hWnd,
				qeQRY_TABLES | qeQRY_BIG_ICONS, 
				qeQRY_DEFAULT);
			if (result != qeSUCCESS) goto err;
			
/* Turn on the "Execute Query" menu choice */
		
			EnableMenuItem(hMenu, IDM_EXECUTE, MF_ENABLED);
			
/* Ask the user if he/she wants to execute the query. */
			
			if (MessageBox(hWnd, "Execute the Query now?",
				"Execute Query", MB_YESNO) == IDNO) break;
			
		case IDM_EXECUTE:
			
/* Change the cursor to the hourglass */
			
			hSaveCursor = SetCursor(hHourGlass);
			
/* Prepare the SQL statement */
			
			hstmt = qeQryPrepare (hqry);
			if (hstmt == 0) goto err;
			
/* Execute the SQL query */
			
			result = qeSQLExecute (hstmt);
			if (result != qeSUCCESS) goto err;
			
/* Get the number of columns */
			
			num_cols = qeNumCols (hstmt);
			
/* Check for > MAX_FIELDS.  Warn the user if > MAX_FIELDS. */
			
			if (num_cols > MAX_FIELDS) {
				num_cols = MAX_FIELDS;
				MessageBox(hWnd, 
					"This query contains more than 10 columns.  Only the first 10 will be displayed.", 
					NULL, MB_ICONINFORMATION | MB_OK);
			}
				

/* Get the column names and put them in the Static Text Windows */
			
			for (i = 0; i < num_cols; i++) {
				ptr = qeColName (hstmt, i+1);
				SetWindowText (hWndStatic[i], ptr);
			}
			
/* Unhide Static Text Windows (column names), Edit Windows (column data), 
   & buttons */
			
			for (i = 0; i < num_cols; i++) {
				ShowWindow (hWndStatic[i], SW_SHOWNORMAL);
				ShowWindow (hWndEdit[i], SW_SHOWNORMAL);
			}
			for (i = 0; i < 3; i++)
				ShowWindow (hWndButton[i], SW_SHOWNORMAL);

/* Turn off the "Build Query" & "Execute Query" menu choices */
/* Turn on the "End Query" menu choice */
		
			EnableMenuItem(hMenu, IDM_BUILD, MF_GRAYED);
			EnableMenuItem(hMenu, IDM_EXECUTE, MF_GRAYED);
			EnableMenuItem(hMenu, IDM_END, MF_ENABLED);
			
/* Fetch the next record.  Break if no more records. */
	
			if (qeFetchNext(hstmt)) break;;
			
/* Fill the form with data from the database */
			
			if (FillForm()) goto err;

/* Set the cursor back to the arrow */
			
			SetCursor(hSaveCursor);
			hSaveCursor = 0;
			break;
			
		case BTN_END:
		case IDM_END:

/* End the SQL query */
			
			qeEndSQL (hstmt);
			
/* Hide Staic Text (column names), Edit Windows (column data), & buttons */
			
			for (i = 0; i < MAX_FIELDS; i++) {
				ShowWindow (hWndStatic[i], SW_HIDE);
				ShowWindow (hWndEdit[i], SW_HIDE);
			}
			for (i = 0; i < 3; i++) {
				ShowWindow (hWndButton[i], SW_HIDE);
			}
			
/* Turn on the "Build Query" & "Execute Query" menu choices */
/* Turn off the "End Query" menu choice */
			
			EnableMenuItem(hMenu, IDM_BUILD, MF_ENABLED);
			EnableMenuItem(hMenu, IDM_EXECUTE, MF_ENABLED);
			EnableMenuItem(hMenu, IDM_END, MF_GRAYED);
			break;
			
		case IDM_EXIT:
			DestroyWindow(hWnd);
			break;
		    
		case BTN_NEXT:
			
/* Fetch the next record.  Break if no more records */
	
			if (qeFetchNext(hstmt)) {
				MessageBox (hWnd, "No more records.", NULL,
					    MB_OK);
				break;
			}
			
/* Fill the form with data from the database */
			
			if (FillForm()) goto err;

			break;
			
		case BTN_PREVIOUS:
			
/* Fetch the previous record.  Break if no more records */
	
			if (qeFetchPrev(hstmt)) {
				MessageBox (hWnd, "No more records.", NULL,
					    MB_OK);
				break;
			}
			
/* Fill the form with data from the database */
			
			if (FillForm()) goto err;
			
			break;
			
		case IDM_ABOUT:
			
/* Display the about box */
			
			lpProcAbout = MakeProcInstance(About, hInst);
			DialogBox(hInst, "AboutBox", hWnd, lpProcAbout);
			FreeProcInstance(lpProcAbout);
			break;
			
		default:
			return (DefWindowProc(hWnd, message, wParam, lParam));
			
		}
		break;
			
	case WM_DESTROY:		  /* message: window being destroyed*/
		
/* Free Query */
		
		qeQryFree (hqry);
	
/* Disconnect from the database system (QEDBF) */
		
		qeDisconnect(hdbc);
		
/* Terminate QELIB Session */
		
		qeLibTerm ();
		
/* Post QUIT message */
		
		PostQuitMessage(0);
		break;

	default:			  /* Passes it on if unproccessed */
		return (DefWindowProc(hWnd, message, wParam, lParam));
	}
	return (NULL);
	
fatal_err:
	fatal = TRUE;
err:
	if (hSaveCursor) {
		SetCursor(hSaveCursor);
		hSaveCursor = 0;
	}
	ptr = qeErrMsg();
	MessageBox(hWnd, ptr, NULL, MB_ICONEXCLAMATION | MB_OK);
	if (fatal) DestroyWindow(hWnd);
	return (FALSE);
}

BOOL FAR PASCAL About(hDlg, message, wParam, lParam)
HWND hDlg;                                /* window handle of the dialog box*/
unsigned message;                         /* type of message */
WORD wParam;                              /* message-specific information */
LONG lParam;
{
	switch (message) {
	case WM_INITDIALOG:		   /* message: initialize dialog box*/
		return (TRUE);

	case WM_COMMAND:			/* received a command */
		if (wParam == IDOK		/* "OK" box selected? */
		|| wParam == IDCANCEL) {	/* System menu close command*/
			EndDialog(hDlg, TRUE);	/* Exits the dialog box */
			return (TRUE);
		}
		break;
	}
	return (FALSE);			      /* Didn't process a message */
}

int FAR PASCAL FillForm (VOID)
{
	int	i;	/* Generic loop counter */
	int	result;	/* Result of QELIB function */
	LPSTR	ptr;	/* Generic text pointer */
	
	
/* Get the values of each field (column) */
	
	for (i=0; i<num_cols; i++) {
		ptr = qeValChar(hstmt, i+1, "", 0);
		result = qeErr();
		if (result < -2 || result > 0) return (result); 
		SetWindowText (hWndEdit[i], ptr);
	}
	return (qeSUCCESS);
}