/*
 * 
 * 
 *      DM2Test.CSC - DeskMan/2 setup test object.
 * 
 *   Ŀ
 *     DM2Test object - setup string manipulation methods.                
 *                      Part of DeskMan/2.                                
 *                                                                        
 *     (C) Copyright 1993-1994 Development Technologies, Inc.             
 *         Portions Copyright 1993 Gregory Czaja                          
 *         All rights reserved                                            
 *         DeskMan, DeskMan/2, DM2Setup, VUEMan, VUEMan/2 and DM2Image    
 *         are trademarks of Development Technologies, Inc. (DevTech),    
 *         a Pennsylvania Corporation                                     
 *                                                                        
 *     version 1: initial release                          April 1994     
 *   
 */
include <wpabs.sc>

class: DM2Test,
       external stem   = DM2Test,
       local,
       external prefix = DM2TestX_,
       classprefix     = DM2TestC_,
       major version   = 1,
       minor version   = 1,
       file stem       = DM2Test;


parent: WPAbstract;


passthru: C.ph;
                                /* private defs for DM2Test - none */
endpassthru;

passthru: C.ih;
                                /* implementation defs for DM2Test */

   #define INCL_WIN
   #define INCL_DOS
   #include <os2.h>

   #define INCL_WPCLASS
   #include <pmwp.h>

   #include <DM2Setup.h>        /* DM2Setup methods     */
                                /* internal definitions */

   #define DM2TEST_CLASSNAME      "DM2Test"

endpassthru;

passthru: C.h, after;
endpassthru;

passthru: C.c, before
   #pragma checkout(suspend)
endpassthru;
passthru: C.c, after;
   #pragma checkout(resume)
endpassthru;

data:

CHAR  myData;

methods:

#/*====================================================================*/
#/*                                                                    */
#/* Add our universal private methods                                  */
#/*                                                                    */
#/*====================================================================*/

                   /* new DeskMan/2 setup interface */

APIRET DeskMan2QuerySetup(WPObject * setupObject);

#/*====================================================================*/
#/*                                                                    */
#/* Override object customization methods                              */
#/*                                                                    */
#/*====================================================================*/

    override wpSetup;

#/*====================================================================*/
#/*                                                                    */
#/* Override menu customization and selection methods                  */
#/*                                                                    */
#/*====================================================================*/
    override wpModifyPopupMenu;

    override wpMenuItemSelected;

    override wpAddObjectWindowPage;
#/*====================================================================*/
#/*                                                                    */
#/* Override class methods                                             */
#/*                                                                    */
#/*====================================================================*/
    override wpclsInitData, class;

    override wpclsUnInitData, class;

    override wpclsQueryIconData, class;

    override wpclsQueryTitle, class;
