/* REXX OS/2 - PerfSO.CMD  perform a Save object function           */
/*-Ŀ
                                                                    
  (C) Copyright 1993-1994 Development Technologies, Inc.            
      Portions Copyright 1993 Gregory Czaja                         
      All rights reserved                                           
      DeskMan, DeskMan/2, DM2Setup, VUEMan, VUEMan/2 and DM2Image   
      are trademarks of Development Technologies, Inc. (DevTech),   
      a Pennsylvania Corporation                                    
                                                                    
  version 1.51                                        April 1994    
*/
/*Ŀ
        Saves the object of the name-object located in the          
        FolderName-folder in the specified DRC file.                
        REXX generation and Save options depending on current       
        DeskMan/2 settings - can be set prior to PerformSave...     
                                                                    
        The folder and object names should be surrounded by "       
        if containing blanks.                                       
                                                                    
        The format is:                                              
        PerformSaveObject=x:\path\file.drc,name,FolderName;         
        PerformSaveObject=x:\path\file.drc,ALL,FolderName;          
                                                                    
        name can be:         . object title                         
                             . object ID                            
                             . fully qualified path                 
                             . ALL                                  
          note: if an object ID (i.e., a character string enclosed  
                in brackets <>) is used as the object name, the     
                object's location specified as FolderName will be   
                IGNORED! - but needs to be specified.               
          note: if ALL is specified, all object located in the      
                folder will be saved.                               
                Not allowed with ANYWHERE!                          
        FolderName can be:   . folder title                         
                             . object ID                            
                             . fully qualified path                 
                             . ANYWHERE                             
          note: if ANYWHERE is specified as the object's location,  
                the entire Desktop will be searched for the object  
                specified (top-down). First object found will be    
                used. Not allowed with ALL!                         
                                                                    
*/

/*ͻ
  Note: the use of other DeskMan/2 setup strings and use of the     
        PerformSaveSettings=YES;                                    
        to save the current (after the SysSetObjectData) DeskMan/2  
        settings! If PerformSaveSettings is not used, the settings  
        are changed but not saved, so the user's settings (prior    
        to SysSetObjectData) will be restored on the next system    
        boot.                                                       
*/

/* Execute as: PERFSO x:\deskman\test.drc Name Folder               */

Parse Arg args;
If Left(args,1) = '"'
   Then Parse Var args '"'DRCfile'"' args;
   Else Parse Var args    DRCfile    args;
args=Strip(args);
If Left(args,1) = '"'
   Then Parse Var args '"'object'"' args;
   Else Parse Var args    object    args;
args=Strip(args);
If Left(args,1) = '"'
   Then Parse Var args '"'folder'"' .;
   Else Parse Var args    folder    .;


If DRCfile = ''
   Then Do;
     Say 'DeskMan/2 PERFORM: the DRC file name is a required parameter.';
     Exit 99;
     End;
If object  = ''
   Then Do;
     Say 'DeskMan/2 PERFORM: the object name is a required parameter.';
     Exit 99;
     End;
If folder  = ''
   Then Do;
     Say 'DeskMan/2 PERFORM: the folder name is a required parameter.';
     Exit 99;
     End;


Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs';
Call SysLoadFuncs;

rc=SysSetObjectData('<DeskMan1>',,
                    'GENERATEREXX=NO;'||,
                    'PerformSaveObject='DRCfile','object','folder';'||,
                    'PerformSaveSettings=YES;');
If rc <> 1           
   Then Do;
     Say  "DeskMan/2 PERFORM: error performing Save object!";
     Exit 99;
     End;

Say 'DeskMan/2 PERFORM: Save object initiated successfully!';
Exit 0;                
