/* REXX OS/2 - PerfSh.CMD  perform a Create shadow function         */
/*-Ŀ
                                                                    
  (C) Copyright 1993-1994 Development Technologies, Inc.            
      Portions Copyright 1993 Gregory Czaja                         
      All rights reserved                                           
      DeskMan, DeskMan/2, DM2Setup, VUEMan, VUEMan/2 and DM2Image   
      are trademarks of Development Technologies, Inc. (DevTech),   
      a Pennsylvania Corporation                                    
                                                                    
  version 1.51                                        April 1994    
*/
/*Ŀ
        Creates a shadow of the name-object located in the          
        FolderName-folder in the InFolderName-folder.               
                                                                    
        The folder and object names should be surrounded by "       
        if containing blanks.                                       
                                                                    
        The format is:                                              
        PerformCreateShadow=name,FolderName,InFolderName;           
                                                                    
        name can be:         . object title                         
                             . object ID                            
                             . fully qualified path                 
          note: if an object ID (i.e., a character string enclosed  
                in brackets <>) is used as the object name, the     
                object's location specified as FolderName will be   
                IGNORED! - but needs to be specified.               
        FolderName can be:   . folder title                         
                             . object ID                            
                             . fully qualified path                 
                             . ANYWHERE                             
          note: if ANYWHERE is specified as the object's location,  
                the entire Desktop will be searched for the object  
                specified (top-down). First object found will be    
                used.                                               
        InFolderName can be: . folder title                         
                             . object ID                            
                             . fully qualified path                 
                                                                    
*/

/* Execute as: PERFSH Name Folder InFolder                          */

Parse Arg args;
args=Strip(args);
If Left(args,1) = '"'
   Then Parse Var args '"'object'"' args;
   Else Parse Var args    object    args;
args=Strip(args);
If Left(args,1) = '"'
   Then Parse Var args '"'folder'"' args;
   Else Parse Var args    folder    args;
args=Strip(args);
If Left(args,1) = '"'
   Then Parse Var args '"'Infolder'"' .;
   Else Parse Var args    Infolder    .;

If object  = ''
   Then Do;
     Say 'DeskMan/2 PERFORM: the object name is a required parameter.';
     Exit 99;
     End;
If folder  = ''
   Then Do;
     Say 'DeskMan/2 PERFORM: the folder name is a required parameter.';
     Exit 99;
     End;
If Infolder  = ''
   Then Do;
     Say 'DeskMan/2 PERFORM: the target folder name is a required parameter.';
     Exit 99;
     End;


Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs';
Call SysLoadFuncs;

rc=SysSetObjectData('<DeskMan1>',,
                    'PerformCreateShadow='object','folder','Infolder';');
If rc <> 1           
   Then Do;
     Say  "DeskMan/2 PERFORM: error performing Create shadow!";
     Exit 99;
     End;

Say 'DeskMan/2 PERFORM: Create shadow object initiated successfully!';
Exit 0;                
