/* REXX OS/2 - PerfSET.CMD  perform a wpSetup on an object          */
/*-Ŀ
                                                                    
  (C) Copyright 1993-1994 Development Technologies, Inc.            
      Portions Copyright 1993 Gregory Czaja                         
      All rights reserved                                           
      DeskMan, DeskMan/2, DM2Setup, VUEMan, VUEMan/2 and DM2Image   
      are trademarks of Development Technologies, Inc. (DevTech),   
      a Pennsylvania Corporation                                    
                                                                    
  version 1.51                                    September 1994    
*/
/*Ŀ
        Performs a wpSetup function on the specified object         
        located in the FolderName-folder or ALL objects in          
        a specified folder (for example <WP_DESKTOP>)               
                                                                    
        The folder and object names should be surrounded by "       
        if containing blanks.                                       
                                                                    
        The format is:                                              
        PerformSetup=objectName,FolderName,setupString;             
                                                                    
        objectName can be:   . object title                         
                             . object ID                            
                             . fully qualified path                 
                             . ALL the setup string will be applied 
                             .     to all objects and subfolders    
                             .     located in this folder and to    
                             .     the folder itself,               
                             . ALLEXCEPT the setup string will be   
                             .     applied to all objects and       
                             .     subfolders located in this folder
                             .     but NOT to the folder itself,    
                                                                    
          note: if an object ID (i.e., a character string enclosed  
                in brackets <>) is used as the object name, the     
                object's location specified as FolderName will be   
                IGNORED! - but needs to be specified.               
        FolderName can be:   . folder title                         
                             . object ID                            
                             . fully qualified path                 
                             . ANYWHERE                             
          note: if ANYWHERE is specified as the object's location,  
                the entire Desktop will be searched for the object  
                specified (top-down). First object found will be    
                used. Not allowed with ALL/ALLEXCEPT!               
                                                                    
        setupString is one or more of KEYWORD=value; pairs,         
                (separated by a semicolon)                          
                                                                    
          note: the setupString can be any valid WPS object specific
                setup string or one of the DeskMan/2 private strings
                (see WPS Guide and Reference, DeskMan/2 User's Guide
                 and DeskMan/2 WPS Extensions User's Guide)         
                                                                    
*/

/* Execute as: PERFSET Name Folder setupString                      */

Parse Arg args;

args = Strip(args);
If Left(args,1) = '"'
   Then Parse Var args '"'object'"' args;
   Else Parse Var args    object    args;

args = Strip(args);
If Left(args,1) = '"'
   Then Parse Var args '"'folder'"' setupString;
   Else Parse Var args    folder    setupString;

setupString = Strip(setupString);
setupString = Strip(setupString, 'B', '"');
setupString = Strip(setupString);
setupString = Strip(setupString, 'T', ';');

If object  = ''
   Then Do;
     Say 'DeskMan/2 PERFORM: the object name is a required parameter.';
     Exit 99;
     End;
If folder  = ''
   Then Do;
     Say 'DeskMan/2 PERFORM: the folder name is a required parameter.';
     Exit 99;
     End;
If setupString  = ''
   Then Do;
     Say 'DeskMan/2 PERFORM: the setupString is a required parameter.';
     Exit 99;
     End;


Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs';
Call SysLoadFuncs;

rc=SysSetObjectData('<DeskMan1>',,
                    'PerformSetup='object','folder','setupString';');
If rc <> 1           
   Then Do;
     Say  "DeskMan/2 PERFORM: error performing wpSetup on the "object" object!";
     Exit 99;
     End;

Say 'DeskMan/2 PERFORM: wpSetup performed successfully!';
Exit 0;                

