/* REXX OS/2 - PerfRO.CMD  perform a Restore object function        */
/*-Ŀ
                                                                    
  (C) Copyright 1993-1994 Development Technologies, Inc.            
      Portions Copyright 1993 Gregory Czaja                         
      All rights reserved                                           
      DeskMan, DeskMan/2, DM2Setup, VUEMan, VUEMan/2 and DM2Image   
      are trademarks of Development Technologies, Inc. (DevTech),   
      a Pennsylvania Corporation                                    
                                                                    
  version 1.51                                        April 1994    
*/
/*Ŀ
        Performs a Restore object function for objects located      
        in a DeskMan/2 DRC file.                                    
                                                                    
        The folder and object names should be surrounded by "       
        if containing blanks.                                       
                                                                    
        The format is:                                              
                                                                    
 . single object in a folder:                                                 
   PerformRestoreObject=x:\path\file.drc,objectName,FolderName,Option;
                                                                    
 . all objects (including subfolders) in a folder:                            
   PerformRestoreObject=x:\path\file.drc,ALL,FolderName,Option;               
                                                                    
 . all objects from the DRC file specified:                                   
   PerformRestoreObject=x:\path\file.drc,ALL,ALL,Option;                      
                                                                    
        name can be:         . object title                         
                             . object ID                            
                             . ALL    (all objects in a folder)     
                                                                              
        FolderName can be:   . folder name                          
                             . folder object ID                     
                             . ALL    (all folders in the DRC file  
                                       and all objects in them)     
                                                                              
        Option can be:       . SKIP,                                
                             . UPDATE,                              
                             . REPLACE,                             
                             . BYPASS (like REPLACE, limited class  
                               replacement and private classes      
                               support, no searching for duplicate  
                               objects, no icon optimization,       
                               no data files restoration but        
                               2-10 times faster than REPLACE)      
                                                                    
        Note: The current Search everywhere setting and the         
              Skip/Update/Replace option for the Desktop            
              restore operation, as specified for the DeskMan/2     
              object, is used.                                      
              They can be overriden by adding the corresponding     
              setup strings to the SysSetObjectData call -          
              see comments below.                                   
*/

/* Execute as: PERFRO x:\deskman\test.drc Name Folder Option        */

Parse Arg args;
If Left(args,1) = '"'
   Then Parse Var args '"'DRCfile'"' args;
   Else Parse Var args    DRCfile    args;
args=Strip(args);
If Left(args,1) = '"'
   Then Parse Var args '"'object'"' args;
   Else Parse Var args    object    args;
args=Strip(args);
If Left(args,1) = '"'
   Then Parse Var args '"'folder'"' option .;
   Else Parse Var args    folder    option .;


If DRCfile = ''
   Then Do;
     Say 'DeskMan/2 PERFORM: the DRC file name is a required parameter.';
     Exit 99;
     End;
If object  = ''
   Then Do;
     Say 'DeskMan/2 PERFORM: the object name is a required parameter.';
     Exit 99;
     End;
If folder  = ''
   Then Do;
     Say 'DeskMan/2 PERFORM: the folder name is a required parameter.';
     Exit 99;
     End;
If Option  = ''
   Then Do;
     Say 'DeskMan/2 PERFORM: the Restore option is a required parameter.';
     Exit 99;
     End;


Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs';
Call SysLoadFuncs;

setupString = 'PerformRestoreObject='DRCfile','object','folder','option';';

   /* this is the default setup string, which accepts the current
    | DeskMan/2 settings.
    | If you would like to change any of the settings before executing
    | the RESTORE, add corresponding KEYWORD=value pairs to the setupString.
    | Example:
    | . to change the Restore option:
    |   setupString='RESTORESKIP=YES;' || setupString;
    |
    | . to change the Search everywhere setting:
    |   setupString='RESTORESEARCH=YES;' || setupString;
    |
    | . to change the Prompt setting:
    |   setupString='RESTOREPROMPT=YES;' || setupString;
    |
    | . etc. all keywords listed in the DeskMan.CFG file can be used.
    |   Any logical combination is allowed.
    | Note: the values will change the current DeskMan/2 object settings!
    */
rc=SysSetObjectData('<DeskMan1>', setupString);
If rc <> 1           
   Then Do;
     Say  "DeskMan/2 PERFORM: error performing Restore object!";
     Exit 99;
     End;

Say 'DeskMan/2 PERFORM: Restore object initiated successfully!';
Exit 0;                
