/* REXX OS/2 - PerfDO.CMD  perform a Destroy object function        */
/*-Ŀ
                                                                    
  (C) Copyright 1993-1994 Development Technologies, Inc.            
      Portions Copyright 1993 Gregory Czaja                         
      All rights reserved                                           
      DeskMan, DeskMan/2, DM2Setup, VUEMan, VUEMan/2 and DM2Image   
      are trademarks of Development Technologies, Inc. (DevTech),   
      a Pennsylvania Corporation                                    
                                                                    
  version 1.51                                        April 1994    
*/
/*Ŀ
        Destroys the object of the name-object located in the       
        FolderName-folder.                                          
                                                                    
        The folder and object names should be surrounded by "       
        if containing blanks.                                       
                                                                    
        The format is:                                              
        PerformDestroyObject=name,FolderName;                       
                                                                    
        name can be:         . object title                         
                             . object ID                            
                             . fully qualified path                 
                             . ALL                                  
          note: if an object ID (i.e., a character string enclosed  
                in brackets <>) is used as the object name, the     
                object's location specified as FolderName will be   
                IGNORED! - but needs to be specified.               
          note: if ALL is specified, all objects located in the     
                folder specified, including the folder itself,      
                will be destroyed.                                  
                Not allowed with ANYWHERE!                          
        FolderName can be:   . folder title                         
                             . object ID                            
                             . fully qualified path                 
                             . ANYWHERE                             
          note: if ANYWHERE is specified as the object's location,  
                the entire Desktop will be searched for the object  
                specified (top-down). First object found will be    
                used. Not allowed with ALL.                         
                                                                    
          NOTE: do NOT USE on Drives and Templates!                                                          
                                                                    
*/

/* Execute as: PERFDO Name Folder                                   */

Parse Arg args;
args=Strip(args);
If Left(args,1) = '"'
   Then Parse Var args '"'object'"' args;
   Else Parse Var args    object    args;
args=Strip(args);
If Left(args,1) = '"'
   Then Parse Var args '"'folder'"' .;
   Else Parse Var args    folder    .;

If object  = ''
   Then Do;
     Say 'DeskMan/2 PERFORM: the object name is a required parameter.';
     Exit 99;
     End;
If folder  = ''
   Then Do;
     Say 'DeskMan/2 PERFORM: the folder name is a required parameter.';
     Exit 99;
     End;


Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs';
Call SysLoadFuncs;

rc=SysSetObjectData('<DeskMan1>',,
                    'PerformDestroyObject='object','folder';');
If rc <> 1           
   Then Do;
     Say  "DeskMan/2 PERFORM: error performing Destroy object!";
     Exit 99;
     End;

Say 'DeskMan/2 PERFORM: Destroy object initiated successfully!';
Exit 0;                
