/* REXX OS/2 - PerfClsA.CMD  Close ALL views of an object           */
/*-Ŀ
                                                                    
  (C) Copyright 1993-1994 Development Technologies, Inc.            
      Portions Copyright 1993 Gregory Czaja                         
      All rights reserved                                           
      DeskMan, DeskMan/2, DM2Setup, VUEMan, VUEMan/2 and DM2Image   
      are trademarks of Development Technologies, Inc. (DevTech),   
      a Pennsylvania Corporation                                    
                                                                    
  version 1.51                                        April 1994    
*/
/*Ŀ
        Performs a wpClose function on the specified object         
        located in the FolderName-folder                            
        Note: all views of an object and views of any object        
              added to the object's Open menu, will be closed.      
                                                                    
        Note: can be used on systems not having DeskMan/2 WPS       
              Extensions installed (i.e. below 2.1 or 2.0+SP2)      
              On systems with Extensions, PerfCls.CMD should        
              be used instead!                                      
                                                                    
        The folder and object names should be surrounded by "       
        if containing blanks.                                       
                                                                    
        The format is:                                              
        PerformClose=objectName,FolderName                          
                                                                    
        objectName can be:   . object title                         
                             . object ID                            
                             . fully qualified path                 
                                                                    
          note: if an object ID (i.e., a character string enclosed  
                in brackets <>) is used as the object name, the     
                object's location specified as FolderName will be   
                IGNORED! - but needs to be specified.               
                                                                    
        FolderName can be:   . folder title                         
                             . object ID                            
                             . fully qualified path                 
                             . ANYWHERE                             
          note: if ANYWHERE is specified as the object's location,  
                the entire Desktop will be searched for the object  
                specified (top-down). First object found will be    
                used.                                               
                                                                    
*/

/* Execute as: PERFCLSA Name Folder                                 */

Parse Arg args;
args = Strip(args);

If Left(args,1) = '"'
   Then Parse Var args '"'object'"' args;
   Else Parse Var args    object    args;

args = Strip(args);
If Left(args,1) = '"'
   Then Parse Var args '"'folder'"' .;
   Else Parse Var args    folder    .;

If object  = ''
   Then Do;
     Say 'DeskMan/2 PERFORM: the object name is a required parameter.';
     Exit 99;
     End;
If folder  = ''
   Then Do;
     Say 'DeskMan/2 PERFORM: the folder name is a required parameter.';
     Exit 99;
     End;

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs';
Call SysLoadFuncs;

rc = SysSetObjectData('<DeskMan1>',,
                      'PerformCloseObject='object','folder';');
If rc <> 1           
   Then Do;
     Say  "DeskMan/2 PERFORM: error performing CLOSE on the "object" object!";
     Exit 99;
     End;

Say 'DeskMan/2 PERFORM: CLOSE performed successfully!';
Exit 0;                



