/* REXX OS/2 - DM2ImgR.CMD installs DeskMan/2 Image backup/restore  */
/*             use DM2ImgR.CFG file                                  */
/*             see DM2ImgR.CFG for values required                   */
/*-Ŀ
                                                                    
  (C) Copyright 1993-1994 Development Technologies, Inc.            
      Portions Copyright 1993 Gregory Czaja                         
      All rights reserved                                           
      DeskMan, DeskMan/2, DM2Setup, VUEMan, VUEMan/2 and DM2Image   
      are trademarks of Development Technologies, Inc. (DevTech),   
      a Pennsylvania Corporation                                    
                                                                    
  version 1.51                                        April 1994    
      RC returned:                                                  
                                                                    
      0 = install successful                                        
      99= ERROR, not installed                                      
*/

Arg CFGfile . ;  /* accept the CFG file name as parameter             */

If CFGfile = ''
   Then Do;
     Say 'DM2Image INSTALL: the CFG file name is a required parameter.';
     Exit 99;
     End;

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs';
Call SysLoadFuncs;

ini.='';

If \ ParseCFG(CFGfile)
   Then Exit 99;               /* error while parsing - exit with error */

required = 'SOURCE TARGET TARGETDLL TARGETHLP TARGETINF LOCDM2IMAGE LOCINF ',
           'HELP GUIDE';

compared = required;
error = 0;

Do i = 1 to Words(required);

   word = Word(required, i);
   x = Value(word,word);
   If ini.word = ''       /* value omitted                         */
      Then Do;
          Select            /* certain values may be omitted       */
            When word = 'TARGETHLP'
              Then Do;
                If ini.HELP <> 'NO'      /* need TARGETHLP         */
                   Then Do;
                     error = 1;
                     Say 'DM2Image INSTALL: TARGETHLP value is required.';
                     Iterate;
                     End;
                End;
            When word = 'TARGETINF'
              Then Do;
                If ini.GUIDE <> 'NO'
                   Then Do;
                     error = 1;
                     Say 'DM2Image INSTALL: TARGETINF value is required.';
                     Iterate;
                     End;
                End;
            When word = 'LOCINF'
              Then Do;
                If ini.GUIDE <> 'NO'
                   Then Do;
                     error = 1;
                     Say 'DM2Image INSTALL: LOCINF value is required.';
                     Iterate;
                     End;
                End;
            Otherwise
                error = 1;
                Say 'DM2Image INSTALL:' word 'value is required.';
                Iterate;
          End;
        End;
   compared = DelWord(compared, WordPos(word, compared),  1);
                                         /* value checked - not needed anymore */
End;

If compared <> ''
   Then Do;
     error = 1;
     Say 'DM2Image INSTALL: the following keyword values are not present in the';
     Say 'CFG file:';
     Say compared;
     End;

If error Then Exit 99               /* errors found - exit                   */

                   /* we accept RC <> 0 since the objet may be not there yet */

rc = SysDestroyObject("<DM2IMAGE>");
rc = SysDestroyObject("<DM2Image_INF>");


Say  "DM2Image INSTALL: installing from:",
      ini.SOURCE 'into' ini.TARGET 'directory.';

If Directory() <> ini.TARGETDLL    /* 1.1 do not erase installation files! */
   Then Do;
     '@ERASE "'ini.TARGETDLL'\DM2ITOOL.DLL" 2>NUL';
     '@COPY "'ini.SOURCE'\DM2ITOOL.DLL"' ini.TARGETDLL;

     End;
   Else rc = 0;

If rc <> 0                /* copy failed                           */
   Then Do;
     Say  "DM2Image INSTALL: could not replace the DLL, rc="rc". A system re-boot may be required!";
     Exit 99;
     End;

     /* copy all DeskMan/2 product files to the TARGET directory */
If Stream(ini.SOURCE'\INSTALL.LST', 'C', 'QUERY EXISTS') == ''
   Then 
     Say 'DM2Image INSTALL: no INSTALL.LST file found - no files copied!';
   Else Do;
     Call CopyFiles '"'ini.SOURCE'"' '"'ini.SOURCE'\INSTALL.LST"' '"'ini.TARGET'"',
                    '[DeskMan/2 WPS Image Backup Facility]' 
     End;   

rc = SysCreateObject('WPProgram','DM2 Image', ini.LOCDM2IMAGE, ,
   'OBJECTID=<DM2IMAGE>;'||,
   'EXENAME='ini.TARGET'\DM2Image.EXE;STARTUPDIR='ini.TARGET';'||,
   'PARAMETERS=[Save or Restore?];',,
   'ReplaceIfExists');

If rc <> 1                 /* registered OK ?                */
   Then Do;
     Say  "DM2Image INSTALL: could not create DM2 Image object.";
     Exit 99;
     End;

If ini.HELP = 'YES'
   Then Do;
     If Directory() <> ini.TARGETHLP    /* 1.1 do not erase installation files! */
        Then Do;
          '@ERASE "'ini.TARGETHLP'\DM2Image.HLP" 2>NUL';
          '@COPY "'ini.SOURCE'\DM2Image.HLP"' ini.TARGETHLP;
          End;
        Else rc = 0;
     If rc <> 0                /* copy failed                           */
        Then Do;
          Say  "DM2Image INSTALL: could not copy/replace the HLP file!";
          Exit 99;
          End;
     End;
If ini.GUIDE = 'YES'
   Then Do;
     If Directory() <> ini.TARGETINF    /* 1.1 do not erase installation files! */
        Then Do;
          '@ERASE "'ini.TARGETINF'\DM2Image.INF" 2>NUL';
          '@COPY "'ini.SOURCE'\DM2Image.INF"' ini.TARGETINF;
          End;
        Else rc = 0;
     If rc <> 0                /* copy failed                           */
        Then Do;
          Say  "DM2Image INSTALL: could not copy/replace the INF file!";
          Exit 99;
          End;
     rc = SysCreateObject('WPProgram',"DM2Image"||'0A'x||"User's Guide", ini.LOCINF,,
          'EXENAME=VIEW.EXE;'||,
          'PARAMETERS='ini.TARGETINF'\DM2Image.INF;OBJECTID=<DM2Image_INF>;','Update');
     End;

current = Directory(ini.TARGET);
'DM2Image /c';            /* configure DM2 Image */
Call Directory(current);

Say 'DM2Image INSTALL: DeskMan/2 WPS Image Backup program was installed successfully!';


Exit 0;                   /* successfull install Exit!             */

/* ----------------------------------------------------------------*/
ParseCFG: Procedure Expose ini.

CFGfile=Arg(1);           /* the CFG file name */

linenum=0;
Do While Lines(CFGfile);
   line=Linein(CFGfile);
   linenum=linenum + 1;
   If Left(line,1) = '*'
      Then Iterate;       /* skip comment lines */

   Parse Var line keyword '=' value;
   If ini.keyword <> ''
      Then Do;
        Say 'DM2Image INSTALL: duplicate keyword in line' linenum 'ignored.';
        Iterate;
        End;
   If value = ''
      Then Do;
        Say 'DM2Image INSTALL: invalid value for the' keyword 'keyword in line' linenum;
        Say 'DM2Image INSTALL: install error.';
        Return 0;
        End;
   ini.keyword=value;
End;
Call Stream CFGfile, 'C', 'CLOSE';

Return 1;


/* ----------------------------------------------------------------*/
CopyFiles: Procedure 

Parse Arg  fromDir list toDir key; 

linenum = 0;
keyFound = 0;
fromDir = Strip(fromDir, 'B', '"');
list = Strip(list, 'B', '"');
toDir = Strip(toDir, 'B', '"');

Do While Lines(list);

   line = LineIn(list);
   If keyFound
      Then Do;

        If Left(line, 1) == '['   /* end of the current section! */
           Then Leave;

        Parse Var line file ',' index
           /* does it go into the TARGET INSTALL directory?      */
           /* copy the I and P files!                            */
        If Translate(index) <> 'I' & ,
           Translate(index) <> 'P'
           Then Iterate;                /* no - it doesn't       */

        linenum = linenum + 1;
        files.linenum = file;
        End;

      Else Do;
        If line == key
           Then Do;
             keyFound = 1;
             Iterate;
             End;
        End;
End;

Call Stream list, 'C', 'CLOSE';

If linenum = 0          /* nothing found to copy... */
   Then Return 0;


Do i = 1 to linenum;
   '@COPY "'fromDir||'\'files.i'"' '"'toDir'"';
   if rc <> 0
      Then 
        Say 'DM2Image INSTALL: error - 'rc' copying file:' files.i'!';
End;

Return 0;          /* we discard all copy errors... */

