/* REXX OS/2 - DM2ExtR.CMD installs DeskMan/2 WPS Extensions        */
/*             use DM2Ext.CFG file                                  */
/*             see DM2Ext.CFG for values required                   */
/*-Ŀ
                                                                    
  (C) Copyright 1993-1994 Development Technologies, Inc.            
      Portions Copyright 1993 Gregory Czaja                         
      All rights reserved                                           
      DeskMan, DeskMan/2, DM2Setup, VUEMan, VUEMan/2 and DM2Image   
      are trademarks of Development Technologies, Inc. (DevTech),   
      a Pennsylvania Corporation                                    
                                                                    
  version 1.51                                     September 1994   
      RC returned:                                                  
                                                                    
      0 = install successful                                        
      3 = install successful but Shut down/reboot or WPS restart    
          are required                                              
      99= ERROR, not installed                                      
*/

Arg CFGfile . ;  /* accept the CFG file name as parameter             */

If CFGfile = ''
   Then Do;
     Say 'DM/2 WPS Extensions: the CFG file name is a required parameter.';
     Exit 99;
     End;

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs';
Call SysLoadFuncs;

ini.='';

If \ ParseCFG(CFGfile)
   Then Exit 99;               /* error while parsing - exit with error */

required = 'SOURCE TARGET TARGETDLL TARGETHLP TARGETINF LOCINF ',
           'HELP GUIDE IGNOREINI';

compared = required;
error = 0;

Do i = 1 to Words(required);

   word = Word(required, i);
   x = Value(word,word);
   If ini.word = ''       /* value omitted                         */
      Then Do;
          Select            /* certain values may be omitted       */
            When word = 'TARGETHLP'
              Then Do;
                If ini.HELP <> 'NO'      /* need TARGETHLP         */
                   Then Do;
                     error = 1;
                     Say 'DM/2 WPS Extensions: TARGETHLP value is required.';
                     Iterate;
                     End;
                End;
            When word = 'TARGETINF'
              Then Do;
                If ini.GUIDE <> 'NO'
                   Then Do;
                     error = 1;
                     Say 'DM/2 WPS Extensions: TARGETINF value is required.';
                     Iterate;
                     End;
                End;
            When word = 'LOCINF'
              Then Do;
                If ini.GUIDE <> 'NO'
                   Then Do;
                     error = 1;
                     Say 'DM/2 WPS Extensions: LOCINF value is required.';
                     Iterate;
                     End;
                End;
            Otherwise
                error = 1;
                Say 'DM/2 WPS Extensions:' word 'value is required.';
                Iterate;
          End;
        End;
   compared = DelWord(compared, WordPos(word, compared),  1);
                                         /* value checked - not needed anymore */
End;

If compared <> ''
   Then Do;
     error = 1;
     Say 'DM/2 WPS Extensions: the following keyword values are not present in the';
     Say 'CFG file:';
     Say compared;
     End;

If error Then Exit 99               /* errors found - exit                   */

Say  "DM/2 WPS Extensions INSTALL: installing DLL's from:",
      ini.SOURCE 'into' ini.TARGETDLL 'directory.';

If Directory() <> ini.TARGETDLL    /* 1.1 do not erase installation files! */
   Then Do;
     '@ERASE "'ini.TARGETDLL'\DM2Ext.DLL" 2>NUL';
     '@COPY "'ini.SOURCE'\DM2Ext.DLL"' ini.TARGETDLL '2>2.out & TYPE 2.out |RXQUEUE';

     Do Queued();
        Pull msg .;
        If msg = 'SYS0032:'
           Then rc = 32;
     End;

     If rc = 32                 /* the DLL is in use - replace it!       */
        Then Do;
          '@DM2Rep 1 "'ini.SOURCE'\DM2Ext.DLL" "'ini.TARGETDLL'\DM2Ext.DLL"';

          If rc = 0 
             Then Do;
               RestartRequired = 1;   /* we have to restart the WPS      */
               End;
          End;

     End;
   Else rc = 0;

If rc <> 0                /* copy failed                           */
   Then Do;
     Say  "DM/2 WPS Extensions: could not replace the DM2Ext.DLL, rc="rc".";
     Say  "A system re-boot may be required!";
     Exit 99;
     End;

'@ERASE 2.out 2>NUL';

rc = SysRegisterObjectClass('MinUse',ini.TARGETDLL'\DM2Ext.DLL');
If rc <> 1                /* copy failed                           */
   Then Do;
     Say  "DM/2 WPS Extensions: could not register the Extensions object class.";
     Exit 99;
     End;

'@DM2Rep 2 WPObject MinUse';

If rc <> 0
   Then Do;
     Say  "DM/2 WPS Extensions: error installing Extensions, DM2Rep returned rc="rc".";
     Exit 99;
     End;

If ini.HELP = 'YES'
   Then Do;
     If Directory() <> ini.TARGETHLP    /* 1.1 do not erase installation files! */
        Then Do;
          '@ERASE "'ini.TARGETHLP'\DM2Ext.HLP" 2>NUL';
          '@COPY "'ini.SOURCE'\DM2Ext.HLP"' ini.TARGETHLP;
          End;
        Else rc = 0;
     If rc <> 0                /* copy failed                           */
        Then Do;
          Say  "DM/2 WPS Extensions: could not copy/replace the HLP file!";
          Exit 99;
          End;
     End;
If ini.GUIDE = 'YES'
   Then Do;
     If Directory() <> ini.TARGETINF    /* 1.1 do not erase installation files! */
        Then Do;
          '@ERASE "'ini.TARGETINF'\DM2Ext.INF" 2>NUL';
          '@COPY "'ini.SOURCE'\DM2Ext.INF"' ini.TARGETINF;
          End;
        Else rc = 0;
     If rc <> 0                /* copy failed                           */
        Then Do;
          Say  "DM/2 WPS Extensions: could not copy/replace the INF file!";
          Exit 99;
          End;
     rc = SysCreateObject('WPProgram',
          "DeskMan/2"||'0A'x||"WPS Extensions"||'0A'x||"User's Guide", ini.LOCINF,,
          'EXENAME=VIEW.EXE;'||,
          'PARAMETERS='ini.TARGETINF'\DM2Ext.INF;OBJECTID=<DM2Ext_INF>;','Update');
     End;

     /* copy all DeskMan/2 Extensions files to the TARGET directory */
If Stream(ini.SOURCE'\INSTALL.LST', 'C', 'QUERY EXISTS') == ''
   Then 
     Say 'DM/2 WPS Extensions: no INSTALL.LST file found - no files copied!';
   Else Do;
     Call CopyFiles '"'ini.SOURCE'"' '"'ini.SOURCE'\INSTALL.LST"' '"'ini.TARGET'"',
                    '[DeskMan/2 WorkPlace Shell Extensions]' 
     End;   

Settings='DMExtMinimize DMExtAddOpen DMExtAddClose DMExtRestartWPS',
         'DMExtProtection DMExtProtect',
         'DMExtRemoveArrange DMExtRemoveSort DMExtRemoveFind',
         'DMExtRemoveShutdown DMExtRemoveSystemSetup DMExtRemoveLockUp',
         'DMExtRemoveSettings DMExtAllowDelete DMExtAllowMove DMExtAllowCopy',
         'DMExtAllowRename DMExtAllowNew DMExtAllowShadow',
         'DMExtAllowDrag DMExtDragDrop',
         'DMExtObjectOverride DMExtFolderOverride',
         'DMExtAllowDrop DMExtRemoveSelect DMExtAllowVisible DMExtSaveWinPos';
         
setup = '01'x ||,     /*  0 Minimize on use */
        '01'x ||,     /*  1 Additional open menu items */
        '01'x ||,     /*  2 Additional close menu items */
        '00'x ||,     /*  3 Restart WPS menu item */
        '00'x ||,     /*  4 Protection enabled */
        '00'x ||,     /*  5 Protect folders only */
        '00'x ||,     /*  6 Remove folder Arrange */
        '00'x ||,     /*  7 Remove folder Sort */
        '00'x ||,     /*  8 Remove folder Find */
        '00'x ||,     /*  9 Remove Shut down */
        '00'x ||,     /* 10 Remove System Setup */
        '00'x ||,     /* 11 Remove Lock up */
        '00'x ||,     /* 12 Remove Settings menu item from all objects */
        '01'x ||,     /* 13 Allow Delete */
        '01'x ||,     /* 14 Allow Move */
        '01'x ||,     /* 15 Allow Copy */
        '01'x ||,     /* 16 Allow Rename */
        '01'x ||,     /* 17 Allow creation of new objects */
        '01'x ||,     /* 18 Allow shadow creation */
        '01'x ||,     /* 19 Allow Drag */
        '01'x ||,     /* 20 Enable Extended Drag & Drop */
        '01'x ||,     /* 21 Allow object overrides */
        '01'x ||,     /* 22 Allow folder overrides */
        '01'x ||,     /* 23 Allow Drop */
        '00'x ||,     /* 24 Reserved   */
        '00'x ||,     /* 25 RemoveSelect */
        '00'x ||,     /* 26 Reserved   */
        '01'x ||,     /* 27 AllowVisible */
        '01'x;        /* 28 Save Window positions */
error = 0;
Do i = 1 to Words(Settings);
   word = Translate(Word(Settings, i));
   x = Value(word,word);
   If ini.word = ''       /* value omitted                         */
      Then Do;
        Say 'DM/2 WPS Extensions:' word 'value will be left UNCHANGED!';
        Iterate;
        End;

   If ini.word = 'YES' | ini.word = '1'
      Then setup = Left(setup, i - 1) || '01'x || Substr(setup, i+1);
      Else setup = Left(setup, i - 1) || '00'x || Substr(setup, i+1);

End;

oldSettings = SysIni('USER', 'DeskManE', 'Settings');

If Left(oldSettings, 5) = 'ERROR' | ini.IGNOREINI='YES'
   Then Do;
     newSettings = setup;
     End;

   Else newSettings = oldSettings;

rc = SysIni('USER', 'DeskManE', 'Settings', newSettings);
If rc <> ''
   Then Do;
     Say 'DM/2 WPS Extensions: error setting values for Extensions.';
     Exit 99;
     End;


Say 'DeskMan/2 INSTALL: DeskMan/2 WPS Extensions were installed successfully!';
Say '                   A system Shut down/reboot or WPS restart is REQUIRED!';

Exit 3;                   /* successfull install Exit!             */

/* ----------------------------------------------------------------*/
ParseCFG: Procedure Expose ini.

CFGfile=Arg(1);           /* the CFG file name */

linenum=0;
Do While Lines(CFGfile);
   line=Linein(CFGfile);
   linenum=linenum + 1;
   If Left(line,1) = '*'
      Then Iterate;       /* skip comment lines */

   Parse Var line keyword '=' value ;
   keyword = Translate(Strip(keyword));
   value = Translate(Strip(value));
   If ini.keyword <> ''
      Then Do;
        Say 'DeskMan/2 INSTALL: duplicate keyword in line' linenum 'ignored.';
        Iterate;
        End;
   If value = ''
      Then Do;
        Say 'DeskMan/ INSTALL: invalid value for the' keyword 'keyword in line' linenum;
        Say 'DeskMan/ INSTALL: install error.';
        Return 0;
        End;
   ini.keyword=value;
End;
Call Stream CFGfile, 'C', 'CLOSE';

Return 1;


/* ----------------------------------------------------------------*/
CopyFiles: Procedure 

Parse Arg  fromDir list toDir key; 

linenum = 0;
keyFound = 0;
fromDir = Strip(fromDir, 'B', '"');
list = Strip(list, 'B', '"');
toDir = Strip(toDir, 'B', '"');

Do While Lines(list);

   line = LineIn(list);
   If keyFound
      Then Do;

        If Left(line, 1) == '['   /* end of the current section! */
           Then Leave;

        Parse Var line file ',' index
           /* does it go into the TARGET INSTALL directory?      */
        If Translate(index) <> 'I'
           Then Iterate;                /* no - it doesn't       */

        linenum = linenum + 1;
        files.linenum = file;
        End;

      Else Do;
        If line == key
           Then Do;
             keyFound = 1;
             Iterate;
             End;
        End;
End;

Call Stream list, 'C', 'CLOSE';

If linenum = 0          /* nothing found to copy... */
   Then Return 0;


Do i = 1 to linenum;
   '@COPY "'fromDir||'\'files.i'"' '"'toDir'"';
   if rc <> 0
      Then 
        Say 'DeskMan/2 INSTALL: error - 'rc' copying file:' files.i'!';
End;

Return 0;          /* we discard all copy errors... */
