/* REXX OS/2 - DeskManS.CMD changes DeskMan/2 object Settings       */
/*-Ŀ
                                                                    
  (C) Copyright 1993-1994 Development Technologies, Inc.            
      Portions Copyright 1993 Gregory Czaja                         
      All rights reserved                                           
      DeskMan, DeskMan/2, DM2Setup, VUEMan, VUEMan/2 and DM2Image   
      are trademarks of Development Technologies, Inc. (DevTech),   
      a Pennsylvania Corporation                                    
                                                                    
  version 1.51                                        April 1994    
*/

Arg CFGfile . ;  /* accept the CFG file name as parameter           */

If CFGfile = ''
   Then Do;
     Say 'DeskMan/2 SETUP: the CFG file name is a required parameter.';
     Exit 99;
     End;

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs';
Call SysLoadFuncs;

ini.='';

If \ ParseCFG(CFGfile)
   Then Exit 99;               /* error while parsing - exit with error */


Settings='GENERATEDRC DRCSAVE DRCSAVEREPLACE DRCSAVEUPDATE SAVEDRCPROMPT',
         'RESOLVEFOLDERS GENERATEREXX REXXSAVE REXXSAVEREPLACE REXXSAVEUPDATE',
         'REXXSAVEPROMPT SAVEICONS ICONDIRECTORY SAVEDATAFILES DATADIRECTORY',
         'ASSIGNOBJECTIDORIGINAL ASSIGNOBJECTIDALL NOWARNINGS',
         'NOWARNINGSDOSWINOS2 DRCRESTORE INIRCRESTORE RESTOREREPLACE',
         'RESTORESKIP RESTOREUPDATE RESTOREPROMPT RESTORESEARCH',
         'USEMINIICONS DEFAULTVIEW DEBUG USEPMPRINTF LOGFILE',
         'SAVESYSTEMSETTINGS SYSTEMSETTINGSREXX SAVECONTROLPANEL SAVECOLORS',
         'DRCSYSTEM REXXSYSTEM',
         'SAVEICONPOSITION',             /* 93/09/25 1.11 */
         'DESKMANINI SAVEWINOS2';        /* 94/04/12 1.5  */
         
setup='';
error=0;
Do i=1 to Words(Settings);
   word=Word(Settings, i);
   x= Value(word,word);
   If ini.word = ''       /* value omitted                         */
      Then Do;
        Say 'DeskMan/2 SETUP:' word 'value will be left UNCHANGED!';
        Iterate;
        End;
   If Right(ini.word,1) <> ';'
      Then ini.word=ini.word||';';
   setup=setup||word'='ini.word;
End;

If setup <> ''             /* change the DeskMan/2 Settings        */
   Then Do;
     rc=SysSetObjectData('<DeskMan1>', setup);
     If rc <> 1           
        Then Do;
          Say  "DeskMan/2 SETUP: error changing Settings for DeskMan/2 object.";
          Exit 99;
          End;
     End;

Functions='AllowOpenSettings AllowOpenDeskMan AllowOpenStandard AllowOpenDebug',
          'AllowMove AllowShadow AllowDelete AllowSaveDesktop',
          'AllowRestoreDesktop AllowSystemSave AllowSystemRestore AllowSaveObjects',
          'AllowSpecials AllowDestroy AllowQueryObject AllowAssignID',
          'AllowOpenObject AllowAssignIcon AllowChangeStyle',
          'AllowOpenDRC AllowSaveDRC',
          'AllowSort AllowView AllowSelect AllowInclude AllowFind AllowArrange',
          'AllowRecreateObject AllowRecreateFolder AllowSelectFolder',
          'AllowFindFolder AllowChangeSetup AllowMapDrives AllowRemove',
          'AllowGenerateREXX AllowDragNDrop AllowCancel',
          'AllowSaveObjectSettings';
setup='';
error=0;
Do i=1 to Words(Functions);
   word=Word(Functions, i);
   x= Value(word,word);
   If ini.word = ''       /* value omitted                         */
      Then Do;
        Say 'DeskMan/2 SETUP:' word 'value will be UNCHANGED!';
        Iterate;
        End;
   If Right(ini.word,1) <> ';'
      Then ini.word=ini.word||';';
   setup=setup||word'='ini.word;
End;

If setup <> ''             /* change the DeskMan/2 Settings        */
   Then Do;
     rc=SysSetObjectData('<DeskMan1>', setup);
     If rc <> 1           
        Then Do;
          Say  "DeskMan/2 SETUP: error setting functions for DeskMan/2 object.";
          Exit 99;
          End;
     End;

Say 'DeskMan/2 SETUP: DeskMan/2 was set up successfully!';
Exit 0;                   /* successfull install Exit!             */

/* ----------------------------------------------------------------*/
ParseCFG: Procedure Expose ini.

CFGfile=Arg(1);           /* the CFG file name */

linenum=0;
Do While Lines(CFGfile);
   line=Linein(CFGfile);
   linenum=linenum + 1;
   If Left(line,1) = '*'
      Then Iterate;       /* skip comment lines */

   Parse Var line keyword '=' value;
   If ini.keyword <> ''
      Then Do;
        Say 'DeskMan/2 SETUP: duplicate keyword 'keyword' in line' linenum 'ignored.';
        Iterate;
        End;
   If value = ''
      Then Do;
        Say 'DeskMan/ SETUP: invalid value for the' keyword 'keyword in line' linenum;
        Say 'DeskMan/ SETUP: setup error.';
        Return 0;
        End;
   ini.keyword=value;
End;
Call Stream CFGfile, 'C', 'CLOSE';

Return 1;


