//
//  This is the script to create the Powerbuilder system tables.
//
//  Be sure to: 
//  -   change all occurrences of 'pbcatown' to the name that will own 
//      the Powerbuilder system tables
//  -   change all occurrences of 'database.tablespace' to the 
//      appropriate value
//  -   put in appropriate statement delimiters for the tool you use
//      to execute the sql (i.e. GO statement for ISQL)
//  -   strip comments and blank lines if necessary

CREATE TABLE pbcatown.PBCATTBL 
       ( PBT_TNAM  CHAR(30),
         PBT_TID  INTEGER,
         PBT_OWNR  CHAR(30),
         PBD_FHGT  SMALLINT,
         PBD_FWGT  SMALLINT,
         PBD_FITL  CHAR(1),
         PBD_FUNL  CHAR(1),
         PBD_FCHR  SMALLINT,
         PBD_FPTC  SMALLINT,
         PBD_FFCE  CHAR(18),
         PBH_FHGT  SMALLINT,
         PBH_FWGT  SMALLINT,
         PBH_FITL  CHAR(1),
         PBH_FUNL  CHAR(1),
         PBH_FCHR  SMALLINT,
         PBH_FPTC  SMALLINT,
         PBH_FFCE  CHAR(18),
         PBL_FHGT  SMALLINT,
         PBL_FWGT  SMALLINT,
         PBL_FITL  CHAR(1),
         PBL_FUNL  CHAR(1),
         PBL_FCHR  SMALLINT,
         PBL_FPTC  SMALLINT,
         PBL_FFCE  CHAR(18),
         PBT_CMNT  CHAR(254))
         IN database.tablespace
                  
 
CREATE UNIQUE INDEX PBCATTBL_IDX
       ON pbcatown.PBCATTBL
       (PBT_TNAM,
       PBT_OWNR)


GRANT SELECT, UPDATE, INSERT, DELETE ON 
	 pbcatown.PBCATTBL TO PUBLIC 


CREATE TABLE pbcatown.PBCATCOL 
       ( PBC_TNAM  CHAR(30),
         PBC_TID  INTEGER,
         PBC_OWNR  CHAR(30),
         PBC_CNAM  CHAR(30),
         PBC_CID  SMALLINT,
         PBC_LABL  CHAR(254),
         PBC_LPOS  SMALLINT,
         PBC_HDR  CHAR(254),
         PBC_HPOS  SMALLINT,
         PBC_JTFY  SMALLINT,
         PBC_MASK  CHAR(31),
         PBC_CASE  SMALLINT,
         PBC_HGHT  SMALLINT,
         PBC_WDTH  SMALLINT,
         PBC_PTRN  CHAR(31),
         PBC_BMAP  CHAR(1),
         PBC_INIT  CHAR(254),
         PBC_CMNT  CHAR(254),
         PBC_EDIT  CHAR(31),
         PBC_TAG  CHAR(254))
       IN database.tablespace        
 
CREATE UNIQUE INDEX PBCATCOL_IDX
       ON pbcatown.PBCATCOL
       (PBC_TNAM,
       PBC_OWNR,
       PBC_CNAM) 


GRANT SELECT, UPDATE, INSERT, DELETE ON 
	 pbcatown.PBCATCOL TO PUBLIC  


CREATE TABLE pbcatown.PBCATFMT 
       ( PBF_NAME  CHAR(30) NOT NULL,
         PBF_FRMT  CHAR(254) NOT NULL,
         PBF_TYPE  SMALLINT NOT NULL,
         PBF_CNTR  INTEGER)
       IN database.tablespace  
 
CREATE UNIQUE INDEX PBCATFMT_IDX
       ON pbcatown.PBCATFMT
       (PBF_NAME) 

GRANT SELECT, UPDATE, INSERT, DELETE ON 
	 pbcatown.PBCATFMT TO PUBLIC  


CREATE TABLE pbcatown.PBCATVLD 
       ( PBV_NAME  CHAR(30) NOT NULL,
         PBV_VALD  CHAR(254) NOT NULL,
         PBV_TYPE  SMALLINT,
         PBV_CNTR  INTEGER,
         PBV_MSG  CHAR(254))
       IN database.tablespace 
        
CREATE UNIQUE INDEX PBCATVLD_IDX
       ON pbcatown.PBCATVLD
       (PBV_NAME) 
 

GRANT SELECT, UPDATE, INSERT, DELETE ON 
	 pbcatown.PBCATVLD TO PUBLIC  
    

CREATE TABLE pbcatown.PBCATEDT
       (PBE_NAME CHAR(30) NOT NULL,
        PBE_EDIT VARCHAR(254),
        PBE_TYPE SMALLINT,
        PBE_CNTR INTEGER,
        PBE_SEQN SMALLINT,
        PBE_FLAG INTEGER,
        PBE_WORK CHAR(32))
       IN database.tablespace 

CREATE UNIQUE INDEX PBCATEDT_IDX
       ON pbcatown.PBCATEDT
       (PBE_NAME,
       PBE_SEQN) 
 
GRANT SELECT, UPDATE, INSERT, DELETE ON 
	 pbcatown.PBCATEDT TO PUBLIC  


//
//  The following fills the Powerbuilder Format table with
//  the default values.
//


INSERT INTO pbcatown.PBCATFMT VALUES (
	'[General]',
	'[General]',
	81,
	0) 
INSERT INTO pbcatown.PBCATFMT VALUES (
	'0',
	'0',
	81,
	0) 
INSERT INTO pbcatown.PBCATFMT VALUES (
	'0.00',
	'0.00',
	81,
	0)  
INSERT INTO pbcatown.PBCATFMT VALUES (
	'#,##0',
	'#,##0',
	81,
	0)  
INSERT INTO pbcatown.PBCATFMT VALUES (
	'#,##0.00',
	'#,##0.00',
	81,
	0)  
INSERT INTO pbcatown.PBCATFMT VALUES (
	'$#,##0;($#,##0)',
	'$#,##0;($#,##0)',
	81,
	0)  
INSERT INTO pbcatown.PBCATFMT VALUES (
	'$#,##0;[RED]($#,##0)',
	'$#,##0;[RED]($#,##0)',
	81,
	0)  
INSERT INTO pbcatown.PBCATFMT VALUES (
	'$#,##0.00;($#,##0.00)',
	'$#,##0.00;($#,##0.00)',
	81,
	0)  
INSERT INTO pbcatown.PBCATFMT VALUES (
	'$#,##0.00;[RED]($#,##0.00)',
	'$#,##0.00;[RED]($#,##0.00)',
	81,
	0)  
INSERT INTO pbcatown.PBCATFMT VALUES (
	'0%',
	'0%',
	81,
	0)  
INSERT INTO pbcatown.PBCATFMT VALUES (
	'0.00%',
	'0.00%',
	81,
	0)  
INSERT INTO pbcatown.PBCATFMT VALUES (
	'0.00E+00',
	'0.00E+00',
	81,
	0)  
INSERT INTO pbcatown.PBCATFMT VALUES (
	'm/d/yy',
	'm/d/yy',
	84,
	0)  
INSERT INTO pbcatown.PBCATFMT VALUES (
	'd-mmm-yy',
	'd-mmm-yy',
	84,
	0)  
INSERT INTO pbcatown.PBCATFMT VALUES (
	'd-mmm',
	'd-mmm',
	84,
	0)  
INSERT INTO pbcatown.PBCATFMT VALUES (
	'mmm-yy',
	'mmm-yy',
	84,
	0)  
INSERT INTO pbcatown.PBCATFMT VALUES (
	'h:mm AM/PM',
	'h:mm AM/PM',
	84,
	0)  
INSERT INTO pbcatown.PBCATFMT VALUES (
	'h:mm:ss AM/PM',
	'h:mm:ss AM/PM',
	84,
	0)  
INSERT INTO pbcatown.PBCATFMT VALUES (
	'h:mm:ss',
	'h:mm:ss',
	84,
	0)  
INSERT INTO pbcatown.PBCATFMT VALUES (
	'm/d/yy h:mm',
	'm/d/yy h:mm',
	84,
	0)  

//
//  The following fills the Powerbuilder Edit Style table with
//  the default values.
//

INSERT INTO pbcatown.PBCATEDT VALUES (
	'###,###.00',
	'###,###.00',
	90,
	1,
	1,
	32,
	'10')  
INSERT INTO pbcatown.PBCATEDT VALUES (
	'#####',
	'#####',
	90,
	1,
	1,
	32,
	'10')  
INSERT INTO pbcatown.PBCATEDT VALUES (
	'###-##-####',
	'###-##-####',
	90,
	1,
	1,
	32,
	'00')  
INSERT INTO pbcatown.PBCATEDT VALUES (
	'MM/DD/YY',
	'MM/DD/YY',
	90,
	1,
	1,
	32,
	'20')  
INSERT INTO pbcatown.PBCATEDT VALUES (
	'DD/MM/YY',
	'DD/MM/YY',
	90,
	1,
	1,
	32,
	'20')  
INSERT INTO pbcatown.PBCATEDT VALUES (
	'MM/DD/YYYY',
	'MM/DD/YYYY',
	90,
	1,
	1,
	32,
	'20')  
INSERT INTO pbcatown.PBCATEDT VALUES (
	'DD/MM/YYYY',
	'DD/MM/YYYY',
	90,
	1,
	1,
	32,
	'20')  
INSERT INTO pbcatown.PBCATEDT VALUES (
	'DD/MMM/YY',
	'DD/MMM/YY',
	90,
	1,
	1,
	32,
	'20')  
INSERT INTO pbcatown.PBCATEDT VALUES (
	'DDD/YY',
	'DDD/YY',
	90,
	1,
	1,
	32,
	'20')  
INSERT INTO pbcatown.PBCATEDT VALUES (
	'DDD/YYYY',
	'DDD/YYYY',
	90,
	1,
	1,
	32,
	'20')  
INSERT INTO pbcatown.PBCATEDT VALUES (
	'HH:MM:SS',
	'HH:MM:SS',
	90,
	1,
	1,
	32,
	'30')  
INSERT INTO pbcatown.PBCATEDT VALUES (
	'HH:MM:SS:FFF',
	'HH:MM:SS:FFF',
	90,
	1,
	1,
	32,
	'30')  
INSERT INTO pbcatown.PBCATEDT VALUES (
	'HH:MM:SS:FFFFFF',
	'HH:MM:SS:FFFFFF',
	90,
	1,
	1,
	32,
	'30')  
INSERT INTO pbcatown.PBCATEDT VALUES (
	'MM/DD/YY HH:MM:SS',
	'MM/DD/YY HH:MM:SS',
	90,
	1,
	1,
	32,
	'40')  
INSERT INTO pbcatown.PBCATEDT VALUES (
	'DD/MM/YY HH:MM:SS',
	'DD/MM/YY HH:MM:SS',
	90,
	1,
	1,
	32,
	'40')  
INSERT INTO pbcatown.PBCATEDT VALUES (
	'MM/DD/YYYY HH:MM:SS',
	'MM/DD/YYYY HH:MM:SS',
	90,
	1,
	1,
	32,
	'40')  
INSERT INTO pbcatown.PBCATEDT VALUES (
	'DD/MM/YYYY HH:MM:SS',
	'DD/MM/YYYY HH:MM:SS',
	90,
	1,
	1,
	32,
	'40')  
INSERT INTO pbcatown.PBCATEDT VALUES (
	'DD/MMM/YY HH:MM:SS',
	'DD/MMM/YY HH:MM:SS',
	90,
	1,
	1,
	32,
	'40')  
INSERT INTO pbcatown.PBCATEDT VALUES (
	'DDD/YY HH:MM:SS',
	'DDD/YY HH:MM:SS',
	90,
	1,
	1,
	32,
	'40')  
INSERT INTO pbcatown.PBCATEDT VALUES (
	'DDD/YYYY HH:MM:SS',
	'DDD/YYYY HH:MM:SS',
	90,
	1,
	1,
	32,
	'40')  
INSERT INTO pbcatown.PBCATEDT VALUES (
	'DD/MM/YY HH:MM:SS:FFFFFF',
	'DD/MM/YY HH:MM:SS:FFFFFF',
	90,
	1,
	1,
	32,
	'40')  
