/***********************************************************************
** Copyright Classification:
**
** Copyright (C) International Business Machines Corp., 1994.             
**                                                                        
**                                                                        
** DISCLAIMER OF WARRANTIES:                                              
** -------------------------                                              
** The following [enclosed] code is sample code created by IBM            
** Corporation.  This sample code is not part of any standard IBM product 
** and is provided to you solely for the purpose of assisting you in the  
** development of your applications.  The code is provided "AS IS",       
** without warranty of any kind.  IBM shall not be liable for any damages 
** arising out of your use of the sample code, even if they have been     
** advised of the possibility of such damages.                            
**
** Purpose: class sws_glbp
**    Spec: Simple Globe part
**--------------------------------------------------------------------
**
** Change Activity:  
***********************************************************************/

#ifndef _SWSGLBP_
#define _SWSGLBP_
#define INCL_WIN
#define INCL_GPI


#ifndef _ALTPOINT_
#include "AltPoint.h"         // Use C++ savvy XMPPoint and XMPRect
#endif
#ifndef _ARBITRAT_
#include "Arbitrat.h"
#endif
#ifndef _STORAGE_
#include "Storage.h"
#endif
#ifndef _FRAME_
#include "Frame.h"
#endif
#ifndef _FACET_
#include "Facet.h"
#endif
#ifndef _STORAGEU_
#include "StorageU.h"
#endif
#ifndef _SUVIEW_
#include "SUView.h"
#endif
#ifndef _XMPSESSN_
#include "XMPSessn.h"
#endif
#ifndef _DISPTCH_
#include "Disptch.h"
#endif
#ifndef _DISPATCHM_
#include "DisptchM.h"
#endif
#ifndef _EXCEPT_
#include "Except.h"
#endif
#ifndef _WINDOW_
#include "Window.h"
#endif
#ifndef _FOCI_
#include "Foci.h"
#endif
#ifndef _FOCUSSET_
#include "FocusSet.h"
#endif
#ifndef _CMDDEFS_
#include "CmdDefs.h"
#endif
#ifndef _ARBITRAT_
#include "Arbitrat.h"
#endif
#ifndef _ISOSTRING_
#include "ISOStr.h"
#endif
#ifndef _SHAPE_
#include "shape.h"
#endif
#ifndef _CANVAS_
#include "canvas.h"
#endif
#ifndef _TRNSFORM_
#include "Trnsform.h"
#endif
#ifndef _STDPROPS_
#include "StdProps.h"
#endif

#ifndef _STDTYPES_
#include "StdTypes.h"
#endif
#ifndef _XMPUTILS_
#include "XMPUtils.h"
#endif
#ifndef _ORDCOLL_
#include "OrdColl.h"
#endif
#ifndef _XMPTYPES_                         //Opendoc includes
#include "XMPTypes.h"
#endif
#ifndef _PART_
#include "Part.h"
#endif


#include "swsglbd.hpp"                        //class sws_glbd

#define kXMPKindswsglbp "Apple:Kind:swsglbp"         //Kind
#define kswsglbpID      "appl:swsglbp$class,1.0.0"  // Class ID

class sws_glbp : public XMPPart
{
public:
    friend MRESULT EXPENTRY fnTimerWndProc(HWND   hwnd, 
                                           LONG   msg,
                                           MPARAM mp1, 
                                           MPARAM mp2);
    sws_glbp();
   ~sws_glbp();
   static XMPPart* CreatePart();

   XMPMethod void IncrementRefCount();           // ----- ref counting -----
   XMPMethod void Release();
                                           // ----- DragAndDrop -----
   XMPVMethod void FulfillPromise(XMPStorageUnitView *promiseSUView);
   XMPVMethod void DropCompleted(XMPPart* destPart, 
                                 XMPDropResult dropResult);
   XMPVMethod MRESULT DragEnter(XMPDragItemIterator* dragInfo,
                        XMPFacet* facet,
                        XMPPoint where);
   XMPVMethod MRESULT DragWithin(XMPDragItemIterator* dragInfo,
                         XMPFacet* facet,
                         XMPPoint where);
   XMPVMethod void DragLeave(XMPFacet* facet,
                             XMPPoint where);
   XMPVMethod XMPDropResult Drop(XMPDragItemIterator* dropInfo,
                   XMPFacet* facet,
                   XMPPoint where);
                                          // ----- Embedding -----
   XMPVMethod void ContainingPartPropertiesChanged(XMPFrame* frame,
                                              XMPStorageUnit* propertyUnit);
   XMPVMethod XMPStorageUnit*  GetContainingPartProperties(XMPFrame* frame);
   XMPVMethod void RevealFrame(XMPFrame* embeddedFrame);
   XMPVMethod void EmbeddedFrameSpec(XMPFrame* embeddedFrame, 
                                XMPObjectSpec* spec);
   XMPVMethod XMPEmbeddedFramesIterator*  CreateEmbeddedFramesIterator();

                                                // ----- Frame -----
   XMPVMethod void AddDisplayFrame(XMPFrame* frame);
   XMPVMethod void AttachSourceFrame(XMPFrame* frame, XMPFrame* sourceFrame);
   XMPVMethod void RemoveDisplayFrame(XMPFrame* frame);
   XMPVMethod void CloseDisplayFrame(XMPFrame* frame);
   XMPVMethod void FrameShapeChanged(XMPFrame* frame);
   XMPVMethod void ViewTypeChanged(XMPFrame* frame);
   XMPVMethod void PresentationChanged(XMPFrame* frame);
   XMPVMethod void WritePartInfo(XMPPtr partInfo,
                                 XMPStorageUnitView* storageUnitView);
   XMPVMethod XMPPtr ReadPartInfo(XMPFrame* frame, 
                                  XMPStorageUnitView* storageUnitView);
   XMPVMethod XMPID  Open(XMPFrame* frame);
   XMPVMethod XMPFrame* CreateEmbeddedFrame(XMPFrame* containingFrame,
                                  XMPShape* frameShape,
                                  XMPTransform* externalTransform,
                                  XMPPart* embedPart,
                                  XMPTypeToken viewType,
                                  XMPTypeToken presentation,
                                  XMPID frameGroupID,
                                  XMPBoolean isOverlaid);
   XMPVMethod void RemoveEmbeddedFrame(XMPFrame* embeddedFrame);
   XMPVMethod XMPShape* RequestFrameShape(XMPFrame* embeddedFrame, 
                                          XMPShape* frameShape);
   XMPVMethod void UsedShapeChanged(XMPFrame* embeddedFrame);
   XMPVMethod XMPShape* AdjustBorderShape(XMPFrame* embeddedFrame, 
                                          XMPShape* shape);
 
                                                  // ----- Facet -----
   XMPVMethod void FacetAdded(XMPFacet* facet);
   XMPVMethod void FacetRemoved(XMPFacet* facet);
   XMPVMethod void ClipShapeChanged(XMPFacet* facet);
   XMPVMethod void ExternalTransformChanged(XMPFacet* facet);

                                                   // ----- Imaging -----
   XMPVMethod void Draw(XMPFacet* facet, XMPShape* invalidShape);
   XMPVMethod void CanvasUpdated(XMPCanvas* canvas);
   XMPVMethod void HighlightChanged(XMPFrame* frame);
   XMPVMethod XMPULong GetPrintResolution(XMPFrame* frame);

                                                    // ----- Linking -----
   XMPVMethod XMPLink* CreateLink(XMPPtr data, XMPULong size);
   XMPVMethod void LinkUpdated(XMPLink* updatedLink, XMPChangeID id);
   XMPVMethod void RevealLink(XMPLinkSource* linkSource);
   XMPVMethod void EmbeddedFrameChanged(XMPFrame* frame, XMPChangeID change);
   XMPVMethod void LinkStatusChanged(XMPFrame* frame);

                                            // ----- Memory Management -----
   XMPVMethod XMPSize Purge(XMPSize size);

                                               // ----- Part Activation -----
   XMPVMethod XMPBoolean BeginRelinquishFocus(XMPTypeToken focus,
                                    XMPFrame* ownerFrame,
                                    XMPFrame* proposedFrame);
   XMPVMethod void CommitRelinquishFocus(XMPTypeToken focus,
                                XMPFrame* ownerFrame,
                                XMPFrame* proposedFrame);
   XMPVMethod void AbortRelinquishFocus(XMPTypeToken focus,
                               XMPFrame* ownerFrame,
                               XMPFrame* proposedFrame);
   XMPVMethod void FocusAcquired(XMPTypeToken focus, XMPFrame* ownerFrame);
   XMPVMethod void FocusLost(XMPTypeToken focus, XMPFrame* oldOwner);

                                        // ----- Storage -----
   XMPVMethod void Externalize();
   XMPVMethod void CloneInto(XMPDraftKey key,
                             XMPStorageUnit* storageUnit, 
                             XMPStorageUnit* initiatingFrameSU);

                                         // ----- Binding -----
   XMPVMethod void ExternalizeKinds(XMPTypeSet* kindset);
   XMPVMethod void ChangeKind(XMPType kind);

                                          // ----- UI Events -----
   XMPVMethod XMPBoolean HandleEvent(XMPEventData event, 
                                     XMPFrame* frame, XMPFacet* facet);
   XMPVMethod void MouseEnter(XMPFacet* facet, XMPPoint where);
   XMPVMethod void MouseWithin(XMPFacet* facet, XMPPoint where);
   XMPVMethod void MouseLeave(XMPFacet* facet);
   XMPVMethod void AdjustMenus(XMPFrame* frame);

   // ----- Undo -----
   XMPVMethod void UndoAction(XMPActionData actionState);
   XMPVMethod void RedoAction(XMPActionData actionState);
   XMPVMethod void DisposeActionState(XMPActionData actionState,
                              XMPDoneState doneState);
   XMPVMethod void WriteActionState(XMPPtr actionState,
                            XMPStorageUnitView* storageUnitView);
   XMPVMethod XMPPtr ReadActionState(XMPStorageUnitView* storageUnitView);
   XMPVMethod void   ActivateFrame(XMPFrame* frame);
   XMPVMethod void   Timer();
protected:
   XMPVMethod  void InitPart(XMPStorageUnit* storageUnit);
   XMPVMethod  void InitPartFromStorage(XMPStorageUnit* storageUnit);
   XMPVMethod  void resize(XMPFrame *frame);
   XMPVMethod  void Initialize();
   XMPVMethod  void display(XMPFacet *facet,
                            int       type);
private:
   sws_glbd           *_globe;
   HWND                _hwndTimer;
   XMPBoolean          _fInitialized;
   OrderedCollection*  _fDisplayFrames;

   XMPSession*         _fSession;
   XMPFocusSet*        _fFocusSet;
   XMPTypeToken        _fSelectionFocus;
   XMPTypeToken        _fMenuFocus;
   XMPTypeToken        _fKeyFocus;
   XMPStorageUnit*     _fswsglbpSU;
};

class PartInfoRec{
 public:
   PartInfoRec() { _fIsActive = kXMPFalse; _fNeedsActivating = kXMPFalse;}
   XMPBoolean  _fIsActive;        // Does this frame have its focus set?
   XMPBoolean  _fNeedsActivating; // should this be activated
                                  // when its window is activated?
};

#endif
