/***********************************************************************
** Copyright Classification:
**
** Copyright (C) International Business Machines Corp., 1994.             
**                                                                        
**                                                                        
** DISCLAIMER OF WARRANTIES:                                              
** -------------------------                                              
** The following [enclosed] code is sample code created by IBM            
** Corporation.  This sample code is not part of any standard IBM product 
** and is provided to you solely for the purpose of assisting you in the  
** development of your applications.  The code is provided "AS IS",       
** without warranty of any kind.  IBM shall not be liable for any damages 
** arising out of your use of the sample code, even if they have been     
** advised of the possibility of such damages.                            
**                                                                        
**
** Purpose: class sws_glbp Methods
**    Spec: Simple Globe part
**--------------------------------------------------------------------
**
** Change Activity:  
**      15May94 Created: redpath
***********************************************************************/
#include "string.h"                   
#include "swsglbp.hpp"                    //class sws_glbp
extern void  myprintf(char *format);

#define RATE 150L
const char *pszClassName = "GlobeTimerWindow";
extern MRESULT EXPENTRY fnTimerWndProc(HWND hwnd, 
                                       LONG msg,
                                       MPARAM mp1, MPARAM mp2);

//-----------------------------------------------------------
// CreatePart: Standard Exported entry point to create part
//             instance but no persistent storage associated
//             with it yet for OpenDoc. InitPart is used to
//             create persistent storage and setup OpenDoc
//             structures that the part needs.
//------------------------------------------------------------
extern "C" XMPPart* EXPENTRY CreatePart()
{
   return new sws_glbp();
}



//-----------------------------------------------------------
// sws_glbp: Constructor for Globe Part Class. Create instance of part
//           allocated and initialize the data to indicate that
//           OpenDoc setup has not been obtained yet.
//-----------------------------------------------------------
sws_glbp::sws_glbp()
{
  _fInitialized   = kXMPFalse;
  _fswsglbpSU     = 0;
  _fDisplayFrames = 0;
  _globe          = 0;
}



//-----------------------------------------------------------
// sws_glbp: destructor for Globe Part Class
//-----------------------------------------------------------
sws_glbp::~sws_glbp()
{
  if (_globe)
     delete(_globe);
  WinDestroyWindow(_hwndTimer);
  XMPDeleteObject(_fDisplayFrames);// Release the display frames collection.
                          // Deletion of memory used by the object will be
                          // reclaimed when the shell deletes the
                          // instantiation.
  XMPReleaseObject(_fswsglbpSU);
}


//-----------------------------------------------------------
//
//-----------------------------------------------------------
void sws_glbp::resize(XMPFrame *frame)
{HRGN      hrgnFrame;
 RECTL     rclFrame;
 HPS       screenps;
 HRGN       hrgnUsed;
 POINTL    ptl;

 hrgnFrame= (HRGN)frame->GetFrameShape()->GetPlatformShape(kXMPOS2PM);
 ptl= frame->GetInternalTransform()->TransformPoint(XMPPoint(0,0)).AsPOINTL();

  screenps = WinGetScreenPS(HWND_DESKTOP);
  GpiQueryRegionBox(screenps,hrgnFrame,&rclFrame);
 _globe->size(&ptl,&rclFrame,&hrgnUsed);

  XMPShape *requestedShape = new XMPShape();    //Set Frame Shape
  XMPRect frameRect(rclFrame);
  requestedShape->SetRectangle(&frameRect);
  frame->RequestFrameShape(requestedShape);

  requestedShape = new XMPShape;
  requestedShape->SetQDRegion(hrgnUsed);
  frame->ChangeUsedShape(requestedShape);
}


//-----------------------------------------------------------
// IncrementRefCount: Increments the reference count of the
//                    container XMPContainer.
//-----------------------------------------------------------
void sws_glbp::IncrementRefCount()
{
  XMPRefCntObject::IncrementRefCount();
}




//-----------------------------------------------------------
// Release: Release decrements the container ref count. If the
//          ref count is zero get storage unit draft and
//          release the part.
//-----------------------------------------------------------
void sws_glbp::Release()
{
   XMPRefCntObject::Release();
   if (this->GetRefCount() == 0)
      this->GetStorageUnit()->GetDraft()->ReleasePart(this);
}



//-----------------------------------------------------------
// Initialize: Convenience function to initialize a OpenDoc
//             instance of the globe part from creating a new one
//             or from a dormant instance from storage.
//       Spec: The session must be obtained already
//-----------------------------------------------------------
void sws_glbp:: Initialize()
{HAB       hab = WinQueryAnchorBlock(HWND_DESKTOP);
 CLASSINFO classInfo;

    this->_fInitialized = kXMPTrue;
   _fDisplayFrames = new OrderedCollection;   // Create an empty collection 
                                             // for storing the list 

   _fSelectionFocus    = _fSession->Tokenize(kXMPSelectionFocus);
   _fMenuFocus         = _fSession->Tokenize(kXMPMenuFocus);
   _fKeyFocus          = _fSession->Tokenize(kXMPKeyFocus);

   _fFocusSet          = new XMPFocusSet();
   _fFocusSet->InitFocusSet();
   _fFocusSet->Add(_fSelectionFocus);
   _fFocusSet->Add(_fMenuFocus);
   _fFocusSet->Add(_fKeyFocus);

   _globe = new sws_glbd(WinQueryFocus(HWND_DESKTOP));  //For now!

   if (!WinQueryClassInfo(hab, pszClassName, &classInfo))
      WinRegisterClass(hab, pszClassName, (PFNWP)fnTimerWndProc, 0, 4);

   _hwndTimer   = WinCreateWindow(
                      HWND_OBJECT,           // parent
                      pszClassName,          // window class
                      0,                     // window style
                      NULL,                  // name
                      0, 0, 0, 0,            // position & size
                      0,                     // owner
                      HWND_TOP,              // sibling
                      0,                     // id
                      this,                  // control data
                      NULL);                 // presentation parameters
 if (_hwndTimer==(HWND)0)
   DosBeep(1000,1000);
}




//-----------------------------------------------------------
// InitPart: Called to create a storage instance of the
//           Globe Part in OpenDoc after the class instance
//           has been constructed.
//-----------------------------------------------------------
void sws_glbp::InitPart(XMPStorageUnit* storageUnit)
{
   if (_fInitialized)
      return;

   XMPPersistentObject::InitPersistentObject(storageUnit);
   _fSession = storageUnit->GetSession();
   this->Initialize();

   storageUnit->AddProperty(kXMPPropContents)->AddValue(kXMPKindswsglbp);   
   _fswsglbpSU = storageUnit->GetDraft()->CreateStorageUnit();
   _fswsglbpSU->AddProperty(kXMPPropDisplayFrames)->AddValue(kXMPID);        
}





//-----------------------------------------------------------
// InitPartFromStorage: Called to wakeup a dormant part
//                      It will obtain the storage unit.
//-----------------------------------------------------------
void sws_glbp::InitPartFromStorage(XMPStorageUnit* storageUnit)
{
   if (_fInitialized)
      return;

   XMPPersistentObject::InitPersistentObjectFromStorage(storageUnit);

   _fSession = storageUnit->GetSession();
   this-> Initialize();
   XMPULong valueSize, offset;
   XMPStorageUnitRef aSURef;
   XMPFrame* aFrame;
   XMPStorageUnit* su;

   su = this->GetStorageUnit();
   su->Focus(kXMPPropContents,kXMPPosSame,kXMPKindswsglbp,1,kXMPPosFirstSib);
   su->GetValue(sizeof(XMPStorageUnitRef),&aSURef);
   _fswsglbpSU = 
        su->GetDraft()->GetStorageUnit(su->GetIDFromStorageUnitRef(aSURef));
   su = _fswsglbpSU;
   
   su->Focus(kXMPPropDisplayFrames,kXMPPosUndefined,0,1,kXMPPosFirstSib);
   valueSize = su->GetSize();
   for (offset = 0; offset < valueSize; offset += sizeof(XMPStorageUnitRef))
   {
      su->SetOffset(offset);
      su->GetValue(sizeof(XMPStorageUnitRef), (XMPValue)&aSURef);
      
      TRY
      
         aFrame = su->GetDraft()->GetFrame(su->GetIDFromStorageUnitRef(aSURef));
         _fDisplayFrames->AddLast((ElementType)aFrame);
         this->resize(aFrame);
      
      CATCH_ALL
      
         aFrame = kXMPNULL;

      ENDTRY
   }
   
 // We should minimize the frame shape here, but we can't because I think that
 // the fPart and fPartInfo for the frame hasn't been set up yet.
 // this->MinimizeFrameShape(dispFrame);   
}




//*********From Imaging protocol****************8

void sws_glbp::display(XMPFacet* facet,
                       int       type)
{HPS       hps;
 HRGN      hrgnClip;
 XMPShape* clipShape = new XMPShape;
 POINTL    ptl;

 hps = facet->GetCanvas()->GetPlatformCanvas();
 clipShape->CopyFrom(facet->GetAggregateClipShape());
 hrgnClip = clipShape->Transform(facet->GetContentTransform())->GetQDRegion();
 ptl= facet->GetContentTransform()->TransformPoint(XMPPoint(0,0)).AsPOINTL();

  GpiSavePS(hps);
  if (type==0)
    _globe->draw(hps,&ptl,hrgnClip);
  else
    _globe->globe(hps,&ptl,hrgnClip);
  GpiRestorePS(hps,-1);
  delete clipShape;
}


//-------------------------------------------------------------------------
// Draw: XMPFacet method, invalidShape is in frame coordinates
//-------------------------------------------------------------------------
void sws_glbp:: Draw(XMPFacet* facet, XMPShape* invalidShape)
{
 this->display(facet,0);
}





//-------------------------------------------------------------------------
// ContainingPartPropertiesChanged:
//-------------------------------------------------------------------------
void sws_glbp::ContainingPartPropertiesChanged(XMPFrame* displayFrame,
                                     XMPStorageUnit* propertyUnit)
{
 XMPUnused(displayFrame);
 XMPUnused(propertyUnit);
}


//-------------------------------------------------------------------------
// GetContainingPartProperties: XMPPart method, inform changes of
//                              content properties of its proxy for this
//                              part.
//-------------------------------------------------------------------------
XMPStorageUnit* sws_glbp::GetContainingPartProperties(XMPFrame* displayFrame)
{
   XMPUnused(displayFrame);
   THROW(kXMPErrCannotEmbed);
   return nil;
}



//-------------------------------------------------------------------------
// RevealFrame: XMPPart method, asking a part to make an embedded frame
//              visible.
//-------------------------------------------------------------------------
void sws_glbp::RevealFrame(XMPFrame* embeddedFrame)
{
 XMPUnused(embeddedFrame);

  THROW(kXMPErrCannotEmbed);
}


//-------------------------------------------------------------------------
// EmbeddedFrameSpec: XMPPart method, create object specifier for embedded
//                    frame.
//-------------------------------------------------------------------------
void sws_glbp::EmbeddedFrameSpec(XMPFrame* embeddedFrame, XMPObjectSpec* spec)
{
  XMPUnused(embeddedFrame);
  XMPUnused(spec);

  THROW(kXMPErrCannotEmbed);
}


//-------------------------------------------------------------------------
// CreateEmbeddedFrameIterator: XMPPart method,
//                              Create an object which will iterate all
//                              embedded frame sof this part.
//-------------------------------------------------------------------------
XMPEmbeddedFramesIterator* sws_glbp::CreateEmbeddedFramesIterator()
{
   THROW(kXMPErrCannotEmbed);
   // return new XMPEmbeddedFramesIterator(this);
   return nil;
}


//-------------------------------------------------------------------------
// AddDisplayFrame:  No documentation?
//-------------------------------------------------------------------------
void sws_glbp::AddDisplayFrame(XMPFrame* frame)
{
   PartInfoRec* pInfo = new PartInfoRec;
   if (frame->IsRoot())
      pInfo->_fNeedsActivating = kXMPTrue;

   frame->SetPartInfo((XMPInfoType) pInfo);

   _fDisplayFrames->AddLast(frame);
   frame->IncrementRefCount();
}





//-------------------------------------------------------------------------
// AttachSourceFrame:   No documentation?
//-------------------------------------------------------------------------
void sws_glbp::AttachSourceFrame(XMPFrame* frame, XMPFrame* sourceFrame)
{
 XMPUnused(frame);
 XMPUnused(sourceFrame);
}



//-------------------------------------------------------------------------
// RemoveDisplayFrame:   No documentation?
//-------------------------------------------------------------------------
void sws_glbp::RemoveDisplayFrame(XMPFrame* frame)
{
   if (_fDisplayFrames->Contains(frame))
   {
      PartInfoRec* pInfo = (PartInfoRec*) frame->GetPartInfo();
      frame->SetPartInfo((XMPInfoType) kXMPNULL);
      delete pInfo;
      _fDisplayFrames->Remove(frame);
      frame->Release();
   }
   else
      THROW(kXMPErrInvalidFrame);
}



//-------------------------------------------------------------------------
// CloseDisplayFrame:  No documentation?
//-------------------------------------------------------------------------
void sws_glbp::CloseDisplayFrame(XMPFrame* frame)
{
   if (_fDisplayFrames->Contains(frame))
   {
      _fSession->GetArbitrator()->RelinquishFocusSet(_fFocusSet, frame);

      PartInfoRec* pInfo = (PartInfoRec*) frame->GetPartInfo();
      frame->SetPartInfo((XMPInfoType) kXMPNULL);
      delete pInfo;
      _fDisplayFrames->Remove(frame);
      XMPReleaseObject(frame);
   }
   else
      THROW(kXMPErrInvalidFrame);
}


//-------------------------------------------------------------------------
// FrameShapeChanged:  No documentation?
//-------------------------------------------------------------------------
void sws_glbp::FrameShapeChanged(XMPFrame* frame)
{
  this->resize( frame);
   XMPFrameFacetIterator* facets = frame->CreateFacetIterator();
   for (XMPFacet* facet = facets->First();
      facets->IsNotComplete();
      facet = facets->Next())
   {
      XMPShape* activeShape = new XMPShape;
      activeShape->CopyFrom(frame->GetUsedShape());
      facet->ChangeActiveShape(activeShape);
   }
   delete facets;
}





//-------------------------------------------------------------------------
// ViewTypeChanged:
//-------------------------------------------------------------------------
void sws_glbp::ViewTypeChanged(XMPFrame* frame)
{
 XMPUnused(frame);
}



//-------------------------------------------------------------------------
// PresentationChanged:
//-------------------------------------------------------------------------
void sws_glbp::PresentationChanged(XMPFrame* frame)
{
XMPUnused(frame);
}



//-------------------------------------------------------------------------
// 
//-------------------------------------------------------------------------
void sws_glbp::WritePartInfo(XMPPtr partInfo,
                        XMPStorageUnitView* storageUnitView)
{
 if (!partInfo)
    return;
 XMPBoolean needsActivating = ((PartInfoRec*)partInfo)->_fNeedsActivating ||
                              ((PartInfoRec*)partInfo)->_fIsActive;
 storageUnitView->SetValue(sizeof(XMPBoolean),
                          (XMPValue)&needsActivating);
}



//-------------------------------------------------------------------------
// 
//-------------------------------------------------------------------------
XMPPtr sws_glbp::ReadPartInfo(XMPFrame* frame, 
                              XMPStorageUnitView* storageUnitView)
{PartInfoRec* partInfo;
 XMPBoolean   needsActivating;

   XMPUnused(frame);
   if (!storageUnitView->GetSize())
      return ((XMPPtr)kXMPNULL);
   partInfo = new PartInfoRec;
   storageUnitView->GetValue(sizeof(XMPBoolean),
                             (XMPValue)&(needsActivating));
   partInfo->_fNeedsActivating = needsActivating;
   return partInfo;
}


//-------------------------------------------------------------------------
// 
//-------------------------------------------------------------------------
XMPID sws_glbp::Open(XMPFrame* frame)
{
   XMPUnused(frame);

   return 0;
}





//-------------------------------------------------------------------------
//
//-------------------------------------------------------------------------
XMPBoolean sws_glbp::BeginRelinquishFocus(XMPTypeToken focus,
                                 XMPFrame* ownerFrame,
                                 XMPFrame* proposedFrame)
{
XMPUnused(focus);
XMPUnused(ownerFrame);
XMPUnused(proposedFrame);

   return kXMPTrue;
}



//-------------------------------------------------------------------------
//
//-------------------------------------------------------------------------
void sws_glbp::CommitRelinquishFocus(XMPTypeToken focus,
                              XMPFrame* ownerFrame,
                              XMPFrame* proposedFrame)
{
XMPUnused(focus);
XMPUnused(ownerFrame);
XMPUnused(proposedFrame);
   this-> FocusLost( focus, ownerFrame);
}


//-------------------------------------------------------------------------
//
//-------------------------------------------------------------------------
void sws_glbp::AbortRelinquishFocus(XMPTypeToken focus,
                             XMPFrame* ownerFrame,
                             XMPFrame* proposedFrame)
{
XMPUnused(focus);
XMPUnused(ownerFrame);
XMPUnused(proposedFrame);
}


//-------------------------------------------------------------------------
//
//-------------------------------------------------------------------------
void sws_glbp::FocusAcquired(XMPTypeToken focus, XMPFrame* ownerFrame)
{
   if (focus == _fSelectionFocus) {
      PartInfoRec* pInfo = (PartInfoRec*) ownerFrame->GetPartInfo();
      pInfo->_fIsActive = kXMPTrue;
   }
}


//-------------------------------------------------------------------------
//
//-------------------------------------------------------------------------
void sws_glbp::FocusLost(XMPTypeToken focus, 
                         XMPFrame    *oldOwner)
{
   if (focus == _fSelectionFocus) {
     PartInfoRec* pInfo = (PartInfoRec*) oldOwner->GetPartInfo();
     pInfo->_fIsActive = kXMPFalse;
   }
}





//************ From UI Events protocol***************


void sws_glbp::ActivateFrame(XMPFrame* frame)
{
   PartInfoRec* pInfo = (PartInfoRec*) frame->GetPartInfo();

   if (!(pInfo->_fIsActive))
   {
      XMPBoolean succeeded = false;

      succeeded = _fSession->GetArbitrator()->RequestFocusSet(_fFocusSet,
                                                              frame);

      if (succeeded)
      {
         this->FocusAcquired(_fSelectionFocus, frame);
         this->FocusAcquired(_fMenuFocus, frame);
         this->FocusAcquired(_fKeyFocus, frame);
      }
   }
}


//-------------------------------------------------------------------------
//
//-------------------------------------------------------------------------
XMPBoolean sws_glbp::HandleEvent(XMPEventData event, 
                                 XMPFrame* frame, 
                                 XMPFacet* facet)
{ XMPUnused(facet);
  XMPBoolean handled = kXMPFalse;

  switch( event-> what) {
     case kXMPEvtMouseDown: 
      if (event->msg != WM_BUTTON1DOWN)        
          break;
      if (!facet->GetWindow()->IsActive())
        facet->GetWindow()->Select();
      this->ActivateFrame(frame);
     break;
  case kXMPEvtActivate:
    {
     PartInfoRec* pInfo = (PartInfoRec*) frame->GetPartInfo();
     if (SHORT1FROMMP(event->mp1) != 0){
        if (pInfo->_fNeedsActivating){
           this->ActivateFrame(frame);
           pInfo->_fNeedsActivating = kXMPFalse;
        }
      }
     else{
      if (frame==_fSession->GetArbitrator()->GetFocusOwner(_fSelectionFocus))
         pInfo->_fNeedsActivating = kXMPTrue;
      else
        pInfo->_fNeedsActivating = kXMPFalse;
      }
     }
     break;
  default :
     break;
  }
   return kXMPFalse;
}



//-------------------------------------------------------------------------
//
//-------------------------------------------------------------------------
void sws_glbp::MouseEnter(XMPFacet* facet, XMPPoint where)
{
XMPUnused(facet);
XMPUnused(where);
}





//-------------------------------------------------------------------------
//
//-------------------------------------------------------------------------
void sws_glbp::MouseWithin(XMPFacet* facet, XMPPoint where)
{
XMPUnused(facet);
XMPUnused(where);
}



//-------------------------------------------------------------------------
//
//-------------------------------------------------------------------------
void sws_glbp::MouseLeave(XMPFacet* facet)
{
XMPUnused(facet);
}



//-------------------------------------------------------------------------
//
//-------------------------------------------------------------------------
void sws_glbp::AdjustMenus(XMPFrame* frame)
{
  XMPUnused(frame);
}




//--------------------------------------------------
// Timer: process timer message
//--------------------------------------------------
void sws_glbp::Timer()
{
   OrderedCollectionIterator frames(_fDisplayFrames);
   for (XMPFrame* frame = (XMPFrame*)frames.First(); 
      frames.IsNotComplete();
      frame = (XMPFrame*)frames.Next())
   {
      XMPFrameFacetIterator* facets = frame->CreateFacetIterator();
      for (XMPFacet* facet = facets->First();
         facets->IsNotComplete();
         facet = facets->Next())
      {
         this->display( facet, 1);
      }
      delete facets;
   }
}




MRESULT EXPENTRY fnTimerWndProc(HWND hwnd, 
                                LONG msg, 
                                MPARAM mp1, MPARAM mp2)
{sws_glbp *part;

   switch (msg) {
   case WM_CREATE:
      WinSetWindowPtr(hwnd, 0, mp1);
      WinStartTimer(WinQueryAnchorBlock(hwnd), hwnd, 0, RATE);
      return 0;
   case WM_DESTROY:
      WinStopTimer(WinQueryAnchorBlock(hwnd), hwnd, 0);
      return 0;
   case WM_TIMER:
      {
      part = (sws_glbp *)WinQueryWindowPtr(hwnd, 0);
      part->Timer();
      return 0;
      }
   default: 
      return WinDefWindowProc(hwnd, msg, mp1, mp2);
   } 
}
