/******************************************************************************/
/*                                                                            */
/* COPYRIGHT:                                                                 */
/* ----------                                                                 */
/* Copyright (C) International Business Machines Corp., 1994.                 */
/* Copyright:(C) Apple Computer, Inc., 1994                                   */
/*                                                                            */  
/* DISCLAIMER OF WARRANTIES:                                                  */
/* -------------------------                                                  */
/* The following [enclosed] code is sample code created by IBM                */
/* Corporation.  This sample code is not part of any standard IBM product     */
/* and is provided to you solely for the purpose of assisting you in the      */
/* development of your applications.  The code is provided "AS IS",           */
/* without warranty of any kind.  IBM shall not be liable for any damages     */
/* arising out of your use of the sample code, even if they have been         */
/* advised of the possibility of such damages.                                */
/*                                                                            */
/******************************************************************************/
/*
   File:    ibp.cpp

   Contains:   Implementation of class ImplBasePart

   Written by: Joshua Susser
*/

#define INCL_GPI
#define INCL_WINSTDDRAG

#ifndef _ALTPOINT_
#include "AltPoint.h"         // Use C++ savvy XMPPoint and XMPRect
#endif

#ifndef _IBP_
#include "ibp.h"
#endif

#ifndef _ARBITRAT_
#include "Arbitrat.h"
#endif

#ifndef _STORAGE_
#include "Storage.h"
#endif

#ifndef _FRAME_
#include "Frame.h"
#endif

#ifndef _FACET_
#include "Facet.h"
#endif

#ifndef _STORAGEU_
#include "StorageU.h"
#endif

#ifndef _XMPSESSN_
#include "XMPSessn.h"
#endif

#ifndef _EXCEPT_
#include "Except.h"
#endif

#ifndef _SHAPE_
#include "shape.h"
#endif

#ifndef _CANVAS_
#include "canvas.h"
#endif

#ifndef _TRNSFORM_
#include "Trnsform.h"
#endif


//==============================================================================
// Constants
//==============================================================================
#define SSREMOVEWORKAROUND


//==============================================================================
// Scalar Types
//==============================================================================


//==============================================================================
// ImplBasePart
//==============================================================================

ImplBasePart::ImplBasePart() 
{
}

ImplBasePart::~ImplBasePart()
{
}

void ImplBasePart::IncrementRefCount()
{
   XMPRefCntObject::IncrementRefCount();
}

void ImplBasePart::Release()
{
   XMPRefCntObject::Release();
   if (this->GetRefCount() == 0)
      this->GetStorageUnit()->GetDraft()->ReleasePart(this);
}

void ImplBasePart::InitPart(XMPStorageUnit* storageUnit)
{
   if (fInitialized)
      return;
   
   XMPPersistentObject::InitPersistentObject(storageUnit);
   
   fSession = storageUnit->GetSession();
}

void ImplBasePart::InitPartFromStorage(XMPStorageUnit* storageUnit)
{
   if (fInitialized)
      return;
   
   XMPPersistentObject::InitPersistentObjectFromStorage(storageUnit);

   fSession = storageUnit->GetSession();
}

//-------------------------------------------------------------------------
// From DragAndDrop protocol
//-------------------------------------------------------------------------

// --- FulfillPromise ---

void ImplBasePart::FulfillPromise(XMPStorageUnitView *promiseSUView)
{
XMPUnused(promiseSUView);
}

// --- DropCompleted ---

void ImplBasePart::DropCompleted(XMPPart* destPart,
                        XMPDropResult dropResult)
{
XMPUnused(destPart);
XMPUnused(dropResult);
}

// --- DragEnter ---
//dwf changed return value to MRESULT from void
MRESULT ImplBasePart::DragEnter(XMPDragItemIterator* dragInfo,
                     XMPFacet* facet,
                     XMPPoint where)
{
XMPUnused(dragInfo);
XMPUnused(facet);
XMPUnused(where);
return MRFROM2SHORT (DOR_NEVERDROP, DO_UNKNOWN);
}

// --- DragWithin ---
//dwf changed from void to mresult
MRESULT ImplBasePart::DragWithin(XMPDragItemIterator* dragInfo,
                     XMPFacet* facet,
                     XMPPoint where)
{
XMPUnused(dragInfo);
XMPUnused(facet);
XMPUnused(where);
return MRFROM2SHORT (DOR_NEVERDROP, DO_UNKNOWN);
}

// --- DragLeave ---

void ImplBasePart::DragLeave(XMPFacet* facet,
                     XMPPoint where)
{
XMPUnused(facet);
XMPUnused(where);
}

// --- Drop ---

XMPDropResult ImplBasePart::Drop(XMPDragItemIterator* dropInfo,
                        XMPFacet* facet,
                        XMPPoint where)
{
XMPUnused(dropInfo);
XMPUnused(facet);
XMPUnused(where);
   return kXMPDropFail;
}

//-------------------------------------------------------------------------
// From Embedding protocol
//-------------------------------------------------------------------------

// --- ContainingPartPropertiesChanged ---

void ImplBasePart::ContainingPartPropertiesChanged(XMPFrame* displayFrame,
                                     XMPStorageUnit* propertyUnit)
{
XMPUnused(displayFrame);
XMPUnused(propertyUnit);
}

   // ********* for containing parts *********

// --- GetContainingPartProperties ---

XMPStorageUnit* ImplBasePart::GetContainingPartProperties(XMPFrame* displayFrame)
{
XMPUnused(displayFrame);
   THROW(kXMPErrCannotEmbed);
   return nil;
}

// --- RevealFrame ---

void ImplBasePart::RevealFrame(XMPFrame* embeddedFrame)
{
XMPUnused(embeddedFrame);

   THROW(kXMPErrCannotEmbed);
}

// --- EmbeddedFrameSpec ---

void ImplBasePart::EmbeddedFrameSpec(XMPFrame* embeddedFrame, XMPObjectSpec* spec)
{
XMPUnused(embeddedFrame);
XMPUnused(spec);

   THROW(kXMPErrCannotEmbed);
}

// --- CreateEmbeddedFramesIterator ---

XMPEmbeddedFramesIterator* ImplBasePart::CreateEmbeddedFramesIterator()
{
   THROW(kXMPErrCannotEmbed);
   // return new XMPEmbeddedFramesIterator(this);
   return nil;
}


//-------------------------------------------------------------------------
// from Frame protocol:
//-------------------------------------------------------------------------

// --- AddDisplayFrame ---

void ImplBasePart::AddDisplayFrame(XMPFrame* frame)
{
XMPUnused(frame);
}

// --- AttachSourceFrame ---

void ImplBasePart::AttachSourceFrame(XMPFrame* frame, XMPFrame* sourceFrame)
{
XMPUnused(frame);
XMPUnused(sourceFrame);
}

// --- RemoveDisplayFrame ---

void ImplBasePart::RemoveDisplayFrame(XMPFrame* frame)
{
XMPUnused(frame);
}

// --- CloseDisplayFrame ---

void ImplBasePart::CloseDisplayFrame(XMPFrame* frame)
{
XMPUnused(frame);
}

// --- FrameShapeChanged ---

void ImplBasePart::FrameShapeChanged(XMPFrame* frame)
{
XMPUnused(frame);
}

// --- ViewTypeChanged ---

void ImplBasePart::ViewTypeChanged(XMPFrame* frame)
{
XMPUnused(frame);
}

// --- PresentationChanged ---

void ImplBasePart::PresentationChanged(XMPFrame* frame)
{
XMPUnused(frame);
}

// --- WritePartInfo ---

void ImplBasePart::WritePartInfo(XMPPtr partInfo,
                        XMPStorageUnitView* storageUnitView)
{
XMPUnused(partInfo);
XMPUnused(storageUnitView);
}

// --- ReadPartInfo ---

XMPPtr ImplBasePart::ReadPartInfo(XMPFrame* frame, XMPStorageUnitView* storageUnitView)
{
XMPUnused(frame);
XMPUnused(storageUnitView);
   return nil;
}

// --- Open ---

XMPID ImplBasePart::Open(XMPFrame* frame)
{
   XMPUnused(frame);

   return 0;
}

   // ********* for containing parts *********

// --- CreateEmbeddedFrame ---

XMPFrame* ImplBasePart::CreateEmbeddedFrame(XMPFrame* containingFrame,
                                XMPShape* frameShape,
                                XMPTransform* externalTransform,
                                XMPPart* embedPart,
                                XMPTypeToken viewType,
                                XMPTypeToken presentation,
                                XMPID frameGroupID,
                                XMPBoolean isOverlaid)
{
XMPUnused(containingFrame);
XMPUnused(frameShape);
XMPUnused(externalTransform);
XMPUnused(embedPart);
XMPUnused(viewType);
XMPUnused(presentation);
XMPUnused(frameGroupID);
XMPUnused(isOverlaid);

   THROW(kXMPErrCannotEmbed);
   return nil;
}
   
// --- RemoveEmbeddedFrame ---

void ImplBasePart::RemoveEmbeddedFrame(XMPFrame* embeddedFrame)
{
XMPUnused(embeddedFrame);

   THROW(kXMPErrCannotEmbed);
}

// --- RequestFrameShape ---

XMPShape* ImplBasePart::RequestFrameShape(XMPFrame* embeddedFrame, XMPShape* frameShape)
{
XMPUnused(embeddedFrame);
XMPUnused(frameShape);

   THROW(kXMPErrCannotEmbed);
   return nil;
}

// --- UsedShapeChanged ---

void ImplBasePart::UsedShapeChanged(XMPFrame* embeddedFrame)
{
XMPUnused(embeddedFrame);
}

// --- AdjustBorderShape ---

XMPShape* ImplBasePart::AdjustBorderShape(XMPFrame* embeddedFrame, XMPShape* shape)
{
XMPUnused(embeddedFrame);

   return shape;
}

//-------------------------------------------------------------------------
// From Facet protocol
//-------------------------------------------------------------------------

// --- FacetAdded ---

void ImplBasePart::FacetAdded(XMPFacet* facet)
{
XMPUnused(facet);
}

// --- FacetRemoved ---

void ImplBasePart::FacetRemoved(XMPFacet* facet)
{
XMPUnused(facet);
}

// --- ClipShapeChanged ---

void ImplBasePart::ClipShapeChanged(XMPFacet* facet)
{
XMPUnused(facet);
}

// --- ExternalTransformChanged ---

void ImplBasePart::ExternalTransformChanged(XMPFacet* facet)
{
XMPUnused(facet);
}

//-------------------------------------------------------------------------
// From Imaging protocol
//-------------------------------------------------------------------------

// --- Draw ---

void ImplBasePart::Draw(XMPFacet* facet, XMPShape* invalidShape)
{
XMPUnused(facet);
XMPUnused(invalidShape);
}

// --- CanvasUpdated ---

void ImplBasePart::CanvasUpdated(XMPCanvas* canvas)
{
XMPUnused(canvas);
}

// --- HighlightChanged ---

void ImplBasePart::HighlightChanged(XMPFrame* frame)
{
XMPUnused(frame);
}

// --- GetPrintResolution ---

XMPULong ImplBasePart::GetPrintResolution(XMPFrame* frame)
{
XMPUnused(frame);

   return 0;
}

//-------------------------------------------------------------------------
// From Linking protocol
//-------------------------------------------------------------------------

// --- CreateLink ---

XMPLink* ImplBasePart::CreateLink(XMPPtr data, XMPULong size)
{
XMPUnused(data);
XMPUnused(size);
   return nil;
}

// --- LinkUpdated ---

void ImplBasePart::LinkUpdated(XMPLink* updatedLink, XMPChangeID id)
{
XMPUnused(updatedLink);
XMPUnused(id);
}

// --- RevealLink ---

void ImplBasePart::RevealLink(XMPLinkSource* linkSource)
{
XMPUnused(linkSource);
}

void ImplBasePart::EmbeddedFrameChanged(XMPFrame* frame, XMPChangeID change)
{
XMPUnused(change);
XMPUnused(frame);
}

void ImplBasePart::LinkStatusChanged(XMPFrame* frame)
{
XMPUnused(frame);
}

//-------------------------------------------------------------------------
// From Memory Management protocol
//-------------------------------------------------------------------------

XMPSize ImplBasePart::Purge(XMPSize size)
{
   return size; // return fStorageUnit->Purge(size);
}

//-------------------------------------------------------------------------
// From Part Activation protocol
//-------------------------------------------------------------------------

// --- BeginRelinquishFocus ---

XMPBoolean ImplBasePart::BeginRelinquishFocus(XMPTypeToken focus,
                                 XMPFrame* ownerFrame,
                                 XMPFrame* proposedFrame)
{
XMPUnused(focus);
XMPUnused(ownerFrame);
XMPUnused(proposedFrame);

   return kXMPTrue;
}
   
// --- CommitRelinquishFocus ---

void ImplBasePart::CommitRelinquishFocus(XMPTypeToken focus,
                              XMPFrame* ownerFrame,
                              XMPFrame* proposedFrame)
{
XMPUnused(focus);
XMPUnused(ownerFrame);
XMPUnused(proposedFrame);
}
                     
// --- AbortRelinquishFocus ---

void ImplBasePart::AbortRelinquishFocus(XMPTypeToken focus,
                             XMPFrame* ownerFrame,
                             XMPFrame* proposedFrame)
{
XMPUnused(focus);
XMPUnused(ownerFrame);
XMPUnused(proposedFrame);
}
                       
// --- FocusAcquired ---

void ImplBasePart::FocusAcquired(XMPTypeToken focus, XMPFrame* ownerFrame)
{
XMPUnused(focus);
XMPUnused(ownerFrame);
}  

// --- FocusLost ---

void ImplBasePart::FocusLost(XMPTypeToken focus, XMPFrame* ownerFrame)
{
XMPUnused(focus);
XMPUnused(ownerFrame);
}

//-------------------------------------------------------------------------
// From Storage protocol
//-------------------------------------------------------------------------

// --- Externalize ---

void ImplBasePart::Externalize()
{
   XMPPersistentObject::Externalize();

}

// --- CloneTo ---

void ImplBasePart::CloneInto(XMPDraftKey key, XMPStorageUnit* storageUnit, XMPStorageUnit* initiatingFrameSU)
{
   XMPStorageUnit*   su = this->GetStorageUnit();
   XMPDraft*      draft = su->GetDraft();

XMPVolatile(draft);

   this->Externalize();
   TRY
   
      su->CloneInto(key, storageUnit, initiatingFrameSU);
      
   CATCH_ALL
   
      draft->AbortClone(key);
      
   ENDTRY
}


//-------------------------------------------------------------------------
// From Binding protocol
//-------------------------------------------------------------------------

// --- ExternalizeKinds ---

void ImplBasePart::ExternalizeKinds(XMPTypeSet* kindset)
{
XMPUnused(kindset);
   this->Externalize();
}

// --- ChangeKind ---

void ImplBasePart::ChangeKind(XMPType kind)
{
XMPUnused(kind);
}

//-------------------------------------------------------------------------
// From UI Events protocol
//-------------------------------------------------------------------------


// --- HandleEvent ---

XMPBoolean ImplBasePart::HandleEvent(XMPEventData event, XMPFrame* frame, XMPFacet* facet)
{
XMPUnused(event);
XMPUnused(frame);
XMPUnused(facet);
   return kXMPFalse;
}

// --- MouseEnter ---

void ImplBasePart::MouseEnter(XMPFacet* facet, XMPPoint where)
{
XMPUnused(facet);
XMPUnused(where);
}

// --- MouseWithin ---

void ImplBasePart::MouseWithin(XMPFacet* facet, XMPPoint where)
{
XMPUnused(facet);
XMPUnused(where);
}

// --- MouseLeave ---

void ImplBasePart::MouseLeave(XMPFacet* facet)
{
XMPUnused(facet);
}

// --- AdjustMenus ---

void ImplBasePart::AdjustMenus(XMPFrame* frame)
{
   XMPUnused(frame);
}

//-------------------------------------------------------------------------
// From Undo protocol
//-------------------------------------------------------------------------

// --- UndoAction ---

void ImplBasePart::UndoAction(XMPActionData actionState)
{
XMPUnused(actionState);
}

// --- RedoAction ---

void ImplBasePart::RedoAction(XMPActionData actionState)
{
XMPUnused(actionState);
}

// --- DisposeAction ---

void ImplBasePart::DisposeActionState(XMPActionData actionState,
                           XMPDoneState doneState)
{
XMPUnused(actionState);
XMPUnused(doneState);
}


// --- WriteAction ---

void ImplBasePart::WriteActionState(XMPPtr actionState,
                          XMPStorageUnitView* storageUnitView)
{
XMPUnused(actionState);
XMPUnused(storageUnitView);
}

// --- ReadAction ---

XMPPtr ImplBasePart::ReadActionState(XMPStorageUnitView* storageUnitView)
{
XMPUnused(storageUnitView);
   return kXMPNULL;
}

