/******************************************************************************/
/*                                                                            */
/* COPYRIGHT:                                                                 */
/* ----------                                                                 */
/* Copyright (C) International Business Machines Corp., 1994.                 */
/* Copyright:(C) Apple Computer, Inc., 1994                                   */
/*                                                                            */  
/* DISCLAIMER OF WARRANTIES:                                                  */
/* -------------------------                                                  */
/* The following [enclosed] code is sample code created by IBM                */
/* Corporation.  This sample code is not part of any standard IBM product     */
/* and is provided to you solely for the purpose of assisting you in the      */
/* development of your applications.  The code is provided "AS IS",           */
/* without warranty of any kind.  IBM shall not be liable for any damages     */
/* arising out of your use of the sample code, even if they have been         */
/* advised of the possibility of such damages.                                */
/*                                                                            */
/******************************************************************************/
/* Filename: Clock.h                                                          */
#ifndef _CLOCK_
#define _CLOCK_

#ifndef _CLOCKDEF_
#include "ClockDef.h"
#endif

class Clock
{
public:
       Clock();
       ~Clock();
  HRGN CreateRegion( HPS hps );
  HRGN CreateFaceRegion( HPS hps );
  void Size( const RECTL& rcl, HRGN *hrgnUsed);
  void DrawAnalog();
  void Draw( HPS hps, PPOINTL ptlOffset, HRGN hrgnClip);
  HRGN Timer( HPS hps, PPOINTL ptlOffset, HRGN hrgnClip);
  void UpdateScreen(HPS hps, PPOINTL pptlOffset);
  void DrawHand( HPS hps , SHORT sHandType , SHORT sAngle, LONG vclrFace[], LONG vclrHands[] );
  void DrawFace( HPS hps, LONG vclrFace[] );
  void DrawRing( HPS hps, LONG vclrRing[], LONG vclrFace[] );
  void DrawFullCircle( HPS hps, PPOINTL pptlCenter, FIXED fxRad);
  void DrawDate( HPS hps, USHORT usDrawMode);
  void GetArrangedDate( CHAR achFinalDate[]);
  void DrawTicks ( HPS hps , USHORT usTicks, LONG vclrMajorTicks[], LONG vclrMinorTicks[] );
  void DrawTrapez( HPS hps,POINTL *aptl,LONG color);
  void DrawFullRing( HPS hps,PPOINTL pptlCenter,FIXED fxRadIn, FIXED fxRadOut, LONG lColor);
  void SetRGBColors();
  void ShadeLight( PLONG nplColors);
  BYTE ShadeRGBByte( BYTE brgb);
  BYTE LightRGBByte( BYTE brgb);

private:
  CLKDATA data;
  RECTL rcl;
  RECTL rclPage;

};
#endif
