/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
   File:    XMPTypes.h

   Contains:   Type definition for XMP.

   Written by: Vincent Lo

*/

#ifndef _XMPTYPES_
#define _XMPTYPES_

#ifndef _PLFMTYPE_
#include "PlfmType.h"
#endif

//==============================================================================
// Constants
//==============================================================================

typedef  enum {                     // for Undo protocol 
   kXMPDone,
   kXMPUndone,
   kXMPRedone
} XMPDoneState;

typedef enum {
   kXMPDropFail,
   kXMPDropSucceed,
   kXMPDropUnfinished      // Used only when DragAndDrop::StartDrag returns immediately.
} XMPDropResult;

//==============================================================================
// Scalar Types
//==============================================================================

// Common XMP Types

typedef XMPIText  XMPName;       // Type used for usable visible names.

typedef XMPSByte* XMPISOStr;        // 7 bit ascii. No embedded NULLs. NULL
                              // terminated.

typedef XMPISOStr XMPType;       // Used for storage types, focus types,
                              // data types, etc.

typedef XMPULong  XMPTypeToken;     // Tokenized form of XMPType

typedef XMPULong  XMPID;            // Storage Unit IDs

typedef XMPType      XMPValueType;     // Used to identify the type of the value, e.g., TEXT, PICT and so
                              // on. Obviously, the type doesn't need to be an OSType. 

typedef XMPUByte* TValue;           // Pointer to a stream of bytes.

typedef XMPSLong  XMPError;         // >= 32-bit exception code

typedef XMPULong  XMPToken;         // >= 32-bit unsigned value for tokens

typedef XMPULong  XMPSize;       // >= 32-bit unsigned value for size

typedef XMPULong  XMPInfoType;      // The type for the part info stored in a frame

typedef XMPULong  XMPFlags;         // >= 32-bit unsigned value for flags

typedef  void* XMPContainerID;
typedef  XMPISOStr   XMPContainerName;
typedef XMPISOStr XMPContainerType;

typedef XMPType XMPFocusType;       // This is a string, which can be tokenized

typedef XMPPtr XMPActionData;       // Action data for undo/redo

typedef enum {
   kXMPFrameBehind,
   kXMPFrameInFront
} XMPFramePosition;

typedef enum {
   kXMPTopDown,
   kXMPBottomUp,
   kXMPChildrenOnly
} XMPTraversalType;

typedef enum {
   kXMPFrontToBack,
   kXMPBackToFront
} XMPSiblingOrder;


#endif // _XMPTYPES_
