/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
  File:    XMPSessn.h

  Contains:  XMPSession class definition

  Written by:  Nick Pilch

*/

#ifndef _XMPSESSN_
#define _XMPSESSN_

#ifndef _PLFMDEF_
#include "PlfmDef.h"
#endif

#ifndef _XMPOBJ_
#include "XMPObj.h"
#endif

#ifndef _BASESESS_
#include "BaseSess.h"
#endif

//==============================================================================
// Theory of Operation
//==============================================================================

/*
  This class represents the "system" calls in OpenDoc. A global function
  provides initialization of the OpenDoc environment and returns a reference
  to the one XMPSession object. The member functions of the class
  include accessors for some of the other unique classes in OpenDoc as well
  as a few other system functions.
*/

//==============================================================================
// Constants
//==============================================================================

// Change these names later

const XMPTypeToken kXMPNullTypeToken = (XMPTypeToken) 0;

//==============================================================================
// Classes defined in this interface
//==============================================================================

class  XMPSession;

//==============================================================================
// Classes used by this interface
//==============================================================================

class  XMPWindowState;
class  XMPDispatcher;
class  XMPArbitrator;
class  XMPStorageSystem;
class  XMPClipboard;
class  XMPDragAndDrop;
class  XMPLinkManager;
class  XMPNameSpaceManager;
class  XMPMessageInterface;
class  XMPNameResolver;
class  XMPTranslation;
class  XMPUndo;
class  XMPTokenTable;
class  XMPSemanticInterface;
class  XMPBinding;
class  XMPMacSystemSession;

//==============================================================================
// Functions
//==============================================================================

XMPSession*  OpenXMPSession();

  //  Initialize the OpenDoc environment. An XMPSession object will be
  //  created by this call. The application shell may keep this reference
  //  for convenience

//==============================================================================
// XMPSession
//==============================================================================

#define kXMPSessionID "appl:xmpsession$class,1.0.0"

class XMPSession : public XMPBaseSession
{
  public:
  //JYS:
  static HPS hps;

  //---------------------------------
  // Global Accessors

  XMPVMethod XMPWindowState*      GetWindowState();

  XMPVMethod XMPDispatcher*      GetDispatcher();

  XMPVMethod XMPArbitrator*      GetArbitrator();

  XMPVMethod XMPClipboard*      GetClipboard();

  XMPVMethod XMPDragAndDrop*      GetDragAndDrop();

  XMPVMethod XMPLinkManager*      GetLinkManager();

  XMPVMethod XMPMessageInterface*    GetMessageInterface();

  XMPVMethod XMPNameResolver*      GetNameResolver();

  XMPVMethod XMPTranslation*      GetTranslation();

  XMPVMethod XMPUndo*          GetUndo();

  XMPVMethod XMPBinding*        GetBinding();

  //---------------------------------
  // Semantic Events

  XMPVMethod XMPSemanticInterface*  GetSemanticInterface();

    // Get the system's XMPSemanticInterface object. Changes to this object
    // will affect every other user of semantic events in the system.

  XMPVMethod XMPSemanticInterface*  GetShellSemtInterface();

    // Get the shell's XMPSemanticInterface object. 

  //----------------------------------------------------------
  // Method to create a platform window.  Overriden by shell. 

  XMPVMethod XMPPlatformWindow CreatePlatformWindow() = 0;

  //---------------------------------
  // Types and Token

  XMPVMethod XMPTypeToken  Tokenize(XMPType type);
    
  XMPVMethod void      RemoveEntry(XMPType type);
    
  XMPVMethod XMPBoolean  GetType(XMPTypeToken token, XMPType* type);
    
  //---------------------------------
  // Data Interchange

  XMPVMethod XMPChangeID UniqueChangeID();

  //---------------------------------
  // Shutdown

  XMPVMethod void  Close();

  //  Shut down the OpenDoc environment. The XMPSession object
  //  created by OpenXMPSession will be disposed by this call.

  XMPVMethod XMPSize  Purge(XMPSize size);

  public: // Private by convention

  XMPSession();

  XMPNVMethod void  InitSession();
  XMPVMethod ~XMPSession();

  private:

  XMPWindowState*      fWindowState;
  XMPDispatcher*      fDispatcher;
  XMPArbitrator*      fArbitrator;
  XMPClipboard*      fClipboard;
  XMPDragAndDrop*      fDragAndDrop;
  XMPLinkManager*      fLinkManager;
  XMPMessageInterface*  fMessageInterface;
  XMPNameResolver*    fNameResolver;
  XMPTranslation*      fTranslation;
  XMPUndo*        fUndo;

  //JYS:
  static HDC  hdc;
  static LONG refCnt;


  XMPSemanticInterface*  fSemanticInterface;
  XMPSemanticInterface*  fShellSemtInterface;
  XMPTokenTable*      fTokenTable;
#ifndef ASLMBUILD
  XMPBinding*        fBinding;
#endif
  XMPMacSystemSession*  fSystemSession;
};


#endif // _XMPSESSN_