/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
   File:    WindowM.h

   Contains:   XMPMacWindow

   Written by: Richard Rodseth

*/

#ifndef _WINDOWM_
#define _WINDOWM_

#ifndef _WINDOW_
#include "Window.h"
#endif

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

//=====================================================================================
// Classes defined in this interface
//=====================================================================================

class XMPWindow;

//=====================================================================================
// Classes used by this interface
//=====================================================================================

class XMPFrame;
class XMPPart;
class XMPStorageUnit;
class XMPSession;
class XMPArbitrator;
class XMPDraft;
#ifdef PLATFORM_OS2
class IWindow;
class IFrameWindow;
#else
class AOCEObj;
#endif
//=====================================================================================
// XMPWindow
//=====================================================================================

#define kXMPMacWindowID "appl:xmpmacwindow$class,1.0.0"

class XMPMacWindow : public XMPAbsWindow
{
public:
                           
   XMPMethod XMPSize Purge(XMPSize size); 
   
   XMPMethod XMPPlatformWindow GetPlatformWindow();
   
   XMPMethod void Resized();  
   
   XMPMethod XMPFacet* GetFacetUnderPoint(XMPPoint aPoint); 
   
   // Open/Close
   // ----------

   XMPMethod void Open();
   
   XMPMethod void Close();
   
   XMPMethod void CloseAndRemove();
   
   XMPMethod void Release();

   // Show/Hide
   // ---------
   
   XMPMethod void Show();
   
   XMPMethod void Hide();
   
   XMPMethod XMPBoolean IsShown();
   
   // Layering
   // --------
   
   XMPMethod XMPBoolean IsActive();
      
   // Attributes
   // ----------

   XMPMethod XMPID   GetID();
   
   XMPMethod XMPBoolean IsRootWindow();

   XMPMethod XMPBoolean IsResizable();
   
   XMPMethod   XMPBoolean  IsFloating();

   XMPMethod XMPBoolean ShouldSave();

   XMPMethod void SetShouldSave(XMPBoolean shouldSave);

   XMPMethod XMPBoolean ShouldShowLinks();
      
   XMPMethod void SetShouldShowLinks(XMPBoolean shouldShowLinks);

   XMPMethod XMPFrame* GetSourceFrame();
   
   XMPMethod XMPFrame* GetRootFrame();
   
   XMPMethod XMPFacet* GetRootFacet();

public: // Macintosh-specific

   XMPMethod   void  Select();
   
public: // Private to UI Subsystem

   XMPMacWindow(); 

   XMPVMethod ~XMPMacWindow();   
      // Destructor

   XMPNVMethod void InitWindow(XMPPlatformWindow platformWindow, 
                        XMPBoolean isRootWindow,
                        XMPBoolean isResizable,
                        XMPBoolean isFloating,
                        XMPBoolean shouldSave,
                        XMPPart* rootPart,
                        XMPTypeToken viewType,
                        XMPTypeToken presentation,
                        XMPFrame* sourceFrame);
           
      // Constructor. This window becomes a dependent window of "sourceWindow",
      // which means this window is closed if sourceWindow closes.
      // sourceWindow may be NULL.

   XMPNVMethod void InitWindowFromStorage(XMPStorageUnit* su);

   // These methods are used by the Dispatcher, not by parts

   // AOCE Mailer
   // -----------
   
#ifndef PLATFORM_OS2
   XMPMethod XMPBoolean IsAOCEMailerAware();
   XMPMethod void SetAOCEMailerAware(XMPBoolean newState);
   XMPMethod AOCEObj* GetAOCEObj();                                                                                                                                                                                                                            
   XMPMethod void SetAOCEObj(AOCEObj* theHelper);                                                                                                                                                                                                              
#endif                         
   
   XMPMethod void HandleActivateEvent (XMPEventData theEvent);
   
      // Processes an update event for this window
   
   XMPMethod void HandleUpdateEvent (XMPEventData theEvent);
   
      // Processes an update event for this window
      
   XMPMethod void Update();

#ifndef PLATFORM_OS2
   XMPMethod   void  Activate();
   
   XMPMethod   void  Deactivate();

   XMPMethod XMPPoint GetWindowPoint(Point globalPoint);    

#endif   
   XMPMethod   void  Drag(Point startPoint, Rect* draggingBounds);
   
   XMPMethod void SuspendResume(XMPEventData event);
   
   XMPMethod void SetWindowTitle(char* title);
   
   XMPMethod void SetWasVisible(XMPBoolean wasVisible);
   
   XMPMethod XMPBoolean GetWasVisible();
   
   XMPMethod void Externalize();
      
   XMPMethod void SetID(XMPID windowID);

   XMPMethod XMPStorageUnit* GetStorageUnit();
   
   XMPMethod void SetStorageUnit(XMPStorageUnit* su);
   
   XMPMethod XMPDraft* GetDraft();

protected:

   XMPMethod void CommonInitWindow();
   XMPMethod void CreateRootFrame(XMPTypeToken viewType, XMPTypeToken presentation);
   XMPMethod void CreateRootFacet();
   XMPMethod void DrawActiveBorder(XMPFrame* frame);
#ifndef PLATFORM_OS2
   XMPMethod void PrepareCanvas();
   XMPMethod XMPBoolean HasCloseBox();
   XMPMethod XMPBoolean HasZoomBox();
   XMPMethod XMPBoolean HasGrowBox();
   XMPMethod XMPSLong GetRefCon();
   XMPMethod XMPSShort GetProcID();
#endif
   XMPMethod void GetWindowBounds(Rect& bounds);

protected:

   XMPSession*       fSession;
   XMPFrame*         fSourceFrame;     
#if (defined(PLATFORM_OS2) && defined(UICL))
   IFrameWindow *    frameWnd;
#else
   XMPPlatformWindow fPlatformWindow;
#endif
   XMPFrame*         fRootFrame;
   XMPFacet*         fRootFacet;
   XMPBoolean        fIsRootWindow;
   XMPBoolean        fShouldSave;
   XMPBoolean        fShouldShowLinks;
   XMPBoolean        fIsResizable;
   XMPBoolean        fIsFloating;
   XMPBoolean        fWasVisible; // Used during Internalization. Windows are created
                            // invisible, then shown all at once, so the 
                            // parts can adjust the title without flicker
   XMPArbitrator*    fArbitrator;
   XMPStorageUnit*      fStorageUnit;
   XMPDraft*         fDraft;
   XMPID          fID;
   XMPPart*       fRootPart;
   XMPBoolean        fIsAOCEMailerAware ; // can this window even have a mailer?
#ifndef PLATFORM_OS2
   AOCEObj*       fMailerHelper ;                                                                                                                                                                                                                              
#endif
};

#endif // _WINDOWM_
