/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
   File:    XMPWindow.h

   Contains:   Interface to XMPAbsWindow class

   Written by: Richard Rodseth

*/

#ifndef _WINDOW_
#define _WINDOW_

#ifndef _REFCTOBJ_
#include "RefCtObj.h"
#endif

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

//=====================================================================================
// Classes defined in this interface
//=====================================================================================

class XMPWindow;

//=====================================================================================
// Classes used by this interface
//=====================================================================================

class XMPFacet;
class XMPFrame;
class XMPStorageUnit;

struct XMPPoint;

//=====================================================================================
// XMPWindow
//=====================================================================================

class XMPAbsWindow : public XMPRefCntObject
{  
public:

   XMPAbsWindow(){}  
   
   XMPVMethod ~XMPAbsWindow() {}

   XMPVMethod XMPSize Purge(XMPSize size)
      = 0;
      
   XMPVMethod XMPPlatformWindow GetPlatformWindow()
      = 0;
   
   XMPVMethod XMPFrame* GetSourceFrame()
      = 0;
   
   XMPVMethod XMPFrame* GetRootFrame()
      = 0;
   
   XMPVMethod XMPFacet* GetFacetUnderPoint(XMPPoint aPoint)
      = 0;
   
   XMPVMethod XMPBoolean IsActive()
      = 0;
   
   XMPVMethod void Open()
      = 0;
   
   XMPVMethod void Close()
      = 0;
   
   XMPVMethod void CloseAndRemove()
      = 0;
   
   XMPVMethod void Show()
      = 0;
   
   XMPVMethod void Hide()
      = 0;
   
   XMPVMethod XMPBoolean IsShown()
      = 0;
      
   XMPVMethod XMPBoolean IsResizable()
      = 0;
   
   XMPVMethod XMPBoolean IsRootWindow()
      = 0;

   XMPVMethod XMPBoolean ShouldSave()
      = 0;
      
   XMPVMethod void SetShouldSave(XMPBoolean shouldSave)
      = 0;
      
   XMPVMethod XMPBoolean ShouldShowLinks()
      = 0;
      
   XMPVMethod void SetShouldShowLinks(XMPBoolean shouldShowLinks)
      = 0;

public: // Private by convention
   
   XMPVMethod void HandleActivateEvent(XMPEventData theEvent)
      = 0;
   
   XMPVMethod void HandleUpdateEvent(XMPEventData theEvent)
      = 0;
   
   XMPVMethod void Resized()
      = 0;
};

//#ifdef PLATFORM_MACINTOSH
#ifndef _WindowM_
#include "WindowM.h"
#endif
//#endif

#endif // _WINDOW_
