/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
   File:    TypStItr.h

   Contains:   Class definition for XMPTypeSetIterator.

   Written by: Vincent Lo

*/

#ifndef _TYPSTITR_
#define _TYPSTITR_

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

//=====================================================================================
// Classes defined in this interface
//=====================================================================================
class XMPTypeSetIterator;

//=====================================================================================
// Classes used by this interface
//=====================================================================================
class XMPTypeSet;
class OrderedCollectionIterator;

//=====================================================================================
// Class XMPTypeSetIterator
//=====================================================================================

#define kXMPTypeSetIteratorID "appl:xmptypesetiterator$class,1.0.0"

class XMPTypeSetIterator
{
public:

      XMPTypeSetIterator(XMPTypeSet* typeSet);
      
      virtual ~XMPTypeSetIterator();

      XMPMethod   XMPBoolean  IsNotComplete();
      XMPMethod   XMPType     First();
      XMPMethod   XMPType     Next();
      
private:

      XMPTypeSet*             fTypeSet;
      OrderedCollectionIterator* fIterator;
};

#endif   // _TYPSTITR_
