/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
  File:    TypeLink.h

  Contains:  Class definition for XMPTypeLink.

  Written by:  Vincent Lo

*/

#ifndef _TYPELINK_
#define _TYPELINK_

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

#ifndef _LIST_
#include "List.h"
#endif

//=====================================================================================
// Classes defined in this interface
//=====================================================================================
class XMPTypeLink;

//=====================================================================================
// Classes used by this interface
//=====================================================================================
class XMPPlatformTypeSet;
class OrderedCollectionIterator;

//=====================================================================================
// Class ValueLink - Definition
//=====================================================================================

#define kXMPTypeLinkID "appl:xmptypelink$class,1.0.0"

class XMPTypeLink : public Link {

public:

  XMPTypeLink(XMPType value);    
  virtual ~XMPTypeLink()    {}
  XMPType  GetValue()      { return fValue;}
  void  SetValue(XMPType v)  { fValue = v;}

private:

  XMPType     fValue;
};

#endif  // _TYPELINK_
