/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
  File:    Trnsform.h

  Contains:  Definition of class XMPAbsTransform

  Written by:  Joshua Susser & Sepp Friedrich & Jens Alfke

*/

#ifndef _TRNSFORM_
#define _TRNSFORM_

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

#ifndef _XMPOBJ_
#include "XMPObj.h"      // base class
#endif


//==============================================================================
// Classes defined in this interface
//==============================================================================

class XMPAbsTransform;

//==============================================================================
// Classes used in this interface
//==============================================================================

class XMPTransform;
class XMPStorageUnit;

//==============================================================================
// XMPAbsTransform
//==============================================================================

class XMPAbsTransform : public XMPObject
{
  
public:

  //---------------------------------
  // overrides

//  XMPVMethod XMPSize Purge(XMPSize size);    // override from XMPObject

  //---------------------------------
  // constructor/destructor
  
  XMPAbsTransform() {}

  XMPVMethod ~XMPAbsTransform() {}
  
  //---------------------------------
  // getters/setters:

  XMPMethod XMPGraphicsSystem GetGraphicsSystem()
    = 0;
  XMPMethod XMPPlatformTransform GetPlatformTransform()
    = 0;
  XMPMethod void SetPlatformTransform(XMPGraphicsSystem graphicsSystem,
                       XMPPlatformTransform platformTransform)
    = 0;
  XMPMethod XMPPlatformTransform ConvertTransform(XMPGraphicsSystem graphicsSystem)
    = 0;

  //---------------------------------
  // input / output:
  
  XMPMethod void WritePlatformTransform( XMPStorageUnit* )
    = 0;
  XMPMethod void ReadPlatformTransform( XMPStorageUnit* )
    = 0;

  //---------------------------------
  // geometry operations with transforms

  XMPMethod XMPTransform*  Reset()
    = 0;
  XMPMethod XMPTransform*  Invert()
    = 0;
  XMPMethod XMPTransform*  CopyFrom(XMPTransform* sourceTransform)
    = 0;
  XMPMethod XMPBoolean IsSameAs(XMPTransform* compareTransform)
    = 0;
  XMPMethod XMPTransform*  PreCompose(XMPTransform* transform)
    = 0;
  XMPMethod XMPTransform*  PostCompose(XMPTransform* transform)
    = 0;
  XMPVMethod XMPTransform* MoveBy( XMPPoint )
    = 0;

  //---------------------------------
  // geometry operations with points

  XMPMethod XMPPoint TransformPoint(XMPPoint point)
    = 0;
  XMPMethod XMPPoint InvertPoint(XMPPoint point)
    = 0;
};

#if PLATFORM_MACINTOSH
#ifndef _TRNSFRMM_
#include "TrnsfrmM.h"
#endif
#endif

#endif // _TRNSFORM_