/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
  File:    SUCursor.h

  Contains:  Definition of XMPStorageUnitCursor.

  Written by:  Vincent Lo, Tantek Celik

*/

#ifndef _SUCURSOR_
#define _SUCURSOR_

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

#ifndef _STORAGEU_
#include "StorageU.h"
#endif

//==============================================================================
// Classes defined in this interface
//==============================================================================
class XMPStorageUnitCursor;

//==============================================================================
// XMPStorageUnitCursor
//==============================================================================

#define kXMPStorageUnitCursorID "appl:xmpstorageunitcursor$class,1.0.0"

class XMPStorageUnitCursor
{
public:

  XMPStorageUnitCursor();
  
  virtual  ~XMPStorageUnitCursor();
  
  XMPMethod  void InitStorageUnitCursor(XMPPropertyName propertyName,
                XMPValueType valueType,
                XMPValueIndex valueIndex);
  
  XMPMethod  void GetCursor(XMPPropertyName* propertyName,
                XMPValueType* valueType,
                XMPValueIndex* valueIndex);
                  
private:

  XMPPropertyName    fCurProperty;
  XMPValueType    fCurValueType;
  XMPValueIndex    fCurValue;
};

#endif  // _SUCURSOR_