/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
   File:    StdDispM.h

   Contains:   Definition of standard dispatch module for Macintosh events

*/

#ifndef _STDDISPM_
#define _STDDISPM_

#ifndef _DISPMOD_
#include "DispMod.h"
#endif

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

//=====================================================================================
// Classes defined in this interface
//=====================================================================================

class XMPStandardDispatchModule;

//=====================================================================================
// Classes used by this interface
//=====================================================================================

class XMPWindow;
class XMPWindowState;
class XMPArbitrator;
class XMPDispatcher;
class XMPSession;
class XMPFrame;
class XMPFacet;

//=====================================================================================
// Global Variables
//=====================================================================================

//=====================================================================================
// XMPStandardDispatchModule
//=====================================================================================

#define kXMPStandardDispatchModuleID "appl:xmpstandarddispatchmodule$class,1.0.0"

class XMPStandardDispatchModule : public XMPDispatchModule
{
public:

   XMPStandardDispatchModule();
   
      // Constructor. Clients must call InitStandardDispatchModule
      
   ~XMPStandardDispatchModule();
   
   XMPNVMethod void InitStandardDispatchModule(XMPSession* session);

#ifdef USE_EVENT_TYPES
   XMPMethod XMPBoolean Dispatch(XMPEventData event);
#else
   XMPMethod XMPULong Dispatch(XMPEventData event);
#endif

protected:

   XMPMethod XMPBoolean MouseMoved(XMPEventData theEvent);
#ifndef PLATFORM_OS2
   XMPMethod void DispatchOSEvent(XMPEventData event);
   XMPMethod void SuspendResume(XMPEventData theEvent);
#endif   
   XMPMethod XMPBoolean DispatchMouseDownEvent(XMPEventData event);
   XMPMethod XMPBoolean DispatchMouseUpEvent(XMPEventData event);
   XMPMethod XMPBoolean DispatchMenuEvent (XMPEventData theEvent);
   XMPMethod XMPBoolean DispatchMouseDownInContent (XMPWindow* theWindow,
                                    XMPEventData theEvent)  ;
   XMPMethod XMPBoolean DispatchKeyDownEvent(XMPEventData event);
   XMPMethod XMPBoolean DispatchKeyUpEvent(XMPEventData event);
   
   XMPMethod XMPBoolean DispatchUpdateEvent(XMPEventData event);
   XMPMethod XMPBoolean DispatchActivateEvent(XMPEventData event);

   XMPMethod XMPBoolean DispatchWindowEvent(XMPWindow* window, 
                        short partCode, XMPEventData theEvent);

   XMPMethod XMPBoolean DispatchToFacetUnderPoint(XMPWindow* window, XMPPoint windowPt, XMPEventData theEvent);

   XMPMethod XMPBoolean DispatchTheEvent(XMPEventData theEvent, 
                               XMPFrame* initialFrame, 
                               XMPFacet* initialFacet);
                               
      // Starts at initialFrame. If the fDoesPropagateEvents" flag
      // of the frame is set, containing frames will get a crack.
      
protected:

   // Caches for frequently accessed items
   
   XMPArbitrator*    fArbitrator;
   XMPWindowState* fWindowState;
   XMPDispatcher*    fDispatcher;

   XMPTypeToken fKeyFocusToken;
   XMPTypeToken fMenuFocusToken;
   XMPTypeToken fSelectionFocusToken;
   XMPTypeToken fModalFocusToken;
   XMPTypeToken fScrollingFocusToken;
};

#endif // _STDDISPM_
