/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
   File:    SimplPrt.h

   Contains:   Definition for class SimplePart

   Written by: Joshua Susser

*/


#ifndef _SIMPLPRT_
#define _SIMPLPRT_

#ifndef _PART_
#include "Part.h"
#endif

#ifndef _DRAFT_
#include "Draft.h"   // For XMPDraftKey
#endif


//==============================================================================
// Classes defined in this interface
//==============================================================================

class SimplePart;

//==============================================================================
// Classes used by this interface
//==============================================================================

class XMPPart;

//==============================================================================
// SimplePart
//==============================================================================

#define kSimplePartID "appl:simplepart$class,1.0.0"

class SimplePart : public XMPPart
{

   friend class XMPDraft;

public:

   // overridden functions

   //  ref counting 
   XMPMethod void IncrementRefCount();
   XMPMethod void Release();
   
   //  DragAndDrop 
   XMPVMethod void FulfillPromise(XMPStorageUnitView *promiseSUView);
   XMPVMethod void DropCompleted(XMPPart* destPart, XMPDropResult dropResult);
   XMPVMethod void DragEnter(XMPDragItemIterator* dragInfo,
                       XMPFacet* facet,
                       XMPPoint where);
   XMPVMethod void DragWithin(XMPDragItemIterator* dragInfo,
                        XMPFacet* facet,
                        XMPPoint where);
   XMPVMethod void DragLeave(XMPFacet* facet,
                       XMPPoint where);
   XMPVMethod XMPDropResult Drop(XMPDragItemIterator* dropInfo,
                          XMPFacet* facet,
                          XMPPoint where);

   //  Embedding 
   XMPVMethod void ContainingPartPropertiesChanged(XMPFrame* frame,
                                       XMPStorageUnit* propertyUnit);
   XMPVMethod XMPStorageUnit* GetContainingPartProperties(XMPFrame* frame);
   XMPVMethod void RevealFrame(XMPFrame* embeddedFrame);
   XMPVMethod void EmbeddedFrameSpec(XMPFrame* embeddedFrame, XMPObjectSpec* spec);
   XMPVMethod XMPEmbeddedFramesIterator* CreateEmbeddedFramesIterator();

   //  Frame 
   XMPVMethod void AddDisplayFrame(XMPFrame* frame);
   XMPVMethod void AttachSourceFrame(XMPFrame* frame, XMPFrame* sourceFrame);
   XMPVMethod void RemoveDisplayFrame(XMPFrame* frame);
   XMPVMethod void CloseDisplayFrame(XMPFrame* frame);
   XMPVMethod void FrameShapeChanged(XMPFrame* frame);
   XMPVMethod void ViewTypeChanged(XMPFrame* frame);
   XMPVMethod void PresentationChanged(XMPFrame* frame);
   XMPVMethod void WritePartInfo(XMPPtr partInfo,
                          XMPStorageUnitView* storageUnitView);
   XMPVMethod XMPPtr ReadPartInfo(XMPFrame* frame, XMPStorageUnitView* storageUnitView);
   XMPVMethod XMPID  Open(XMPFrame* frame);
   XMPVMethod XMPFrame* CreateEmbeddedFrame(XMPFrame* containingFrame,
                                  XMPShape* frameShape,
                                  XMPTransform* externalTransform,
                                  XMPPart* embedPart,
                                  XMPTypeToken viewType,
                                  XMPTypeToken presentation,
                                  XMPID frameGroupID,
                                  XMPBoolean isOverlaid);
   XMPVMethod void RemoveEmbeddedFrame(XMPFrame* embeddedFrame);
   XMPVMethod XMPShape* RequestFrameShape(XMPFrame* embeddedFrame, XMPShape* frameShape);
   XMPVMethod void UsedShapeChanged(XMPFrame* embeddedFrame);
   XMPVMethod XMPShape* AdjustBorderShape(XMPFrame* embeddedFrame, XMPShape* shape);

   //  Facet 
   XMPVMethod void FacetAdded(XMPFacet* facet);
   XMPVMethod void FacetRemoved(XMPFacet* facet);
   XMPVMethod void ClipShapeChanged(XMPFacet* facet);
   XMPVMethod void ExternalTransformChanged(XMPFacet* facet);

   //  Imaging 
   XMPVMethod void Draw(XMPFacet* facet, XMPShape* invalidShape);
   XMPVMethod void CanvasUpdated(XMPCanvas* canvas);
   XMPVMethod void HighlightChanged(XMPFrame* frame);
   XMPVMethod XMPULong GetPrintResolution(XMPFrame* frame);

   //  Linking 
   XMPVMethod XMPLink* CreateLink(XMPPtr data, XMPULong size);
   XMPVMethod void LinkUpdated(XMPLink* updatedLink, XMPChangeID id);
   XMPVMethod void RevealLink(XMPLinkSource* linkSource);
   XMPVMethod void EmbeddedFrameChanged(XMPFrame* frame, XMPChangeID change);
   XMPVMethod void LinkStatusChanged(XMPFrame* frame);

   //  Memory Management 
   XMPVMethod XMPSize Purge(XMPSize size);

   //  Part Activation 
   XMPVMethod XMPBoolean BeginRelinquishFocus(XMPTypeToken focus,
                                    XMPFrame* ownerFrame,
                                    XMPFrame* proposedFrame);
   XMPVMethod void CommitRelinquishFocus(XMPTypeToken focus, 
                                XMPFrame* ownerFrame,
                                XMPFrame* proposedFrame);
   XMPVMethod void AbortRelinquishFocus(XMPTypeToken focus,
                               XMPFrame* ownerFrame,
                               XMPFrame* proposedFrame);
   XMPVMethod void FocusAcquired(XMPTypeToken focus, XMPFrame* ownerFrame);
   XMPVMethod void FocusLost(XMPTypeToken focus, XMPFrame* ownerFrame);

   //  Storage 
   XMPVMethod void Externalize();
   XMPVMethod void CloneInto(XMPDraftKey key, XMPStorageUnit* storageUnit, XMPStorageUnit* initiatingFrameSU);

   //  Binding 
   XMPVMethod void ExternalizeKinds(XMPTypeSet* kindset);
   XMPVMethod void ChangeKind(XMPType kind);

   //  UI Events 
   XMPVMethod XMPBoolean HandleEvent(XMPEventData event, XMPFrame* frame, XMPFacet* facet);
   XMPVMethod void MouseEnter(XMPFacet* facet, XMPPoint where);
   XMPVMethod void MouseWithin(XMPFacet* facet, XMPPoint where);
   XMPVMethod void MouseLeave(XMPFacet* facet);
   XMPVMethod void AdjustMenus(XMPFrame* frame);

   //  Undo 
   XMPVMethod void UndoAction(XMPActionData actionState);
   XMPVMethod void RedoAction(XMPActionData actionState);
   XMPVMethod void DisposeActionState(XMPActionData actionState,
                              XMPDoneState doneState);
   XMPVMethod void WriteActionState(XMPPtr actionState,
                            XMPStorageUnitView* storageUnitView);
   XMPVMethod XMPPtr ReadActionState(XMPStorageUnitView* storageUnitView);

protected:

   SimplePart();
   virtual ~SimplePart();

   XMPVMethod  void InitPart(XMPStorageUnit* storageUnit);
   XMPVMethod  void InitPartFromStorage(XMPStorageUnit* storageUnit);

   // data members
   
   XMPSession* fSession;
};

#endif // _SIMPLPRT_
