/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
   File:    ShlEvtHd.h

   Contains:   Shell event handlers (and others, for now)

   Written by: Eric House

*/

#ifndef _SHLEVTHD_
#define _SHLEVTHD_

#ifndef _PLFMDEF_
#include "PlfmDef.h"
#endif

#ifndef _PROPACSR_
#include "PropAcsr.h"
#endif

#ifndef _XMPOBJ_
#include "XMPObj.h"
#endif

#ifndef _FRAME_
#include "Frame.h"
#endif

//==============================================================================
// Theory of Operation
//==============================================================================

/*
   These classes handle events.  They represent the DO on which the event
   will act later.
*/

//==============================================================================
// Constants
//==============================================================================

//==============================================================================
// Scalar Types
//==============================================================================

//==============================================================================
// Classes defined in this interface
//==============================================================================

class ShellEventHandler;
class ShellSaveEventHandler;

//==============================================================================
// Classes used by this interface
//==============================================================================

class PropAccessor;
class XMPShell;
class XMPWindow;

//==============================================================================
// ShellWinPropAccessor
//==============================================================================

class HandlerObject
{
   public:
      HandlerObject( DescType theClass, XMPObject* theObject,
            XMPSLong refCon ) ;
      DescType GetClass() ;
      XMPObject* GetObject() ;
      
      /*virtual*/ void Save( AEDesc* whereFileSpec ) ;
      /*virtual*/ void Close( AEDesc* whereFileSpec, DescType saveOptions ) ;
      /*virtual*/ void CountElements( DescType elemClass, AEDesc* result ) ;
      
   protected:
      DescType fObjectClass ;
      XMPObject* fTheObject ;
      XMPSLong fRefcon ;

} ;

class ShellEventHandler : public HandlerObject
{
   public:
      ShellEventHandler( DescType theClass, XMPObject* theObject,
            XMPSLong refCon ) ;

      void Save( AEDesc* whereFileSpec ) ;
      void Close( AEDesc* whereFileSpec, DescType saveOptions ) ;
      void CountElements( DescType elemClass, AEDesc* result ) ;
};

class PartEventHandler : public HandlerObject
{
   public:
      PartEventHandler( DescType theClass, XMPFrame* frame,
            XMPSLong refCon ) ;

};

#ifdef TO_BE_DELETED
class FrameEventHandler : public HandlerObject
{
   public:
      FrameEventHandler( DescType theClass, XMPFrame* thePart,
            XMPSLong refCon ) ;

};
#endif // TO_BE_DELETED

#endif
